/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class TeleportUtil {
    public static boolean teleport(LivingEntity entity) {
        if (!entity.level().isClientSide() && entity.isAlive()) {
            double d0 = entity.getX() + (entity.getRandom().nextDouble() - 0.5) * 64.0;
            double d1 = entity.getY() + (double)(entity.getRandom().nextInt(64) - 32);
            double d2 = entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * 64.0;
            return TeleportUtil.teleport(entity, d0, d1, d2);
        }
        return false;
    }

    public static boolean teleportTowards(LivingEntity entity, Entity target) {
        Vec3 vec3 = new Vec3(entity.getX() - target.getX(), entity.getY(0.5) - target.getEyeY(), entity.getZ() - target.getZ());
        vec3 = vec3.normalize();
        double d1 = entity.getX() + (entity.getRandom().nextDouble() - 0.5) * 8.0 - vec3.x * 16.0;
        double d2 = entity.getY() + (double)(entity.getRandom().nextInt(16) - 8) - vec3.y * 16.0;
        double d3 = entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * 8.0 - vec3.z * 16.0;
        return TeleportUtil.teleport(entity, d1, d2, d3);
    }

    public static boolean teleport(LivingEntity entity, double x, double y, double z) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(x, y, z);
        while (blockpos$mutableblockpos.getY() > entity.level().getMinBuildHeight() && !entity.level().getBlockState((BlockPos)blockpos$mutableblockpos).blocksMotion()) {
            blockpos$mutableblockpos.move(Direction.DOWN);
        }
        BlockState blockstate = entity.level().getBlockState((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.blocksMotion();
        boolean flag1 = blockstate.getFluidState().is(FluidTags.WATER);
        if (flag && !flag1) {
            Vec3 vec3 = entity.position();
            boolean flag2 = entity.randomTeleport(x, y, z, true);
            if (flag2) {
                entity.level().gameEvent((Holder)GameEvent.TELEPORT, vec3, GameEvent.Context.of((Entity)entity));
                if (!entity.isSilent()) {
                    entity.level().playSound((Player)null, entity.xo, entity.yo, entity.zo, SoundEvents.ENDERMAN_TELEPORT, entity.getSoundSource(), 1.0f, 1.0f);
                    entity.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }
}

