/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.util;

import org.jetbrains.annotations.Nullable;

public record Version(int major, int minor, int patch, @Nullable String suffix) implements Comparable<Version>
{
    public Version(int major, int minor, int patch) {
        this(major, minor, patch, null);
    }

    @Override
    public int compareTo(Version other) {
        if (this.major != other.major) {
            return Integer.compare(this.major, other.major);
        }
        if (this.minor != other.minor) {
            return Integer.compare(this.minor, other.minor);
        }
        if (this.patch != other.patch) {
            return Integer.compare(this.patch, other.patch);
        }
        if (this.suffix == null && other.suffix != null) {
            return 1;
        }
        if (this.suffix != null && other.suffix == null) {
            return -1;
        }
        if (this.suffix == null) {
            return 0;
        }
        return this.suffix.compareTo(other.suffix);
    }

    public static Version parse(String input) {
        String versionPart;
        String suffix = null;
        int suffixIndex = input.indexOf(45);
        if (suffixIndex >= 0) {
            versionPart = input.substring(0, suffixIndex);
            suffix = input.substring(suffixIndex + 1);
        } else {
            versionPart = input;
        }
        String[] parts = versionPart.split("\\.");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Version must be in the format major.minor.patch");
        }
        int major = Integer.parseInt(parts[0]);
        int minor = Integer.parseInt(parts[1]);
        int patch = Integer.parseInt(parts[2]);
        return new Version(major, minor, patch, suffix);
    }
}

