/*
 * Decompiled with CFR 0.152.
 */
package com.predator.common.gameplay.entity.living.yautja.util;

import com.avp.common.registry.tag.AVPItemTags;
import com.avp.common.util.AVPPredicates;
import com.predator.common.gameplay.entity.living.yautja.Yautja;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class YautjaPredicates {
    private YautjaPredicates() {
    }

    public static boolean isThreateningTarget(@NotNull Yautja yautja, @NotNull LivingEntity potentialTarget) {
        return YautjaPredicates.isValidTarget(yautja, potentialTarget);
    }

    public static boolean isValidTarget(@NotNull Yautja yautja, @NotNull LivingEntity potentialTarget) {
        if (potentialTarget instanceof Yautja) {
            return false;
        }
        if (potentialTarget instanceof Creeper) {
            return false;
        }
        if (potentialTarget instanceof Player) {
            Player player = (Player)potentialTarget;
            return !AVPPredicates.IS_IMMORTAL.test((LivingEntity)player) && (player.getMainHandItem().is(AVPItemTags.HOSTILE_WEAPONS) || yautja.getLastAttacker() != null && yautja.getLastAttacker().is((Entity)player));
        }
        if (potentialTarget instanceof Mob || potentialTarget instanceof Monster) {
            return potentialTarget.getMainHandItem().is(AVPItemTags.HOSTILE_WEAPONS) || yautja.getLastAttacker() != null && yautja.getLastAttacker().is((Entity)potentialTarget);
        }
        return yautja.getLastAttacker() != null && yautja.getLastAttacker().is((Entity)potentialTarget);
    }
}

