/*
 * Decompiled with CFR 0.152.
 */
package com.predator.common.gameplay.entity.projectile;

import com.avp.common.registry.init.item.AVPItems;
import com.avp.server.BlockBreakProgressManager;
import com.predator.common.registry.init.PredatorEntityTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class ShurikenProjectile
extends ThrowableItemProjectile {
    public ShurikenProjectile(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public ShurikenProjectile(Level level, LivingEntity livingEntity) {
        super(PredatorEntityTypes.SHURIKEN.get(), livingEntity, level);
    }

    @NotNull
    protected Item getDefaultItem() {
        return AVPItems.SHURIKEN.get();
    }

    public void tick() {
        super.tick();
        if (this.tickCount > 300) {
            this.kill();
        }
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        if (!this.level().isClientSide) {
            BlockBreakProgressManager.damage(this.level(), result.getBlockPos(), 2.0f);
            this.discard();
        }
        super.onHitBlock(result);
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.getOwner() != null) {
                livingEntity.hurt(this.damageSources().thrown(this.getOwner(), (Entity)livingEntity), 5.0f);
            }
        }
        super.onHitEntity(result);
    }
}

