/*
 * Decompiled with CFR 0.152.
 */
package com.predator.common.gameplay.item;

import com.predator.common.gameplay.entity.projectile.SmartDiscProjectile;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SmartDiscItem
extends Item {
    public SmartDiscItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        ItemStack itemInHand = player.getItemInHand(usedHand);
        if (!player.getCooldowns().isOnCooldown((Item)this)) {
            player.getCooldowns().addCooldown((Item)this, 5);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.TRIDENT_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            if (!level.isClientSide) {
                SmartDiscProjectile smartDiscItemEntity = new SmartDiscProjectile(level, (LivingEntity)player);
                smartDiscItemEntity.setItem(itemInHand);
                smartDiscItemEntity.setOwner((Entity)player);
                smartDiscItemEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 3.5f, 1.0f);
                level.addFreshEntity((Entity)smartDiscItemEntity);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            if (!player.getAbilities().instabuild) {
                itemInHand.shrink(1);
            }
            return InteractionResultHolder.sidedSuccess((Object)itemInHand, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.fail((Object)itemInHand);
    }
}

