/*
 * Decompiled with CFR 0.152.
 */
package net.immortaldevs.colorizer;

import net.immortaldevs.colorizer.BlockColor;
import net.immortaldevs.colorizer.Config;
import net.minecraft.class_1769;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4722;
import net.minecraft.class_4730;

public class ColorManager {
    public static final class_4730 WHITE = ColorManager.createChestTextureId("white");
    public static final class_4730 WHITE_LEFT = ColorManager.createChestTextureId("white_left");
    public static final class_4730 WHITE_RIGHT = ColorManager.createChestTextureId("white_right");
    public static final class_4730 LIGHT_GRAY = ColorManager.createChestTextureId("light_gray");
    public static final class_4730 LIGHT_GRAY_LEFT = ColorManager.createChestTextureId("light_gray_left");
    public static final class_4730 LIGHT_GRAY_RIGHT = ColorManager.createChestTextureId("light_gray_right");
    public static final class_4730 GRAY = ColorManager.createChestTextureId("gray");
    public static final class_4730 GRAY_LEFT = ColorManager.createChestTextureId("gray_left");
    public static final class_4730 GRAY_RIGHT = ColorManager.createChestTextureId("gray_right");
    public static final class_4730 BLACK = ColorManager.createChestTextureId("black");
    public static final class_4730 BLACK_LEFT = ColorManager.createChestTextureId("black_left");
    public static final class_4730 BLACK_RIGHT = ColorManager.createChestTextureId("black_right");
    public static final class_4730 BROWN = ColorManager.createChestTextureId("brown");
    public static final class_4730 BROWN_LEFT = ColorManager.createChestTextureId("brown_left");
    public static final class_4730 BROWN_RIGHT = ColorManager.createChestTextureId("brown_right");
    public static final class_4730 RED = ColorManager.createChestTextureId("red");
    public static final class_4730 RED_LEFT = ColorManager.createChestTextureId("red_left");
    public static final class_4730 RED_RIGHT = ColorManager.createChestTextureId("red_right");
    public static final class_4730 ORANGE = ColorManager.createChestTextureId("orange");
    public static final class_4730 ORANGE_LEFT = ColorManager.createChestTextureId("orange_left");
    public static final class_4730 ORANGE_RIGHT = ColorManager.createChestTextureId("orange_right");
    public static final class_4730 YELLOW = ColorManager.createChestTextureId("yellow");
    public static final class_4730 YELLOW_LEFT = ColorManager.createChestTextureId("yellow_left");
    public static final class_4730 YELLOW_RIGHT = ColorManager.createChestTextureId("yellow_right");
    public static final class_4730 LIME = ColorManager.createChestTextureId("lime");
    public static final class_4730 LIME_LEFT = ColorManager.createChestTextureId("lime_left");
    public static final class_4730 LIME_RIGHT = ColorManager.createChestTextureId("lime_right");
    public static final class_4730 GREEN = ColorManager.createChestTextureId("green");
    public static final class_4730 GREEN_LEFT = ColorManager.createChestTextureId("green_left");
    public static final class_4730 GREEN_RIGHT = ColorManager.createChestTextureId("green_right");
    public static final class_4730 CYAN = ColorManager.createChestTextureId("cyan");
    public static final class_4730 CYAN_LEFT = ColorManager.createChestTextureId("cyan_left");
    public static final class_4730 CYAN_RIGHT = ColorManager.createChestTextureId("cyan_right");
    public static final class_4730 LIGHT_BLUE = ColorManager.createChestTextureId("light_blue");
    public static final class_4730 LIGHT_BLUE_LEFT = ColorManager.createChestTextureId("light_blue_left");
    public static final class_4730 LIGHT_BLUE_RIGHT = ColorManager.createChestTextureId("light_blue_right");
    public static final class_4730 BLUE = ColorManager.createChestTextureId("blue");
    public static final class_4730 BLUE_LEFT = ColorManager.createChestTextureId("blue_left");
    public static final class_4730 BLUE_RIGHT = ColorManager.createChestTextureId("blue_right");
    public static final class_4730 PURPLE = ColorManager.createChestTextureId("purple");
    public static final class_4730 PURPLE_LEFT = ColorManager.createChestTextureId("purple_left");
    public static final class_4730 PURPLE_RIGHT = ColorManager.createChestTextureId("purple_right");
    public static final class_4730 MAGENTA = ColorManager.createChestTextureId("magenta");
    public static final class_4730 MAGENTA_LEFT = ColorManager.createChestTextureId("magenta_left");
    public static final class_4730 MAGENTA_RIGHT = ColorManager.createChestTextureId("magenta_right");
    public static final class_4730 PINK = ColorManager.createChestTextureId("pink");
    public static final class_4730 PINK_LEFT = ColorManager.createChestTextureId("pink_left");
    public static final class_4730 PINK_RIGHT = ColorManager.createChestTextureId("pink_right");

    public static class_4730 getColorizedTextureId(class_2586 entity, class_2745 type) {
        String worldName = ColorManager.getLevelName();
        if (worldName == null) {
            return null;
        }
        BlockColor color = ColorManager.getChestColor(worldName, entity, type);
        if (color == null) {
            return null;
        }
        return switch (color) {
            default -> throw new MatchException(null, null);
            case BlockColor.WHITE -> ColorManager.getColorizedTextureId(type, WHITE, WHITE_LEFT, WHITE_RIGHT);
            case BlockColor.LIGHT_GRAY -> ColorManager.getColorizedTextureId(type, LIGHT_GRAY, LIGHT_GRAY_LEFT, LIGHT_GRAY_RIGHT);
            case BlockColor.GRAY -> ColorManager.getColorizedTextureId(type, GRAY, GRAY_LEFT, GRAY_RIGHT);
            case BlockColor.BLACK -> ColorManager.getColorizedTextureId(type, BLACK, BLACK_LEFT, BLACK_RIGHT);
            case BlockColor.BROWN -> ColorManager.getColorizedTextureId(type, BROWN, BROWN_LEFT, BROWN_RIGHT);
            case BlockColor.RED -> ColorManager.getColorizedTextureId(type, RED, RED_LEFT, RED_RIGHT);
            case BlockColor.ORANGE -> ColorManager.getColorizedTextureId(type, ORANGE, ORANGE_LEFT, ORANGE_RIGHT);
            case BlockColor.YELLOW -> ColorManager.getColorizedTextureId(type, YELLOW, YELLOW_LEFT, YELLOW_RIGHT);
            case BlockColor.LIME -> ColorManager.getColorizedTextureId(type, LIME, LIME_LEFT, LIME_RIGHT);
            case BlockColor.GREEN -> ColorManager.getColorizedTextureId(type, GREEN, GREEN_LEFT, GREEN_RIGHT);
            case BlockColor.CYAN -> ColorManager.getColorizedTextureId(type, CYAN, CYAN_LEFT, CYAN_RIGHT);
            case BlockColor.LIGHT_BLUE -> ColorManager.getColorizedTextureId(type, LIGHT_BLUE, LIGHT_BLUE_LEFT, LIGHT_BLUE_RIGHT);
            case BlockColor.BLUE -> ColorManager.getColorizedTextureId(type, BLUE, BLUE_LEFT, BLUE_RIGHT);
            case BlockColor.PURPLE -> ColorManager.getColorizedTextureId(type, PURPLE, PURPLE_LEFT, PURPLE_RIGHT);
            case BlockColor.MAGENTA -> ColorManager.getColorizedTextureId(type, MAGENTA, MAGENTA_LEFT, MAGENTA_RIGHT);
            case BlockColor.PINK -> ColorManager.getColorizedTextureId(type, PINK, PINK_LEFT, PINK_RIGHT);
            case BlockColor.DEFAULT -> null;
        };
    }

    public static class_4730 getColorizedTextureId(class_2745 type, class_4730 normal, class_4730 left, class_4730 right) {
        return switch (type) {
            case class_2745.field_12574 -> left;
            case class_2745.field_12571 -> right;
            default -> normal;
        };
    }

    public static BlockColor getColor(class_2338 pos) {
        String worldName = ColorManager.getLevelName();
        BlockColor color = Config.getColor(worldName, pos);
        if (color == null) {
            return BlockColor.DEFAULT;
        }
        return color;
    }

    public static void updateColor(class_2338 pos, class_1769 dyeItem) {
        String worldName = ColorManager.getLevelName();
        Config.setColor(worldName, pos, BlockColor.fromDyeColor(dyeItem.method_7802()));
    }

    public static void clearColor(class_2338 pos) {
        String worldName = ColorManager.getLevelName();
        Config.removeColor(worldName, pos);
    }

    public static void clearChestColor(class_2338 pos, class_2680 state) {
        class_2350 chestDirection = (class_2350)state.method_11654((class_2769)class_2281.field_10768);
        class_2745 chestType = (class_2745)state.method_11654((class_2769)class_2281.field_10770);
        String worldName = ColorManager.getLevelName();
        Config.removeColor(worldName, pos);
        if (chestType == class_2745.field_12574) {
            class_2338 right = pos.method_10093(chestDirection.method_10170());
            Config.removeColor(worldName, right);
        } else if (chestType == class_2745.field_12571) {
            class_2338 left = pos.method_10093(chestDirection.method_10160());
            Config.removeColor(worldName, left);
        }
    }

    private static BlockColor getChestColor(String worldName, class_2586 entity, class_2745 type) {
        BlockColor color = Config.getColor(worldName, entity.method_11016());
        if (color == null) {
            class_2350 chestDirection = (class_2350)entity.method_11010().method_11654((class_2769)class_2281.field_10768);
            if (type == class_2745.field_12574) {
                class_2338 right = entity.method_11016().method_10093(chestDirection.method_10170());
                color = Config.getColor(worldName, right);
            } else if (type == class_2745.field_12571) {
                class_2338 left = entity.method_11016().method_10093(chestDirection.method_10160());
                color = Config.getColor(worldName, left);
            }
        }
        return color;
    }

    private static String getLevelName() {
        class_310 client = class_310.method_1551();
        if (client.method_1542() && client.method_1576() != null) {
            return client.method_1576().method_27728().method_150();
        }
        if (!client.method_1542() && client.method_1558() != null) {
            return client.method_1558().field_3761;
        }
        return null;
    }

    private static class_4730 createChestTextureId(String variant) {
        return new class_4730(class_4722.field_21709, class_2960.method_60655((String)"colorizer", (String)("entity/chest/" + variant)));
    }
}

