/*
 * Decompiled with CFR 0.152.
 */
package net.immortaldevs.colorizer;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import net.immortaldevs.colorizer.BlockColor;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import org.apache.commons.io.FileUtils;

public class Config {
    private static final HashMap<String, HashMap<class_2338, BlockColor>> values = new HashMap();

    public static BlockColor getColor(String worldName, class_2338 position) {
        if (!values.containsKey(worldName)) {
            return null;
        }
        return values.get(worldName).get(position);
    }

    public static void setColor(String worldName, class_2338 position, BlockColor color) {
        if (!values.containsKey(worldName)) {
            values.put(worldName, new HashMap());
        }
        values.get(worldName).put(position, color);
        Config.save();
    }

    public static void removeColor(String worldName, class_2338 position) {
        if (!values.containsKey(worldName)) {
            return;
        }
        values.get(worldName).remove(position);
        Config.save();
    }

    public static void load() {
        try {
            File file = class_310.method_1551().field_1697.toPath().resolve("config/colorizer.csv").toFile();
            if (!file.exists()) {
                file.createNewFile();
                Config.save();
                return;
            }
            Config.deserialize(FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try {
            File file = class_310.method_1551().field_1697.toPath().resolve("config/colorizer.csv").toFile();
            FileUtils.write((File)file, (CharSequence)Config.serialize(), (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String serialize() {
        StringBuilder builder = new StringBuilder();
        for (String worldName : values.keySet()) {
            for (class_2338 position : values.get(worldName).keySet()) {
                builder.append(worldName).append(";").append(position.method_10263()).append(";").append(position.method_10264()).append(";").append(position.method_10260()).append(";").append(values.get(worldName).get(position).getName()).append("\n");
            }
        }
        return builder.toString();
    }

    private static void deserialize(String data) {
        String[] lines;
        values.clear();
        for (String line : lines = data.split("\n")) {
            String[] parts = line.split(";");
            if (parts.length != 5) continue;
            String worldName = parts[0];
            int x = Integer.parseInt(parts[1]);
            int y = Integer.parseInt(parts[2]);
            int z = Integer.parseInt(parts[3]);
            String color = parts[4];
            values.computeIfAbsent(worldName, k -> new HashMap()).put(new class_2338(x, y, z), BlockColor.fromName(color));
        }
    }
}

