/*
 * Decompiled with CFR 0.152.
 */
package net.theblackcat.timed_modifier_api.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1322;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.theblackcat.timed_modifier_api.helpers.EaseHelper;

public class TimedModifierData {
    public final class_2960 modifierId;
    private final double baseValue;
    private final int maxDuration;
    private int duration;
    private boolean change;
    private double limit;
    private int changeDuration;
    private EaseHelper.EasingTypes easingType;
    public static Codec<TimedModifierData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("modifier_id").forGetter(data -> data.modifierId), (App)Codec.DOUBLE.fieldOf("base_value").forGetter(data -> data.baseValue), (App)Codec.INT.fieldOf("base_duration").forGetter(data -> data.maxDuration), (App)Codec.INT.fieldOf("duration").forGetter(TimedModifierData::getDuration), (App)Codec.BOOL.fieldOf("change").forGetter(TimedModifierData::shouldChange), (App)Codec.DOUBLE.fieldOf("limit").forGetter(TimedModifierData::getChangeLimit), (App)Codec.INT.fieldOf("change_duration").forGetter(data -> data.changeDuration), (App)EaseHelper.EasingTypes.CODEC.fieldOf("easing_type").forGetter(data -> data.easingType)).apply((Applicative)instance, TimedModifierData::new));

    public TimedModifierData(class_1322 modifier, int duration) {
        this(modifier.comp_2447(), modifier.comp_2449(), duration, duration, false, 0.0, 0, EaseHelper.EasingTypes.NONE);
    }

    public TimedModifierData(class_2960 id, double baseValue, int baseDuration, int duration, boolean change, double limit, int changeDuration, EaseHelper.EasingTypes type) {
        this.modifierId = id;
        this.baseValue = baseValue;
        this.maxDuration = baseDuration;
        this.duration = duration;
        this.change = change;
        this.limit = limit;
        this.changeDuration = changeDuration;
        this.easingType = type;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean shouldChange() {
        return this.change;
    }

    public double getChangeLimit() {
        return this.limit;
    }

    public TimedModifierData decay() {
        return this.decay(0.0);
    }

    public TimedModifierData decay(double limit) {
        return this.decay(limit, this.maxDuration);
    }

    public TimedModifierData decay(double limit, int duration) {
        return this.Change(Math.min(this.baseValue, limit), duration);
    }

    public TimedModifierData grow(double limit) {
        return this.grow(limit, this.maxDuration);
    }

    public TimedModifierData grow(double limit, int duration) {
        return this.Change(Math.max(this.baseValue, limit), duration);
    }

    public void ease(EaseHelper.EasingTypes easingType) {
        this.easingType = easingType;
    }

    private TimedModifierData Change(double limit, int duration) {
        this.change = true;
        this.limit = limit;
        this.changeDuration = duration;
        return this;
    }

    public boolean tryRemove() {
        --this.duration;
        return this.duration <= 0;
    }

    public double tryChange() {
        if (this.change) {
            float t = Math.clamp((float)(this.maxDuration - this.duration) / (float)this.changeDuration, 0.0f, 1.0f);
            if (this.easingType != null) {
                t = EaseHelper.evaluate(this.easingType, t);
            }
            return class_3532.method_16436((double)t, (double)this.baseValue, (double)this.limit);
        }
        return this.baseValue;
    }

    public TimedModifierData copy(TimedModifierData data) {
        return new TimedModifierData(data.modifierId, data.baseValue, data.maxDuration, data.getDuration(), data.shouldChange(), data.getChangeLimit(), data.changeDuration, data.easingType);
    }
}

