/*
 * Decompiled with CFR 0.152.
 */
package net.theblackcat.timed_modifier_api.mixin;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5131;
import net.minecraft.class_6880;
import net.theblackcat.timed_modifier_api.api.TimedModifierContainer;
import net.theblackcat.timed_modifier_api.api.TimedModifierData;
import net.theblackcat.timed_modifier_api.interfaces.IAttributeContainer;
import net.theblackcat.timed_modifier_api.interfaces.IAttributeInstance;
import net.theblackcat.timed_modifier_api.interfaces.ITimedModifier;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1309.class})
public class LivingEntityMixin
implements ITimedModifier {
    @Unique
    private HashMap<class_6880<class_1320>, TimedModifierContainer> tempModifierContainers;
    @Unique
    private static final Codec<Map<class_6880<class_1320>, TimedModifierContainer>> MOD_MAP_CODEC = Codec.unboundedMap((Codec)class_1320.field_51575, TimedModifierContainer.CODEC);
    @Unique
    private static final Codec<Map<class_6880<class_1320>, Double>> SET_MAP_CODEC = Codec.unboundedMap((Codec)class_1320.field_51575, (Codec)Codec.DOUBLE);
    @Unique
    private class_1309 self;

    @Inject(method={"<init>(Lnet/minecraft/class_1299;Lnet/minecraft/class_1937;)V"}, at={@At(value="TAIL")})
    private void Initialise(class_1299<? extends class_1309> entityType, class_1937 world, CallbackInfo info) {
        this.self = (class_1309)this;
        this.tempModifierContainers = HashMap.newHashMap(10);
    }

    @Inject(method={"method_5773()V"}, at={@At(value="TAIL")})
    private void Tick(CallbackInfo info) {
        for (TimedModifierContainer container : this.tempModifierContainers.values()) {
            container.tick();
        }
    }

    @Inject(method={"method_5652(Lnet/minecraft/class_11372;)V"}, at={@At(value="TAIL")})
    private void SaveData(class_11372 view, CallbackInfo info) {
        view.method_71468("the_black_cat:temporary_attribute_modifiers", MOD_MAP_CODEC, this.tempModifierContainers);
        class_5131 class_51312 = this.self.method_6127();
        if (class_51312 instanceof IAttributeContainer) {
            IAttributeContainer container = (IAttributeContainer)class_51312;
            HashMap<class_6880, Double> map = HashMap.newHashMap(12);
            for (class_1324 instance : container.GetInstances()) {
                IAttributeInstance ins;
                if (!(instance instanceof IAttributeInstance) || !(ins = (IAttributeInstance)instance).isValueSet()) continue;
                map.put(instance.method_6198(), ins.getValueSet());
            }
            view.method_71468("set_values", SET_MAP_CODEC, map);
        }
    }

    @Inject(method={"method_5749(Lnet/minecraft/class_11368;)V"}, at={@At(value="TAIL")})
    private void ReadData(class_11368 view, CallbackInfo info) {
        class_5131 class_51312;
        IAttributeInstance ins;
        Map map2;
        Map map = view.method_71426("the_black_cat:temporary_attribute_modifiers", MOD_MAP_CODEC).orElse(HashMap.newHashMap(10));
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                if (this.getContainer((class_6880<class_1320>)((class_6880)entry.getKey())) != null) {
                    this.getContainer((class_6880<class_1320>)((class_6880)entry.getKey())).addALl(((TimedModifierContainer)entry.getValue()).getAll());
                    continue;
                }
                this.tempModifierContainers.put((class_6880<class_1320>)((class_6880)entry.getKey()), ((TimedModifierContainer)entry.getValue()).ofInstance(this.self));
            }
        }
        if (!(map2 = (Map)view.method_71426("set_values", SET_MAP_CODEC).orElse(HashMap.newHashMap(0))).isEmpty()) {
            for (Map.Entry object : map2.entrySet()) {
                class_1324 instance = this.self.method_5996((class_6880)object.getKey());
                if (!(instance instanceof IAttributeInstance)) continue;
                ins = (IAttributeInstance)instance;
                ins.set((Double)object.getValue());
            }
        }
        if ((class_51312 = this.self.method_6127()) instanceof IAttributeContainer) {
            IAttributeContainer container = (IAttributeContainer)class_51312;
            for (class_1324 instance : container.GetInstances()) {
                if (!(instance instanceof IAttributeInstance)) continue;
                ins = (IAttributeInstance)instance;
                ins.initEntity(this.self);
            }
        }
    }

    @Override
    public TimedModifierData addModifier(class_6880<class_1320> attribute, class_1322 modifier, int tick) {
        return this.getContainer(attribute).addModifier(modifier, tick);
    }

    @Override
    public TimedModifierData overrideModifier(class_6880<class_1320> attribute, class_1322 modifier, int tick) {
        return this.getContainer(attribute).overrideModifier(modifier, tick);
    }

    @Override
    public void removeModifier(class_6880<class_1320> attribute, class_1322 modifier) {
        this.removeModifier(attribute, modifier.comp_2447());
    }

    @Override
    public void removeModifier(class_6880<class_1320> attribute, class_2960 identifier) {
        if (this.ContainerExists(attribute)) {
            this.getContainer(attribute).removeModifier(identifier);
        }
    }

    @Override
    public class_1322 getModifier(class_6880<class_1320> attribute, class_2960 identifier) {
        if (this.ContainerExists(attribute)) {
            return this.getContainer(attribute).getModifier(identifier);
        }
        return null;
    }

    @Override
    public void clearModifier(class_6880<class_1320> attribute) {
        if (this.ContainerExists(attribute)) {
            this.getContainer(attribute).clearModifiers();
        }
    }

    @Override
    public int getDuration(class_6880<class_1320> attribute, class_2960 identifier) {
        if (this.ContainerExists(attribute)) {
            return this.getContainer(attribute).getDuration(identifier);
        }
        return -1;
    }

    @Override
    public void setValue(class_6880<class_1320> attribute, double value) {
        class_1324 class_13242 = this.self.method_5996(attribute);
        if (class_13242 instanceof IAttributeInstance) {
            IAttributeInstance instance = (IAttributeInstance)class_13242;
            instance.set(value);
        }
    }

    @Override
    public void unsetValue(class_6880<class_1320> attribute) {
        class_1324 class_13242 = this.self.method_5996(attribute);
        if (class_13242 instanceof IAttributeInstance) {
            IAttributeInstance instance = (IAttributeInstance)class_13242;
            instance.unset();
        }
    }

    @Override
    public boolean isValueSet(class_6880<class_1320> attribute) {
        IAttributeInstance instance;
        class_1324 class_13242 = this.self.method_5996(attribute);
        return class_13242 instanceof IAttributeInstance && (instance = (IAttributeInstance)class_13242).isValueSet();
    }

    @Override
    public double getValueSet(class_6880<class_1320> attribute) {
        class_1324 class_13242 = this.self.method_5996(attribute);
        if (class_13242 instanceof IAttributeInstance) {
            IAttributeInstance instance = (IAttributeInstance)class_13242;
            return instance.getValueSet();
        }
        return -1.0;
    }

    @Override
    public TimedModifierContainer getContainer(class_6880<class_1320> attribute) {
        if (!this.ContainerExists(attribute)) {
            this.tempModifierContainers.put(attribute, new TimedModifierContainer(attribute).ofInstance(this.self));
        }
        return this.tempModifierContainers.get(attribute);
    }

    @Unique
    private boolean ContainerExists(class_6880<class_1320> attribute) {
        return this.tempModifierContainers.containsKey(attribute) && this.tempModifierContainers.get(attribute) != null;
    }
}

