/*
 * Decompiled with CFR 0.152.
 */
package net.theblackcat.timed_modifier_api.helpers;

import com.mojang.serialization.Codec;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class EaseHelper {
    private static final Map<EasingTypes, BiFunction<Float, Float, Float>> EASING_MAP = new EnumMap<EasingTypes, BiFunction<Float, Float, Float>>(EasingTypes.class);

    public static float evaluate(EasingTypes easingType, float t) {
        return easingType == EasingTypes.NONE ? t : EASING_MAP.get((Object)easingType).apply(Float.valueOf(t), Float.valueOf(0.0f)).floatValue();
    }

    private static float SineEaseIn(float progress, float amplitude) {
        return 1.0f - (float)Math.cos((double)progress * Math.PI / 2.0);
    }

    private static float SineEaseOut(float progress, float amplitude) {
        return (float)Math.sin((double)progress * Math.PI / 2.0);
    }

    private static float SineEaseBoth(float progress, float amplitude) {
        return -((float)Math.cos(Math.PI * (double)progress) - 1.0f) / 2.0f;
    }

    private static float ExponentialEaseIn(float progress, float amplitude) {
        return (float)Math.pow(progress, amplitude);
    }

    private static float ExponentialEaseOut(float progress, float amplitude) {
        return 1.0f - (float)Math.pow(1.0f - progress, amplitude);
    }

    private static float ExponentialEaseBoth(float progress, float amplitude) {
        return progress < 0.5f ? (float)(Math.pow(2.0, amplitude - 1.0f) * Math.pow(progress, amplitude)) : 1.0f - (float)(Math.pow(-2.0f * progress + 2.0f, amplitude) / 2.0);
    }

    private static float CircEaseIn(float progress, float amplitude) {
        return 1.0f - (float)Math.sqrt(1.0 - Math.pow(progress, 2.0));
    }

    private static float CircEaseOut(float progress, float amplitude) {
        return (float)Math.sqrt(1.0 - Math.pow(progress - 1.0f, 2.0));
    }

    private static float CircEaseBoth(float progress, float amplitude) {
        return progress < 0.5f ? (1.0f - (float)Math.sqrt(1.0 - Math.pow(2.0f * progress, 2.0))) / 2.0f : ((float)Math.sqrt(1.0 - Math.pow(-2.0f * progress + 2.0f, 2.0)) + 1.0f) / 2.0f;
    }

    static {
        EASING_MAP.put(EasingTypes.SINE_IN, EaseHelper::SineEaseIn);
        EASING_MAP.put(EasingTypes.SINE_OUT, EaseHelper::SineEaseOut);
        EASING_MAP.put(EasingTypes.SINE_IN_OUT, EaseHelper::SineEaseBoth);
        EASING_MAP.put(EasingTypes.QUAD_IN, (t, a) -> Float.valueOf(EaseHelper.ExponentialEaseIn(t.floatValue(), 2.0f)));
        EASING_MAP.put(EasingTypes.QUAD_OUT, (t, a) -> Float.valueOf(EaseHelper.ExponentialEaseOut(t.floatValue(), 2.0f)));
        EASING_MAP.put(EasingTypes.QUAD_IN_OUT, (t, a) -> Float.valueOf(EaseHelper.ExponentialEaseBoth(t.floatValue(), 2.0f)));
        EASING_MAP.put(EasingTypes.CUBIC_IN, (t, a) -> Float.valueOf(EaseHelper.ExponentialEaseIn(t.floatValue(), 3.0f)));
        EASING_MAP.put(EasingTypes.CUBIC_OUT, (t, a) -> Float.valueOf(EaseHelper.ExponentialEaseOut(t.floatValue(), 3.0f)));
        EASING_MAP.put(EasingTypes.CUBIC_IN_OUT, (t, a) -> Float.valueOf(EaseHelper.ExponentialEaseBoth(t.floatValue(), 3.0f)));
        EASING_MAP.put(EasingTypes.QUART_IN, (t, a) -> Float.valueOf(EaseHelper.ExponentialEaseIn(t.floatValue(), 4.0f)));
        EASING_MAP.put(EasingTypes.QUART_OUT, (t, a) -> Float.valueOf(EaseHelper.ExponentialEaseOut(t.floatValue(), 4.0f)));
        EASING_MAP.put(EasingTypes.QUART_IN_OUT, (t, a) -> Float.valueOf(EaseHelper.ExponentialEaseBoth(t.floatValue(), 4.0f)));
        EASING_MAP.put(EasingTypes.QUINT_IN, (t, a) -> Float.valueOf(EaseHelper.ExponentialEaseIn(t.floatValue(), 5.0f)));
        EASING_MAP.put(EasingTypes.QUINT_OUT, (t, a) -> Float.valueOf(EaseHelper.ExponentialEaseOut(t.floatValue(), 5.0f)));
        EASING_MAP.put(EasingTypes.QUINT_IN_OUT, (t, a) -> Float.valueOf(EaseHelper.ExponentialEaseBoth(t.floatValue(), 5.0f)));
        EASING_MAP.put(EasingTypes.CIRC_IN, EaseHelper::CircEaseIn);
        EASING_MAP.put(EasingTypes.CIRC_OUT, EaseHelper::CircEaseOut);
        EASING_MAP.put(EasingTypes.CIRC_IN_OUT, EaseHelper::CircEaseBoth);
    }

    public static enum EasingTypes {
        NONE,
        SINE_IN,
        SINE_OUT,
        SINE_IN_OUT,
        QUAD_IN,
        QUAD_OUT,
        QUAD_IN_OUT,
        CUBIC_IN,
        CUBIC_OUT,
        CUBIC_IN_OUT,
        QUART_IN,
        QUART_OUT,
        QUART_IN_OUT,
        QUINT_IN,
        QUINT_OUT,
        QUINT_IN_OUT,
        CIRC_IN,
        CIRC_OUT,
        CIRC_IN_OUT;

        public static final Codec<EasingTypes> CODEC;
        public static final class_9139<class_9129, EasingTypes> PACKET_CODEC;

        static {
            CODEC = Codec.STRING.xmap(str -> {
                try {
                    return EasingTypes.valueOf(str);
                }
                catch (Exception e) {
                    return SINE_IN;
                }
            }, Enum::name);
            PACKET_CODEC = class_9139.method_56437((buf, value) -> buf.method_10814(value.name()), buf -> EasingTypes.valueOf(buf.method_19772()));
        }
    }
}

