/*
 * Decompiled with CFR 0.152.
 */
package net.theblackcat.timed_modifier_api.api;

import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.theblackcat.timed_modifier_api.api.TimedModifierContainer;
import net.theblackcat.timed_modifier_api.api.TimedModifierData;
import net.theblackcat.timed_modifier_api.interfaces.ITimedModifier;

public class TimedModifierAPI {
    public static TimedModifierContainer getContainer(class_1309 entity, class_6880<class_1320> attribute) {
        return TimedModifierAPI.AsITA(entity).getContainer(attribute);
    }

    public static TimedModifierData addModifier(class_1309 entity, class_6880<class_1320> attribute, class_1322 modifier, int duration) {
        TimedModifierAPI.ValidateEntity(entity);
        TimedModifierAPI.ValidateAttribute(attribute);
        return TimedModifierAPI.AsITA(entity).addModifier(attribute, modifier, duration);
    }

    public static TimedModifierData addModifier(class_1309 entity, class_1324 instance, class_1322 modifier, int duration) {
        TimedModifierAPI.ValidateInstance(instance);
        return TimedModifierAPI.addModifier(entity, (class_6880<class_1320>)instance.method_6198(), modifier, duration);
    }

    public static void removeModifier(class_1309 entity, class_6880<class_1320> attribute, class_1322 modifier) {
        TimedModifierAPI.removeModifier(entity, attribute, modifier.comp_2447());
    }

    public static void removeModifier(class_1309 entity, class_6880<class_1320> attribute, class_2960 identifier) {
        TimedModifierAPI.ValidateEntity(entity);
        TimedModifierAPI.ValidateAttribute(attribute);
        TimedModifierAPI.AsITA(entity).removeModifier(attribute, identifier);
    }

    public static void removeModifier(class_1309 entity, class_1324 instance, class_1322 modifier) {
        TimedModifierAPI.ValidateEntity(entity);
        TimedModifierAPI.ValidateInstance(instance);
        TimedModifierAPI.removeModifier(entity, instance, modifier.comp_2447());
    }

    public static void removeModifier(class_1309 entity, class_1324 instance, class_2960 identifier) {
        TimedModifierAPI.removeModifier(entity, (class_6880<class_1320>)instance.method_6198(), identifier);
    }

    public static int getDuration(class_1309 entity, class_6880<class_1320> attribute, class_2960 identifier) {
        int n;
        if (entity instanceof ITimedModifier) {
            ITimedModifier ita = (ITimedModifier)entity;
            n = ita.getDuration(attribute, identifier);
        } else {
            n = 0;
        }
        return n;
    }

    public static void clearModifier(class_1309 entity, class_6880<class_1320> attribute) {
        TimedModifierAPI.AsITA(entity).clearModifier(attribute);
    }

    private static void ValidateEntity(class_1309 entity) {
        if (entity == null) {
            throw new NullPointerException("Entity is null.");
        }
    }

    private static void ValidateInstance(class_1324 instance) {
        if (instance == null) {
            throw new NullPointerException("Entity attribute instance is null.");
        }
    }

    private static void ValidateAttribute(class_6880<class_1320> attribute) {
        if (attribute == null) {
            throw new NullPointerException("Entity attribute is null.");
        }
    }

    private static ITimedModifier AsITA(class_1309 entity) {
        if (entity instanceof ITimedModifier) {
            ITimedModifier ita = (ITimedModifier)entity;
            return ita;
        }
        throw new ClassCastException("This type of entity is not capable of adding temporary attributes.");
    }
}

