/*
 * Decompiled with CFR 0.152.
 */
package net.theblackcat.timed_modifier_api.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.theblackcat.timed_modifier_api.api.TimedModifierData;
import org.jetbrains.annotations.NotNull;

public class TimedModifierContainer {
    public final class_6880<class_1320> attribute;
    private final HashMap<class_2960, TimedModifierData> tempAttributes;
    private class_1324 instance;
    public static final Codec<TimedModifierContainer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1320.field_51575.fieldOf("attribute").forGetter(container -> container.attribute), (App)TimedModifierData.CODEC.listOf().fieldOf("temporary_attribute_data").forGetter(container -> new ArrayList<TimedModifierData>(container.tempAttributes.values()))).apply((Applicative)instance, TimedModifierContainer::new));

    public TimedModifierContainer(class_6880<class_1320> attribute) {
        this(attribute, new ArrayList<TimedModifierData>());
    }

    public TimedModifierContainer(class_6880<class_1320> attribute, List<TimedModifierData> data) {
        this.attribute = attribute;
        this.tempAttributes = HashMap.newHashMap(data.size());
        for (TimedModifierData d : data) {
            this.tempAttributes.put(d.modifierId, d);
        }
    }

    public TimedModifierContainer ofInstance(class_1309 entity) {
        this.instance = this.GetInstance(entity);
        return this;
    }

    public void tick() {
        Iterator<class_2960> it = this.tempAttributes.keySet().iterator();
        while (it.hasNext()) {
            class_2960 id = it.next();
            TimedModifierData data = this.tempAttributes.get(id);
            class_1322 modifier = this.instance.method_6199(id);
            if (modifier == null || data.tryRemove()) {
                this.instance.method_6200(id);
                it.remove();
                continue;
            }
            if (!data.shouldChange()) continue;
            this.instance.method_55696(new class_1322(modifier.comp_2447(), data.tryChange(), modifier.comp_2450()));
        }
    }

    public TimedModifierData addModifier(class_1322 modifier, int duration) {
        this.instance.method_26837(modifier);
        TimedModifierData data = new TimedModifierData(modifier, duration);
        this.tempAttributes.put(modifier.comp_2447(), data);
        return data;
    }

    public boolean removeModifier(class_1322 modifier) {
        return this.removeModifier(modifier.comp_2447());
    }

    public boolean removeModifier(class_2960 identifier) {
        this.tempAttributes.remove(identifier);
        return this.instance.method_6200(identifier);
    }

    public void clearModifiers() {
        for (class_2960 id : this.tempAttributes.keySet()) {
            this.instance.method_6200(id);
        }
        this.tempAttributes.clear();
    }

    public int getDuration(class_2960 identifier) {
        if (this.instance.method_6196(identifier) && this.tempAttributes.containsKey(identifier)) {
            return this.tempAttributes.get(identifier).getDuration();
        }
        return -1;
    }

    public void addALl(List<TimedModifierData> data) {
        for (TimedModifierData d : data) {
            this.tempAttributes.put(d.modifierId, d);
        }
    }

    public List<TimedModifierData> getAll() {
        return this.tempAttributes.values().stream().toList();
    }

    @NotNull
    private class_1324 GetInstance(class_1309 entity) {
        class_1324 instance = entity.method_5996(this.attribute);
        if (instance != null) {
            return instance;
        }
        throw new NullPointerException("This entity doesn't have this attribute.");
    }
}

