/*
 * Decompiled with CFR 0.152.
 */
package net.theblackcat.timed_modifier_api.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1322;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public class TimedModifierData {
    public final class_2960 modifierId;
    private final double baseValue;
    private final int maxDuration;
    private int duration;
    private boolean change;
    private double limit;
    private int changeDuration;
    public static Codec<TimedModifierData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("modifier_id").forGetter(data -> data.modifierId), (App)Codec.DOUBLE.fieldOf("base_value").forGetter(data -> data.baseValue), (App)Codec.INT.fieldOf("base_duration").forGetter(data -> data.maxDuration), (App)Codec.INT.fieldOf("duration").forGetter(TimedModifierData::getDuration), (App)Codec.BOOL.fieldOf("change").forGetter(TimedModifierData::shouldChange), (App)Codec.DOUBLE.fieldOf("limit").forGetter(TimedModifierData::getChangeLimit), (App)Codec.INT.fieldOf("change_duration").forGetter(data -> data.changeDuration)).apply((Applicative)instance, TimedModifierData::new));

    public TimedModifierData(class_1322 modifier, int duration) {
        this(modifier.comp_2447(), modifier.comp_2449(), duration, duration, false, 0.0, 0);
    }

    public TimedModifierData(class_2960 id, double baseValue, int baseDuration, int duration, boolean change, double limit, int changeDuration) {
        this.modifierId = id;
        this.baseValue = baseValue;
        this.maxDuration = baseDuration;
        this.duration = duration;
        this.change = change;
        this.limit = limit;
        this.changeDuration = changeDuration;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean shouldChange() {
        return this.change;
    }

    public double getChangeLimit() {
        return this.limit;
    }

    public void decay() {
        this.decay(0.0);
    }

    public void decay(double limit) {
        this.decay(limit, this.maxDuration);
    }

    public void decay(double limit, int duration) {
        this.Change(Math.min(this.baseValue, limit), duration);
    }

    public void grow(double limit) {
        this.grow(limit, this.maxDuration);
    }

    public void grow(double limit, int duration) {
        this.Change(Math.max(this.baseValue, limit), duration);
    }

    private void Change(double limit, int duration) {
        this.change = true;
        this.limit = limit;
        this.changeDuration = duration;
    }

    public boolean tryRemove() {
        --this.duration;
        return this.duration <= 0;
    }

    public double tryChange() {
        if (this.change) {
            return class_3532.method_16436((double)Math.clamp((float)(this.maxDuration - this.duration) / (float)this.changeDuration, 0.0f, 1.0f), (double)this.baseValue, (double)this.limit);
        }
        return this.baseValue;
    }

    public TimedModifierData copy(TimedModifierData data) {
        return new TimedModifierData(data.modifierId, data.baseValue, data.maxDuration, data.getDuration(), data.shouldChange(), data.getChangeLimit(), data.changeDuration);
    }
}

