/*
 * Decompiled with CFR 0.152.
 */
package net.theblackcat.timed_modifier_api.mixin;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.theblackcat.timed_modifier_api.api.TimedModifierContainer;
import net.theblackcat.timed_modifier_api.api.TimedModifierData;
import net.theblackcat.timed_modifier_api.interfaces.ITimedModifier;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1309.class})
public class LivingEntityMixin
implements ITimedModifier {
    @Unique
    private HashMap<class_6880<class_1320>, TimedModifierContainer> tempModifierContainers;
    @Unique
    private static final Codec<Map<class_6880<class_1320>, TimedModifierContainer>> MOD_MAP_CODEC = Codec.unboundedMap((Codec)class_1320.field_51575, TimedModifierContainer.CODEC);

    @Inject(method={"<init>(Lnet/minecraft/class_1299;Lnet/minecraft/class_1937;)V"}, at={@At(value="TAIL")})
    private void Initialise(class_1299<? extends class_1309> entityType, class_1937 world, CallbackInfo info) {
        this.tempModifierContainers = HashMap.newHashMap(10);
    }

    @Inject(method={"method_5773()V"}, at={@At(value="TAIL")})
    private void Tick(CallbackInfo info) {
        for (TimedModifierContainer container : this.tempModifierContainers.values()) {
            container.tick();
        }
    }

    @Inject(method={"method_5652(Lnet/minecraft/class_11372;)V"}, at={@At(value="TAIL")})
    private void SaveData(class_11372 view, CallbackInfo info) {
        view.method_71468("the_black_cat:temporary_attribute_modifiers", MOD_MAP_CODEC, this.tempModifierContainers);
    }

    @Inject(method={"method_5749(Lnet/minecraft/class_11368;)V"}, at={@At(value="TAIL")})
    private void ReadData(class_11368 view, CallbackInfo info) {
        Map map = view.method_71426("the_black_cat:temporary_attribute_modifiers", MOD_MAP_CODEC).orElse(HashMap.newHashMap(10));
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                if (this.getContainer((class_6880<class_1320>)((class_6880)entry.getKey())) != null) {
                    this.getContainer((class_6880<class_1320>)((class_6880)entry.getKey())).addALl(((TimedModifierContainer)entry.getValue()).getAll());
                    continue;
                }
                this.tempModifierContainers.put((class_6880<class_1320>)((class_6880)entry.getKey()), ((TimedModifierContainer)entry.getValue()).ofInstance(this.GetSelf()));
            }
        }
    }

    @Override
    public TimedModifierData addModifier(class_6880<class_1320> attribute, class_1322 modifier, int tick) {
        return this.getContainer(attribute).addModifier(modifier, tick);
    }

    @Override
    public void removeModifier(class_6880<class_1320> attribute, class_1322 modifier) {
        this.removeModifier(attribute, modifier.comp_2447());
    }

    @Override
    public void removeModifier(class_6880<class_1320> attribute, class_2960 identifier) {
        if (this.ContainerExists(attribute)) {
            this.tempModifierContainers.get(attribute).removeModifier(identifier);
        }
    }

    @Override
    public void clearModifier(class_6880<class_1320> attribute) {
        if (this.ContainerExists(attribute)) {
            this.tempModifierContainers.get(attribute).clearModifiers();
        }
    }

    @Override
    public int getDuration(class_6880<class_1320> attribute, class_2960 identifier) {
        if (this.ContainerExists(attribute)) {
            return this.tempModifierContainers.get(attribute).getDuration(identifier);
        }
        return -1;
    }

    @Override
    public TimedModifierContainer getContainer(class_6880<class_1320> attribute) {
        if (!this.ContainerExists(attribute)) {
            this.tempModifierContainers.put(attribute, new TimedModifierContainer(attribute).ofInstance(this.GetSelf()));
        }
        return this.tempModifierContainers.get(attribute);
    }

    @Unique
    private boolean ContainerExists(class_6880<class_1320> attribute) {
        return this.tempModifierContainers.containsKey(attribute) && this.tempModifierContainers.get(attribute) != null;
    }

    @Unique
    private class_1309 GetSelf() {
        return (class_1309)this;
    }
}

