/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.exporter;

import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.support.AbstractBlockEntityTicker;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalCableBlock;
import com.refinedmods.refinedstorage.common.support.BaseBlockItem;
import com.refinedmods.refinedstorage.common.support.BlockItemProvider;
import com.refinedmods.refinedstorage.common.support.ColorableBlock;
import com.refinedmods.refinedstorage.common.support.DirectionalCableBlockShapes;
import com.refinedmods.refinedstorage.common.support.NetworkNodeBlockItem;
import com.refinedmods.refinedstorage.common.support.network.NetworkNodeBlockEntityTicker;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.exporter.AbstractTieredExporterBlockEntity;
import com.ultramega.cabletiers.common.registry.BlockEntities;
import com.ultramega.cabletiers.common.registry.Blocks;
import com.ultramega.cabletiers.common.utils.BlockEntityTierProvider;
import com.ultramega.cabletiers.common.utils.CableTiersIdentifierUtil;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TieredExporterBlock
extends AbstractDirectionalCableBlock
implements ColorableBlock<TieredExporterBlock, BaseBlockItem>,
EntityBlock,
BlockItemProvider<BaseBlockItem> {
    private static final Component HELP_1 = IdentifierUtil.createTranslation((String)"item", (String)"exporter.help");
    private static final Component HELP_2 = CableTiersIdentifierUtil.createCableTiersTranslation("item", "tiered_cable.help");
    private static final Component HELP_3 = CableTiersIdentifierUtil.createCableTiersTranslation("item", "tiered_cable.help.stack_upgrade");
    private static final ConcurrentHashMap<AbstractDirectionalCableBlock.DirectionalCacheShapeCacheKey, VoxelShape> SHAPE_CACHE = new ConcurrentHashMap();
    private final AbstractBlockEntityTicker<AbstractTieredExporterBlockEntity> ticker;
    private final DyeColor color;
    private final MutableComponent name;
    private final CableTiers tier;
    private final BlockEntityTierProvider<AbstractTieredExporterBlockEntity> blockEntityProvider;

    public TieredExporterBlock(DyeColor color, MutableComponent name, CableTiers tier, BlockEntityTierProvider<AbstractTieredExporterBlockEntity> blockEntityProvider) {
        super(SHAPE_CACHE);
        this.color = color;
        this.name = name;
        this.tier = tier;
        this.blockEntityProvider = blockEntityProvider;
        this.ticker = new NetworkNodeBlockEntityTicker(() -> BlockEntities.INSTANCE.getTieredExporters(tier));
    }

    public DyeColor getColor() {
        return this.color;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.blockEntityProvider.create(this.tier, pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return this.ticker.get(level, type);
    }

    public BlockColorMap<TieredExporterBlock, BaseBlockItem> getBlockColorMap() {
        return Blocks.INSTANCE.getTieredExporters(this.tier);
    }

    protected VoxelShape getExtensionShape(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> DirectionalCableBlockShapes.EXPORTER_NORTH;
            case Direction.EAST -> DirectionalCableBlockShapes.EXPORTER_EAST;
            case Direction.SOUTH -> DirectionalCableBlockShapes.EXPORTER_SOUTH;
            case Direction.WEST -> DirectionalCableBlockShapes.EXPORTER_WEST;
            case Direction.UP -> DirectionalCableBlockShapes.EXPORTER_UP;
            case Direction.DOWN -> DirectionalCableBlockShapes.EXPORTER_DOWN;
        };
    }

    public MutableComponent getName() {
        return this.name;
    }

    public BaseBlockItem createBlockItem() {
        return new NetworkNodeBlockItem((Block)this, null){

            public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
                return Optional.of(new HelpTooltipComponent((Component)Component.literal((String)(HELP_1.getString() + " " + String.format(HELP_2.getString(), TieredExporterBlock.this.tier.getSpeed(CableType.EXPORTER) + "x", TieredExporterBlock.this.tier.getFilterSlotsCount()) + (String)(TieredExporterBlock.this.tier != CableTiers.ELITE ? " " + HELP_3.getString() : "")))));
            }
        };
    }
}

