/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.advancedfilter;

import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceTag;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.cabletiers.common.advancedfilter.AdvancedTagSlot;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import net.minecraft.class_6862;

public class AdvancedTag {
    private static final long EXPAND_COLLAPSE_DELAY = 10L;
    private final ResourceTag tag;
    private final String translationKey;
    private final List<AdvancedTagSlot> mainSlots = new ArrayList<AdvancedTagSlot>();
    private final List<AdvancedTagSlot> overflowSlots = new ArrayList<AdvancedTagSlot>();
    private boolean visible = true;
    private double expandPct;
    private int expandCollapseElapsed;
    @Nullable
    private ExpandCollapse expandCollapse;

    AdvancedTag(ResourceTag tag) {
        this.tag = tag;
        this.translationKey = IdentifierUtil.getTagTranslationKey((class_6862)tag.key());
    }

    List<AdvancedTagSlot> getMainSlots() {
        return this.mainSlots;
    }

    List<AdvancedTagSlot> getOverflowSlots() {
        return this.overflowSlots;
    }

    public ResourceTag getTag() {
        return this.tag;
    }

    class_2960 getId() {
        return this.tag.key().comp_327();
    }

    String getTranslationKey() {
        return this.translationKey;
    }

    List<PlatformResourceKey> getResources() {
        return this.tag.resources();
    }

    double getExpandPct() {
        return this.expandPct;
    }

    boolean expandOrCollapse() {
        if (this.expandCollapse != null) {
            this.expandCollapse = this.expandCollapse == ExpandCollapse.EXPAND ? ExpandCollapse.COLLAPSE : ExpandCollapse.EXPAND;
            this.expandCollapseElapsed = (int)(10L - (long)this.expandCollapseElapsed);
            return this.expandCollapse == ExpandCollapse.EXPAND;
        }
        this.expandCollapse = this.expandPct > 0.0 ? ExpandCollapse.COLLAPSE : ExpandCollapse.EXPAND;
        return this.expandCollapse == ExpandCollapse.EXPAND;
    }

    void update() {
        if (this.expandCollapse == null) {
            return;
        }
        ++this.expandCollapseElapsed;
        if (this.expandCollapse == ExpandCollapse.EXPAND) {
            this.expandPct = (double)this.expandCollapseElapsed / 10.0;
            if (this.expandPct >= 1.0) {
                this.stopExpandCollapse();
            }
        } else {
            this.expandPct = 1.0 - (double)this.expandCollapseElapsed / 10.0;
            if (this.expandPct <= 0.0) {
                this.stopExpandCollapse();
            }
        }
    }

    boolean isVisible() {
        return this.visible;
    }

    void setVisible(boolean visible) {
        this.visible = visible;
    }

    private void stopExpandCollapse() {
        this.expandPct = this.expandCollapse == ExpandCollapse.EXPAND ? 1.0 : 0.0;
        this.expandCollapseElapsed = 0;
        this.expandCollapse = null;
    }

    private static enum ExpandCollapse {
        EXPAND,
        COLLAPSE;

    }
}

