/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.fabric;

import com.refinedmods.refinedstorage.common.AbstractClientModInitializer;
import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.support.packet.PacketHandler;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.fabric.support.render.EmissiveModelRegistry;
import com.refinedmods.refinedstorage.fabric.support.render.QuadRotators;
import com.ultramega.cabletiers.common.AbstractClientModInitializer;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.packet.s2c.ReplaceSidedResourceOnPatternGridMenuPacket;
import com.ultramega.cabletiers.common.packet.s2c.SetSidedResourcesOnPatternGridMenuPacket;
import com.ultramega.cabletiers.common.packet.s2c.ShouldOpenAdvancedFilterPacket;
import com.ultramega.cabletiers.common.packet.s2c.TieredAutocrafterLockedUpdatePacket;
import com.ultramega.cabletiers.common.packet.s2c.TieredAutocrafterNameUpdatePacket;
import com.ultramega.cabletiers.common.packet.s2c.UpdateAdvancedFilterPacket;
import com.ultramega.cabletiers.common.registry.BlockEntities;
import com.ultramega.cabletiers.common.registry.Blocks;
import com.ultramega.cabletiers.common.storage.diskinterface.TieredDiskInterfaceBlock;
import com.ultramega.cabletiers.common.utils.CableTiersIdentifierUtil;
import com.ultramega.cabletiers.fabric.storage.diskinterface.TieredDiskInterfaceBlockEntityRendererImpl;
import com.ultramega.cabletiers.fabric.storage.diskinterface.TieredDiskInterfaceUnbakedModel;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_437;
import net.minecraft.class_5616;
import net.minecraft.class_8710;

public class ClientModInitializerImpl
extends AbstractClientModInitializer
implements ClientModInitializer {
    private static final String BLOCK_PREFIX = "block";
    private static final String ITEM_PREFIX = "item";

    public void onInitializeClient() {
        this.setRenderLayers();
        this.registerEmissiveModels();
        this.registerPacketHandlers();
        this.registerBlockEntityRenderers();
        this.registerCustomModels();
        ClientModInitializerImpl.registerScreens(new AbstractClientModInitializer.ScreenRegistration(this){

            public <M extends class_1703, U extends class_437> void register(class_3917<? extends M> type, AbstractClientModInitializer.ScreenConstructor<M, U> factory) {
                class_3929.method_17542(type, (arg_0, arg_1, arg_2) -> factory.create(arg_0, arg_1, arg_2));
            }
        });
    }

    private void setRenderLayers() {
        for (CableTiers tier : CableTiers.values()) {
            this.setCutout(Blocks.INSTANCE.getTieredImporters(tier));
            this.setCutout(Blocks.INSTANCE.getTieredExporters(tier));
            this.setCutout(Blocks.INSTANCE.getTieredConstructors(tier));
            this.setCutout(Blocks.INSTANCE.getTieredDestructors(tier));
            this.setCutout(Blocks.INSTANCE.getTieredDiskInterfaces(tier));
            this.setCutout(Blocks.INSTANCE.getTieredAutocrafters(tier));
        }
    }

    private void setCutout(BlockColorMap<?, ?> blockMap) {
        blockMap.values().forEach(x$0 -> this.setCutout((class_2248)x$0));
    }

    private void setCutout(class_2248 block) {
        BlockRenderLayerMap.INSTANCE.putBlock(block, class_1921.method_23581());
    }

    private void registerEmissiveModels() {
        for (CableTiers tier : CableTiers.values()) {
            this.registerConstructorDestructorEmissiveModels(tier, Blocks.INSTANCE.getTieredConstructors(tier), "constructor");
            this.registerConstructorDestructorEmissiveModels(tier, Blocks.INSTANCE.getTieredDestructors(tier), "destructor");
            Blocks.INSTANCE.getTieredAutocrafters(tier).forEach((color, id, block) -> this.registerEmissiveAutocrafterModels(tier, color, id));
        }
    }

    private void registerConstructorDestructorEmissiveModels(CableTiers tier, BlockColorMap<?, ?> blockMap, String blockDirectory) {
        blockMap.forEach((color, id, block) -> {
            class_2960 blockModelLocation = CableTiersIdentifierUtil.createCableTiersIdentifier("block/" + tier.getLowercaseName() + "_" + blockDirectory + "/active");
            class_2960 spriteLocation = IdentifierUtil.createIdentifier((String)("block/" + blockDirectory + "/cutouts/active"));
            EmissiveModelRegistry.INSTANCE.register(blockModelLocation, new class_2960[]{spriteLocation});
            EmissiveModelRegistry.INSTANCE.register(CableTiersIdentifierUtil.createCableTiersIdentifier("item/" + id.method_12832()), new class_2960[]{spriteLocation});
        });
    }

    private void registerEmissiveAutocrafterModels(CableTiers tier, class_1767 color, class_2960 id) {
        EmissiveModelRegistry.INSTANCE.register(CableTiersIdentifierUtil.createCableTiersIdentifier("block/" + tier.getLowercaseName() + "_autocrafter/" + color.method_7792()), new class_2960[]{CableTiersIdentifierUtil.createCableTiersIdentifier("block/autocrafter/cutouts/side_color/" + color.method_7792()), CableTiersIdentifierUtil.createCableTiersIdentifier("block/autocrafter/cutouts/side_tier/" + color.method_7792()), CableTiersIdentifierUtil.createCableTiersIdentifier("block/autocrafter/cutouts/top_color/" + color.method_7792()), CableTiersIdentifierUtil.createCableTiersIdentifier("block/autocrafter/cutouts/top_tier/" + color.method_7792())});
        EmissiveModelRegistry.INSTANCE.register(CableTiersIdentifierUtil.createCableTiersIdentifier("item/" + id.method_12832()), new class_2960[]{CableTiersIdentifierUtil.createCableTiersIdentifier("block/autocrafter/cutouts/side_color/" + color.method_7792()), CableTiersIdentifierUtil.createCableTiersIdentifier("block/autocrafter/cutouts/side_tier/" + color.method_7792()), CableTiersIdentifierUtil.createCableTiersIdentifier("block/autocrafter/cutouts/top_color/" + color.method_7792()), CableTiersIdentifierUtil.createCableTiersIdentifier("block/autocrafter/cutouts/top_tier/" + color.method_7792())});
    }

    private void registerPacketHandlers() {
        ClientPlayNetworking.registerGlobalReceiver(ShouldOpenAdvancedFilterPacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler(ShouldOpenAdvancedFilterPacket::handle));
        ClientPlayNetworking.registerGlobalReceiver(UpdateAdvancedFilterPacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler(UpdateAdvancedFilterPacket::handle));
        ClientPlayNetworking.registerGlobalReceiver(TieredAutocrafterLockedUpdatePacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler(TieredAutocrafterLockedUpdatePacket::handle));
        ClientPlayNetworking.registerGlobalReceiver(TieredAutocrafterNameUpdatePacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler(TieredAutocrafterNameUpdatePacket::handle));
        ClientPlayNetworking.registerGlobalReceiver(SetSidedResourcesOnPatternGridMenuPacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler(SetSidedResourcesOnPatternGridMenuPacket::handle));
        ClientPlayNetworking.registerGlobalReceiver(ReplaceSidedResourceOnPatternGridMenuPacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler(ReplaceSidedResourceOnPatternGridMenuPacket::handle));
    }

    private void registerBlockEntityRenderers() {
        for (CableTiers tier : CableTiers.values()) {
            class_5616.method_32144(BlockEntities.INSTANCE.getTieredDiskInterfaces(tier), ctx -> new TieredDiskInterfaceBlockEntityRendererImpl());
        }
    }

    private void registerCustomModels() {
        QuadRotators quadRotators = new QuadRotators();
        ModelLoadingPlugin.register(pluginContext -> this.registerCustomTieredDiskInterfaceModels(pluginContext, quadRotators));
    }

    private void registerCustomTieredDiskInterfaceModels(ModelLoadingPlugin.Context pluginContext, QuadRotators quadRotators) {
        for (CableTiers tier : CableTiers.values()) {
            pluginContext.resolveModel().register(context -> {
                if (context.id().method_12836().equals("cabletiers") && context.id().method_12832().startsWith("item/") && context.id().method_12832().endsWith(tier.getLowercaseName() + "_disk_interface")) {
                    boolean isDefault = !context.id().method_12832().endsWith("_" + tier.getLowercaseName() + "_disk_interface");
                    class_1767 color = isDefault ? ((TieredDiskInterfaceBlock)((Object)((Object)Blocks.INSTANCE.getTieredDiskInterfaces(tier).getDefault()))).getColor() : class_1767.method_7793((String)context.id().method_12832().replace("_" + tier.getLowercaseName() + "_disk_interface", "").replace("item/", ""), (class_1767)((TieredDiskInterfaceBlock)((Object)((Object)Blocks.INSTANCE.getTieredDiskInterfaces(tier).getDefault()))).getColor());
                    return new TieredDiskInterfaceUnbakedModel(quadRotators, color, tier);
                }
                if (context.id().method_12836().equals("cabletiers") && context.id().method_12832().startsWith("block/" + tier.getLowercaseName() + "_disk_interface/") && !context.id().method_12832().startsWith("block/" + tier.getLowercaseName() + "_disk_interface/base_") && !context.id().method_12832().equals("block/" + tier.getLowercaseName() + "_disk_interface/inactive")) {
                    class_1767 color = class_1767.method_7793((String)context.id().method_12832().replace("block/" + tier.getLowercaseName() + "_disk_interface/", ""), (class_1767)((TieredDiskInterfaceBlock)((Object)((Object)Blocks.INSTANCE.getTieredDiskInterfaces(tier).getDefault()))).getColor());
                    return new TieredDiskInterfaceUnbakedModel(quadRotators, color, tier);
                }
                return null;
            });
        }
    }

    private static <T extends class_8710> ClientPlayNetworking.PlayPayloadHandler<T> wrapHandler(PacketHandler<T> handler) {
        return (packet, ctx) -> handler.handle((Object)packet, () -> ((ClientPlayNetworking.Context)ctx).player());
    }
}

