/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.autocrafting.autocrafter;

import com.google.common.util.concurrent.RateLimiter;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.autocrafting.PatternInventory;
import com.refinedmods.refinedstorage.common.autocrafting.PatternSlot;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterData;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.LockMode;
import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.Property;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeSlot;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.AutocrafterPropertyTypes;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.ImportMode;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.TieredAutocrafterBlockEntity;
import com.ultramega.cabletiers.common.packet.c2s.TieredAutocrafterNameChangePacket;
import com.ultramega.cabletiers.common.packet.s2c.TieredAutocrafterLockedUpdatePacket;
import com.ultramega.cabletiers.common.packet.s2c.TieredAutocrafterNameUpdatePacket;
import com.ultramega.cabletiers.common.registry.Menus;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class TieredAutocrafterContainerMenu
extends AbstractBaseContainerMenu {
    private static final int PATTERN_SLOT_X = 8;
    private static final int PATTERN_SLOT_Y = 20;
    private final CableTiers tier;
    private final class_1657 player;
    private final boolean partOfChain;
    private final boolean headOfChain;
    private boolean locked;
    private final RateLimiter nameRateLimiter = RateLimiter.create((double)0.5);
    @Nullable
    private TieredAutocrafterBlockEntity autocrafter;
    @Nullable
    private AutocrafterContainerMenu.Listener listener;
    private class_2561 name;

    public TieredAutocrafterContainerMenu(int syncId, class_1661 playerInventory, AutocrafterData data, CableTiers tier) {
        super(Menus.INSTANCE.getTieredAutocrafters(tier), syncId);
        this.tier = tier;
        this.player = playerInventory.field_7546;
        this.registerProperty((Property)new ClientProperty(AutocrafterPropertyTypes.LOCK_MODE, (Object)LockMode.NEVER));
        this.registerProperty((Property)new ClientProperty(AutocrafterPropertyTypes.PRIORITY, (Object)0));
        this.registerProperty((Property)new ClientProperty(AutocrafterPropertyTypes.VISIBLE_TO_THE_AUTOCRAFTER_MANAGER, (Object)true));
        this.registerProperty((Property)new ClientProperty(AutocrafterPropertyTypes.IMPORT_MODE, (Object)ImportMode.DONT_IMPORT));
        this.addSlots((FilteredContainer)new PatternInventory(tier.getFilterSlotsCount(), () -> ((class_1657)playerInventory.field_7546).method_37908()), new UpgradeContainer((UpgradeDestination)UpgradeDestinations.AUTOCRAFTER));
        this.name = class_2561.method_43473();
        this.partOfChain = data.partOfChain();
        this.headOfChain = data.headOfChain();
        this.locked = data.locked();
    }

    public TieredAutocrafterContainerMenu(int syncId, class_1661 playerInventory, TieredAutocrafterBlockEntity autocrafter, CableTiers tier) {
        super(Menus.INSTANCE.getTieredAutocrafters(tier), syncId);
        this.tier = tier;
        this.autocrafter = autocrafter;
        this.player = playerInventory.field_7546;
        this.name = autocrafter.method_5476();
        this.partOfChain = false;
        this.headOfChain = false;
        this.locked = autocrafter.isLocked();
        this.registerProperty((Property)new ServerProperty(AutocrafterPropertyTypes.LOCK_MODE, autocrafter::getLockMode, autocrafter::setLockMode));
        this.registerProperty((Property)new ServerProperty(AutocrafterPropertyTypes.PRIORITY, autocrafter::getPriority, autocrafter::setPriority));
        this.registerProperty((Property)new ServerProperty(AutocrafterPropertyTypes.VISIBLE_TO_THE_AUTOCRAFTER_MANAGER, autocrafter::isVisibleToTheAutocrafterManager, autocrafter::setVisibleToTheAutocrafterManager));
        this.registerProperty((Property)new ServerProperty(AutocrafterPropertyTypes.IMPORT_MODE, autocrafter::getImportMode, autocrafter::setImportMode));
        this.addSlots(autocrafter.getPatternContainer(), autocrafter.getUpgradeContainer());
    }

    boolean canChangeName() {
        return !this.partOfChain;
    }

    boolean isPartOfChain() {
        return this.partOfChain;
    }

    boolean isHeadOfChain() {
        return this.headOfChain;
    }

    boolean isLocked() {
        return this.locked;
    }

    void setListener(@Nullable AutocrafterContainerMenu.Listener listener) {
        this.listener = listener;
    }

    public void method_7623() {
        boolean newLocked;
        super.method_7623();
        if (this.autocrafter == null) {
            return;
        }
        if (this.nameRateLimiter.tryAcquire()) {
            this.detectNameChange();
        }
        if (this.locked != (newLocked = this.autocrafter.isLocked())) {
            this.locked = newLocked;
            Platform.INSTANCE.sendPacketToClient((class_3222)this.player, (class_8710)new TieredAutocrafterLockedUpdatePacket(this.locked));
        }
    }

    public boolean method_7597(class_1657 p) {
        if (this.autocrafter == null) {
            return true;
        }
        return class_1263.method_49105((class_2586)this.autocrafter, (class_1657)p);
    }

    private void detectNameChange() {
        if (this.autocrafter == null) {
            return;
        }
        class_2561 newName = this.autocrafter.method_5476();
        if (!newName.equals((Object)this.name)) {
            this.name = newName;
            Platform.INSTANCE.sendPacketToClient((class_3222)this.player, (class_8710)new TieredAutocrafterNameUpdatePacket(newName));
        }
    }

    private void addSlots(FilteredContainer patternContainer, UpgradeContainer upgradeContainer) {
        int i;
        for (i = 0; i < patternContainer.method_5439(); ++i) {
            this.method_7621(this.createPatternSlot(patternContainer, i, this.player.method_37908()));
        }
        if (this.tier != CableTiers.CREATIVE) {
            for (i = 0; i < upgradeContainer.method_5439(); ++i) {
                this.method_7621((class_1735)new UpgradeSlot(upgradeContainer, i, 187, 6 + i * 18));
            }
        }
        this.addPlayerInventory(this.player.method_31548(), 8, this.tier.getPlayerInventoryY());
        this.transferManager.addBiTransfer((class_1263)this.player.method_31548(), (class_1263)upgradeContainer);
        this.transferManager.addBiTransfer((class_1263)this.player.method_31548(), (class_1263)patternContainer);
    }

    private class_1735 createPatternSlot(FilteredContainer patternContainer, int i, class_1937 level) {
        int x = 8 + 18 * (i % 9);
        return new PatternSlot((class_1263)patternContainer, i, x, 20 + 18 * (i / 9), level);
    }

    public boolean containsPattern(class_1799 stack) {
        for (class_1735 slot : this.field_7761) {
            PatternSlot patternSlot;
            if (!(slot instanceof PatternSlot) || (patternSlot = (PatternSlot)slot).method_7677() != stack) continue;
            return true;
        }
        return false;
    }

    public void changeName(String newName) {
        if (this.partOfChain) {
            return;
        }
        if (this.autocrafter != null) {
            this.autocrafter.setCustomName(newName);
            this.detectNameChange();
        } else {
            Platform.INSTANCE.sendPacketToServer((class_8710)new TieredAutocrafterNameChangePacket(newName));
        }
    }

    public void nameChanged(class_2561 newName) {
        if (this.listener != null) {
            this.listener.nameChanged(newName);
        }
    }

    public void lockedChanged(boolean newLocked) {
        this.locked = newLocked;
        if (this.listener != null) {
            this.listener.lockedChanged(newLocked);
        }
    }
}

