/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.iface;

import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.content.BlockConstants;
import com.refinedmods.refinedstorage.common.support.AbstractBaseBlock;
import com.refinedmods.refinedstorage.common.support.AbstractBlockEntityTicker;
import com.refinedmods.refinedstorage.common.support.NetworkNodeBlockItem;
import com.refinedmods.refinedstorage.common.support.network.NetworkNodeBlockEntityTicker;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.iface.TieredInterfaceBlockEntity;
import com.ultramega.cabletiers.common.registry.BlockEntities;
import com.ultramega.cabletiers.common.utils.CableTiersIdentifierUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class TieredInterfaceBlock
extends AbstractBaseBlock
implements EntityBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    private static final Component HELP_1 = IdentifierUtil.createTranslation((String)"item", (String)"interface.help");
    private static final Component HELP_2 = CableTiersIdentifierUtil.createCableTiersTranslation("item", "tiered_interface.help");
    private final AbstractBlockEntityTicker<TieredInterfaceBlockEntity> ticker;
    private final CableTiers tier;

    public TieredInterfaceBlock(CableTiers tier) {
        super(BlockConstants.PROPERTIES);
        this.tier = tier;
        this.ticker = new NetworkNodeBlockEntityTicker(() -> BlockEntities.INSTANCE.getTieredInterfaces(tier), ACTIVE);
    }

    protected BlockState getDefaultState() {
        return (BlockState)super.getDefaultState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ACTIVE});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TieredInterfaceBlockEntity(this.tier, pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return this.ticker.get(level, type);
    }

    public BlockItem createBlockItem() {
        return new NetworkNodeBlockItem((Block)this, null){

            public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
                return Optional.of(new HelpTooltipComponent((Component)Component.literal((String)(HELP_1.getString() + " " + String.format(HELP_2.getString(), TieredInterfaceBlock.this.tier.getTransferQuotaMultiplier(CableType.INTERFACE) + "x", TieredInterfaceBlock.this.tier.getInterfaceSlotsCount())))));
            }
        };
    }
}

