/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.exporter;

import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.exporter.ExporterData;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.SchedulingModeType;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.Property;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicator;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicatorListener;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.exporter.AbstractTieredExporterBlockEntity;
import com.ultramega.cabletiers.common.exporter.TieredExportingIndicators;
import com.ultramega.cabletiers.common.registry.Menus;
import com.ultramega.cabletiers.common.support.AbstractTieredFilterContainerMenu;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TieredExporterContainerMenu
extends AbstractTieredFilterContainerMenu<AbstractTieredExporterBlockEntity>
implements ExportingIndicatorListener {
    private static final MutableComponent FILTER_HELP = IdentifierUtil.createTranslation((String)"gui", (String)"exporter.filter_help");
    private final TieredExportingIndicators indicators;
    private final Predicate<Player> stillValid;

    public TieredExporterContainerMenu(int syncId, Inventory playerInventory, ExporterData data, CableTiers tier) {
        super(Menus.INSTANCE.getTieredExporters(tier), syncId, playerInventory.player, data.resourceContainerData(), AbstractTieredExporterBlockEntity.getUpgradeDestination(tier), tier.getPlayerInventoryY(), (Component)FILTER_HELP, tier);
        this.indicators = new TieredExportingIndicators(data.exportingIndicators());
        this.stillValid = p -> true;
    }

    TieredExporterContainerMenu(int syncId, Player player, AbstractTieredExporterBlockEntity blockEntity, ResourceContainer filterContainer, UpgradeContainer upgradeContainer, TieredExportingIndicators indicators, CableTiers tier) {
        super(Menus.INSTANCE.getTieredExporters(tier), syncId, player, filterContainer, upgradeContainer, blockEntity, tier.getPlayerInventoryY(), (Component)FILTER_HELP, tier);
        this.indicators = indicators;
        this.stillValid = p -> Container.stillValidBlockEntity((BlockEntity)blockEntity, (Player)p);
    }

    ExportingIndicator getIndicator(int idx) {
        return this.indicators.get(idx);
    }

    int getIndicators() {
        return this.indicators.size();
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.indicators.detectChanges(serverPlayer);
        }
    }

    @Override
    protected void registerClientProperties() {
        this.registerProperty((Property)new ClientProperty(PropertyTypes.FUZZY_MODE, (Object)false));
        this.registerProperty((Property)new ClientProperty(PropertyTypes.REDSTONE_MODE, (Object)RedstoneMode.IGNORE));
        this.registerProperty((Property)new ClientProperty(PropertyTypes.SCHEDULING_MODE, (Object)SchedulingModeType.DEFAULT));
    }

    @Override
    protected void registerServerProperties(AbstractTieredExporterBlockEntity blockEntity) {
        this.registerProperty((Property)new ServerProperty(PropertyTypes.FUZZY_MODE, blockEntity::isFuzzyMode, blockEntity::setFuzzyMode));
        this.registerProperty((Property)new ServerProperty(PropertyTypes.REDSTONE_MODE, () -> ((AbstractTieredExporterBlockEntity)blockEntity).getRedstoneMode(), arg_0 -> ((AbstractTieredExporterBlockEntity)blockEntity).setRedstoneMode(arg_0)));
        this.registerProperty((Property)new ServerProperty(PropertyTypes.SCHEDULING_MODE, blockEntity::getSchedulingModeType, blockEntity::setSchedulingModeType));
    }

    public void indicatorChanged(int index, ExportingIndicator indicator) {
        this.indicators.set(index, indicator);
    }

    public boolean stillValid(Player player) {
        return this.stillValid.test(player);
    }
}

