/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.mixin;

import com.mojang.serialization.DynamicOps;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridBlockEntity;
import com.refinedmods.refinedstorage.common.grid.AbstractGridBlockEntity;
import com.ultramega.cabletiers.common.autocrafting.sidedinput.SidedInputPatternState;
import com.ultramega.cabletiers.common.autocrafting.sidedinput.SidedResourceAmount;
import com.ultramega.cabletiers.common.registry.DataComponents;
import com.ultramega.cabletiers.common.utils.SidedInput;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PatternGridBlockEntity.class})
public abstract class MixinPatternGridBlockEntity
extends AbstractGridBlockEntity
implements SidedInput {
    @Unique
    private static final String TAG_SIDED_RESOURCES = "sided_resources";
    @Unique
    private List<Optional<SidedResourceAmount>> cabletiers$sidedResources = new ArrayList<Optional<SidedResourceAmount>>();

    protected MixinPatternGridBlockEntity(BlockEntityType<? extends AbstractGridBlockEntity> type, BlockPos pos, BlockState state, long energyUsage) {
        super(type, pos, state, energyUsage);
    }

    @Inject(method={"createProcessingPattern"}, at={@At(value="RETURN")}, cancellable=true)
    private void createProcessingPattern(CallbackInfoReturnable<ItemStack> cir) {
        ItemStack pattern = (ItemStack)cir.getReturnValue();
        pattern.set(DataComponents.INSTANCE.getSidedInputPatternState(), (Object)new SidedInputPatternState(this.cabletiers$sidedResources));
        cir.setReturnValue((Object)pattern);
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    private void saveAdditional(CompoundTag tag, HolderLookup.Provider provider, CallbackInfo ci) {
        tag.put(TAG_SIDED_RESOURCES, (Tag)SidedResourceAmount.OPTIONAL_LIST_CODEC.encode(this.cabletiers$sidedResources, (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag()).getOrThrow());
    }

    @Inject(method={"loadAdditional"}, at={@At(value="TAIL")})
    private void loadAdditional(CompoundTag tag, HolderLookup.Provider provider, CallbackInfo ci) {
        this.cabletiers$sidedResources.clear();
        if (tag.contains(TAG_SIDED_RESOURCES)) {
            this.cabletiers$sidedResources = (List)SidedResourceAmount.OPTIONAL_LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound(TAG_SIDED_RESOURCES)).result().orElseThrow();
        }
    }

    @Override
    @Unique
    public void cabletiers$setSidedResources(List<Optional<SidedResourceAmount>> sidedResources) {
        this.cabletiers$sidedResources = sidedResources;
        this.setChanged();
    }

    @Override
    @Unique
    public List<Optional<SidedResourceAmount>> cabletiers$getSidedResources() {
        return this.cabletiers$sidedResources;
    }
}

