/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.autocrafting.sidedinput;

import com.mojang.blaze3d.systems.RenderSystem;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridScreen;
import com.refinedmods.refinedstorage.common.grid.AutocraftableResourceHint;
import com.refinedmods.refinedstorage.common.grid.screen.AbstractGridScreen;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.cabletiers.common.autocrafting.sidedinput.SidedResourceAmount;
import com.ultramega.cabletiers.common.packet.c2s.SetSidedResourcesOnPatternGridBlockPacket;
import com.ultramega.cabletiers.common.utils.CableTiersIdentifierUtil;
import com.ultramega.cabletiers.common.utils.ResourceSlotRendering;
import com.ultramega.cabletiers.common.utils.SidedInputUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_8710;

public class SidedInputScreen
extends class_437 {
    private static final class_2960 TEXTURE = CableTiersIdentifierUtil.createCableTiersIdentifier("textures/gui/sided_input.png");
    private static final class_2960 SLOT_TEXTURE = IdentifierUtil.createIdentifier((String)"slot");
    private static final class_2960 DIRECTION_BUTTON = IdentifierUtil.createIdentifier((String)"widget/side_button/base");
    private static final class_2960 DIRECTION_BUTTON_HOVERED = IdentifierUtil.createIdentifier((String)"widget/side_button/hovered");
    private static final class_2960 DIRECTION_BUTTON_OVERLAY = IdentifierUtil.createIdentifier((String)"widget/side_button/hover_overlay");
    private static final class_5250 NONE = CableTiersIdentifierUtil.createCableTiersTranslation("gui", "omni_side_pattern_grid.none");
    private static final class_5250 DOWN = CableTiersIdentifierUtil.createCableTiersTranslation("gui", "omni_side_pattern_grid.down");
    private static final class_5250 UP = CableTiersIdentifierUtil.createCableTiersTranslation("gui", "omni_side_pattern_grid.up");
    private static final class_5250 NORTH = CableTiersIdentifierUtil.createCableTiersTranslation("gui", "omni_side_pattern_grid.north");
    private static final class_5250 SOUTH = CableTiersIdentifierUtil.createCableTiersTranslation("gui", "omni_side_pattern_grid.south");
    private static final class_5250 WEST = CableTiersIdentifierUtil.createCableTiersTranslation("gui", "omni_side_pattern_grid.west");
    private static final class_5250 EAST = CableTiersIdentifierUtil.createCableTiersTranslation("gui", "omni_side_pattern_grid.east");
    private static final int DIRECTION_SIZE = 14;
    private static final int INDIVIDUAL_SLOT_SIZE = 18;
    private final PatternGridContainerMenu gridContainerMenu;
    private final class_2561 gridTitle;
    private final List<ResourceSlot> processingInputSlots = new ArrayList<ResourceSlot>();
    @Nullable
    private List<class_2561> tooltip = new ArrayList<class_2561>();
    private final int imageWidth;
    private final int imageHeight;
    @Nullable
    private ScrollbarWidget scrollbar;
    @Nullable
    private final class_2350[] directions;
    private int hoveringDirectionRow;
    private int hoveringDirectionColumn;
    private int leftPos;
    private int topPos;

    public SidedInputScreen(PatternGridContainerMenu gridContainerMenu, class_2561 gridTitle, List<Optional<SidedResourceAmount>> sidedResources) {
        super((class_2561)class_2561.method_43473());
        int i;
        this.gridContainerMenu = gridContainerMenu;
        this.gridTitle = gridTitle;
        for (i = 0; i < gridContainerMenu.getResourceSlots().size(); ++i) {
            ResourceSlot slot = (ResourceSlot)gridContainerMenu.getResourceSlots().get(i);
            if (!SidedInputUtil.isProcessingInputSlot(slot)) continue;
            this.processingInputSlots.add(slot);
        }
        this.directions = new class_2350[this.processingInputSlots.size()];
        i = 0;
        for (Optional<SidedResourceAmount> resource : sidedResources) {
            if (resource.isPresent() && i < this.directions.length) {
                this.directions[i] = resource.get().inputDirection().orElse(null);
            }
            ++i;
        }
        this.imageWidth = 140;
        this.imageHeight = 99;
    }

    protected void method_25426() {
        super.method_25426();
        this.leftPos = (this.field_22789 - this.imageWidth) / 2;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;
        this.scrollbar = this.createScrollbar();
        this.updateScrollbarMaxOffset();
        this.method_37063((class_364)this.scrollbar);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        graphics.method_25302(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int startY = this.topPos + 6;
        int endY = this.topPos + 6 + 88 + 1;
        graphics.method_44379(this.leftPos - 50, startY, this.leftPos + this.imageWidth + 50, endY);
        this.renderSlotsAndDirections(graphics, mouseX, mouseY);
        graphics.method_44380();
        if (this.scrollbar != null) {
            this.scrollbar.method_25394(graphics, mouseX, mouseY, partialTick);
        }
        this.renderHoveredResourceTooltip(graphics, mouseX, mouseY);
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_52752(guiGraphics);
    }

    private void renderSlotsAndDirections(class_332 graphics, int mouseX, int mouseY) {
        int xx = this.leftPos + 5;
        int startY = this.topPos + 9 - 18;
        int endY = this.topPos + 9 + 72;
        boolean anyHovered = false;
        for (int i = 0; i < this.processingInputSlots.size(); ++i) {
            ResourceSlot slot = this.processingInputSlots.get(i);
            if (this.directions == null || this.directions.length <= i) {
                return;
            }
            int yy = this.getYForScrollbarOffset(i);
            if (yy < startY || yy > endY) continue;
            int slotX = xx + 1;
            int slotY = yy + 1;
            boolean hovering = this.isHovering(slotX, slotY, 16, 16, mouseX, mouseY);
            graphics.method_52706(SLOT_TEXTURE, xx, yy, 18, 18);
            if (slot.getResource() != null && this.gridContainerMenu.getRepository().isSticky((ResourceKey)slot.getResource())) {
                AbstractGridScreen.renderSlotBackground((class_332)graphics, (int)slotX, (int)slotY, (boolean)false, (int)AutocraftableResourceHint.AUTOCRAFTABLE.getColor());
            }
            List<class_2561> resourceTooltips = ResourceSlotRendering.render(graphics, slot, slotX, slotY);
            if (hovering) {
                anyHovered = true;
                class_465.method_33285((class_332)graphics, (int)slotX, (int)slotY, (int)0);
                this.tooltip = resourceTooltips;
            }
            class_2350 selectedDirection = this.directions[i];
            for (int j = -1; j < class_2350.values().length; ++j) {
                boolean isClicked;
                class_2350 direction = j == -1 ? null : class_2350.values()[j];
                class_5250 name = direction == null ? NONE : SidedInputScreen.getDirectionName(direction);
                String shortName = direction == null ? "X" : name.getString().substring(0, 1);
                int x = slotX + 4 + 14 * (j + 2);
                int y = slotY + 1;
                boolean isEmpty = slot.isEmpty();
                boolean isHovered = this.isHovering(x + 1, y + 1, 12, 12, mouseX, mouseY);
                boolean bl = selectedDirection == null ? j == -1 : (isClicked = j == selectedDirection.ordinal());
                if (!this.renderDirectionButton(graphics, x, y, shortName, isEmpty, isHovered, isClicked)) continue;
                anyHovered = true;
                this.tooltip = List.of(name);
                this.hoveringDirectionRow = i;
                this.hoveringDirectionColumn = j;
            }
        }
        if (!anyHovered) {
            this.tooltip = null;
            this.hoveringDirectionRow = -1;
            this.hoveringDirectionColumn = -2;
        }
    }

    private boolean renderDirectionButton(class_332 graphics, int x, int y, String text, boolean isEmpty, boolean isHovered, boolean isClicked) {
        graphics.method_52706(!isEmpty && (isHovered || isClicked) ? DIRECTION_BUTTON_HOVERED : DIRECTION_BUTTON, x, y, 14, 14);
        int textWidth = this.field_22793.method_1727(text);
        int textX = x + (14 - textWidth) / 2;
        Objects.requireNonNull(this.field_22793);
        int textY = y + (14 - 9) / 2 + 1;
        graphics.method_25303(this.field_22793, text, textX, textY, -1);
        if (isHovered) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            graphics.method_52706(DIRECTION_BUTTON_OVERLAY, x, y, 14, 14);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean clickedScrollbar;
        boolean bl = clickedScrollbar = this.scrollbar != null && this.scrollbar.method_25402(mouseX, mouseY, button);
        if (clickedScrollbar) {
            return true;
        }
        if (this.directions != null && this.hoveringDirectionRow != -1 && this.hoveringDirectionColumn != -2) {
            this.playClickSound();
            this.directions[this.hoveringDirectionRow] = this.hoveringDirectionColumn != -1 ? class_2350.values()[this.hoveringDirectionColumn] : null;
            this.setSidedInputPatternData();
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_16014(double mouseX, double mouseY) {
        if (this.scrollbar != null) {
            this.scrollbar.method_16014(mouseX, mouseY);
        }
        super.method_16014(mouseX, mouseY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return this.scrollbar != null && this.scrollbar.method_25406(mouseX, mouseY, button) || super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        return this.scrollbar != null && this.scrollbar.method_25401(mouseX, mouseY, scrollX, scrollY) || super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    private int getYForScrollbarOffset(int i) {
        int scrollbarOffset = this.scrollbar != null ? (int)this.scrollbar.getOffset() : 0;
        int scrollbarOffsetCorrected = this.scrollbar != null && this.scrollbar.isSmoothScrolling() ? scrollbarOffset : scrollbarOffset * 18;
        return this.topPos + 5 + i * 18 - scrollbarOffsetCorrected;
    }

    private void updateScrollbarMaxOffset() {
        if (this.scrollbar == null) {
            return;
        }
        int maxFilledSlots = 0;
        int maxLastFilledSlot = 0;
        for (int i = 0; i < this.processingInputSlots.size(); ++i) {
            ResourceSlot resourceSlot = this.processingInputSlots.get(i);
            if (resourceSlot.isEmpty()) continue;
            ++maxFilledSlots;
            maxLastFilledSlot = i;
        }
        int maxOffset = Math.max(maxFilledSlots - 4, maxLastFilledSlot - 4);
        int maxOffsetCorrected = this.scrollbar.isSmoothScrolling() ? maxOffset * 18 : maxOffset;
        this.scrollbar.setMaxOffset((double)maxOffsetCorrected);
        this.scrollbar.setEnabled(maxOffsetCorrected > 0);
    }

    private ScrollbarWidget createScrollbar() {
        ScrollbarWidget s = new ScrollbarWidget(this.leftPos + 127, this.topPos + 6, ScrollbarWidget.Type.SMALL, 88);
        s.setListener(offset -> this.onScrollbarChanged((int)offset));
        return s;
    }

    private void onScrollbarChanged(int offset) {
        int scrollbarOffset = this.scrollbar != null && this.scrollbar.isSmoothScrolling() ? offset : offset * 18;
        for (int i = 0; i < this.processingInputSlots.size(); ++i) {
            int slotY = this.topPos + 3 + 10 + i * 18 - scrollbarOffset - this.topPos;
            Platform.INSTANCE.setSlotY((class_1735)this.processingInputSlots.get(i), slotY);
        }
    }

    private void setSidedInputPatternData() {
        if (this.directions == null) {
            return;
        }
        ArrayList resources = new ArrayList();
        for (ResourceSlot slot : this.processingInputSlots) {
            if (slot.getResource() != null) {
                resources.add(Optional.of(new ResourceAmount((ResourceKey)slot.getResource(), slot.getAmount())));
                continue;
            }
            resources.add(Optional.empty());
        }
        List<Optional> inputSides = Arrays.stream(this.directions).map(Optional::ofNullable).toList();
        ArrayList<Optional<SidedResourceAmount>> sidedResources = new ArrayList<Optional<SidedResourceAmount>>();
        for (int i = 0; i < resources.size(); ++i) {
            Optional resource = (Optional)resources.get(i);
            Optional direction = inputSides.get(i);
            if (resource.isPresent()) {
                sidedResources.add(Optional.of(new SidedResourceAmount((ResourceAmount)resource.get(), direction)));
                continue;
            }
            sidedResources.add(Optional.empty());
        }
        Platform.INSTANCE.sendPacketToServer((class_8710)new SetSidedResourcesOnPatternGridBlockPacket(sidedResources));
    }

    private void renderHoveredResourceTooltip(class_332 graphics, int mouseX, int mouseY) {
        if (this.tooltip == null) {
            return;
        }
        List processedLines = Platform.INSTANCE.processTooltipComponents(class_1799.field_8037, graphics, mouseX, Optional.empty(), this.tooltip);
        Platform.INSTANCE.renderTooltip(graphics, processedLines, mouseX, mouseY);
    }

    public void method_25419() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null) {
            mc.method_1507((class_437)new PatternGridScreen(this.gridContainerMenu, mc.field_1724.method_31548(), this.gridTitle));
        }
    }

    private void playClickSound() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    public boolean method_25421() {
        return false;
    }

    private boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return mouseX >= (double)(x - 1) && mouseX < (double)(x + width + 1) && mouseY >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    public static class_5250 getDirectionName(class_2350 direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> DOWN;
            case class_2350.field_11036 -> UP;
            case class_2350.field_11043 -> NORTH;
            case class_2350.field_11035 -> SOUTH;
            case class_2350.field_11039 -> WEST;
            case class_2350.field_11034 -> EAST;
        };
    }
}

