/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.iface;

import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.iface.InterfaceData;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.Property;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicator;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicatorListener;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicators;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeSlot;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.iface.TieredInterfaceBlockEntity;
import com.ultramega.cabletiers.common.registry.Menus;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;

public class TieredInterfaceContainerMenu
extends AbstractResourceContainerMenu
implements ExportingIndicatorListener {
    private static final int EXPORT_CONFIG_SLOT_X = 8;
    private static final int EXPORT_CONFIG_SLOT_Y = 20;
    private static final int EXPORT_OUTPUT_SLOT_Y = 84;
    private final ExportingIndicators indicators;
    private final Predicate<class_1657> stillValid;
    private final List<class_1735> exportedResourceSlots = new ArrayList<class_1735>();
    private final CableTiers tier;

    TieredInterfaceContainerMenu(int syncId, class_1657 player, TieredInterfaceBlockEntity blockEntity, ResourceContainer exportConfig, ResourceContainer exportedResources, class_1263 exportedResourcesAsContainer, UpgradeContainer upgradeContainer, ExportingIndicators indicators, CableTiers tier) {
        super(Menus.INSTANCE.getTieredInterfaces(tier), syncId, player);
        this.tier = tier;
        this.addSlots(player, exportConfig, exportedResources, exportedResourcesAsContainer, upgradeContainer);
        this.registerProperty((Property)new ServerProperty(PropertyTypes.FUZZY_MODE, blockEntity::isFuzzyMode, blockEntity::setFuzzyMode));
        this.registerProperty((Property)new ServerProperty(PropertyTypes.REDSTONE_MODE, () -> ((TieredInterfaceBlockEntity)blockEntity).getRedstoneMode(), arg_0 -> ((TieredInterfaceBlockEntity)blockEntity).setRedstoneMode(arg_0)));
        this.indicators = indicators;
        this.stillValid = p -> class_1263.method_49105((class_2586)blockEntity, (class_1657)p);
    }

    public TieredInterfaceContainerMenu(int syncId, class_1661 playerInventory, InterfaceData interfaceData, CableTiers tier) {
        super(Menus.INSTANCE.getTieredInterfaces(tier), syncId);
        this.tier = tier;
        ResourceContainer filterContainer = TieredInterfaceBlockEntity.createFilterContainer(tier, interfaceData);
        ResourceContainer exportedResources = TieredInterfaceBlockEntity.createExportedResourcesContainer(tier, interfaceData, FilterWithFuzzyMode.create((ResourceContainer)filterContainer, null));
        this.addSlots(playerInventory.field_7546, filterContainer, exportedResources, exportedResources.toItemContainer(), new UpgradeContainer((UpgradeDestination)UpgradeDestinations.INTERFACE, 1));
        this.registerProperty((Property)new ClientProperty(PropertyTypes.FUZZY_MODE, (Object)false));
        this.registerProperty((Property)new ClientProperty(PropertyTypes.REDSTONE_MODE, (Object)RedstoneMode.IGNORE));
        this.indicators = new ExportingIndicators(interfaceData.exportingIndicators());
        this.stillValid = p -> true;
    }

    private void addSlots(class_1657 player, ResourceContainer exportConfig, ResourceContainer exportedResources, class_1263 exportedResourcesAsContainer, UpgradeContainer upgradeContainer) {
        int i;
        for (i = 0; i < exportConfig.size(); ++i) {
            this.method_7621(this.createExportConfigSlot(exportConfig, i));
        }
        for (i = 0; i < exportedResources.size(); ++i) {
            this.exportedResourceSlots.add(this.method_7621(this.addExportedResourceSlot(exportedResources, exportedResourcesAsContainer, i)));
        }
        this.method_7621((class_1735)new UpgradeSlot(upgradeContainer, 0, 187, 6));
        this.addPlayerInventory(player.method_31548(), 8, 136 + (this.tier != CableTiers.ELITE ? 18 : 0));
        this.transferManager.addBiTransfer(exportedResourcesAsContainer, (class_1263)player.method_31548());
        this.transferManager.addFilterTransfer((class_1263)player.method_31548());
    }

    private class_1735 createExportConfigSlot(ResourceContainer exportConfig, int index) {
        return new ResourceSlot(exportConfig, index, (class_2561)IdentifierUtil.createTranslation((String)"gui", (String)"interface.filter_help"), TieredInterfaceContainerMenu.getExportSlotX(index), 20 + TieredInterfaceContainerMenu.getExportSlotY(index), ResourceSlotType.FILTER_WITH_AMOUNT);
    }

    private class_1735 addExportedResourceSlot(ResourceContainer exportedResources, class_1263 exportedResourcesAsContainer, int index) {
        return new ResourceSlot(this, exportedResources, exportedResourcesAsContainer, index, (class_2561)class_2561.method_43473(), TieredInterfaceContainerMenu.getExportSlotX(index), 84 + TieredInterfaceContainerMenu.getExportSlotY(index), ResourceSlotType.CONTAINER){

            public boolean shouldRenderAmount() {
                return true;
            }
        };
    }

    public List<class_1735> getExportedResourceSlots() {
        return this.exportedResourceSlots;
    }

    ExportingIndicator getIndicator(int idx) {
        return this.indicators.get(idx);
    }

    int getIndicators() {
        return this.indicators.size();
    }

    public void method_7623() {
        super.method_7623();
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            this.indicators.detectChanges(serverPlayer);
        }
    }

    public boolean method_7597(class_1657 player) {
        return this.stillValid.test(player);
    }

    public void indicatorChanged(int index, ExportingIndicator indicator) {
        this.indicators.set(index, indicator);
    }

    private static int getExportSlotX(int index) {
        return 8 + 18 * (index % 9);
    }

    private static int getExportSlotY(int index) {
        return 18 * (index / 9);
    }
}

