/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.fabric;

import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.Config;
import com.ultramega.cabletiers.common.DefaultConfig;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;

@Config(name="cabletiers")
public class ConfigImpl
implements ConfigData,
com.ultramega.cabletiers.common.Config {
    @ConfigEntry.Gui.CollapsibleObject
    private SimpleTieredStackEntryImpl tieredImporters = new SimpleTieredStackEntryImpl(CableType.IMPORTER);
    @ConfigEntry.Gui.CollapsibleObject
    private SimpleTieredStackEntryImpl tieredExporters = new SimpleTieredStackEntryImpl(CableType.EXPORTER);
    @ConfigEntry.Gui.CollapsibleObject
    private SimpleTieredEntryImpl tieredDestructors = new SimpleTieredEntryImpl(CableType.DESTRUCTOR);
    @ConfigEntry.Gui.CollapsibleObject
    private SimpleTieredStackEntryImpl tieredConstructors = new SimpleTieredStackEntryImpl(CableType.CONSTRUCTOR);
    @ConfigEntry.Gui.CollapsibleObject
    private SimpleTieredStackEntryImpl tieredDiskInterfaces = new SimpleTieredStackEntryImpl(CableType.DISK_INTERFACE);
    @ConfigEntry.Gui.CollapsibleObject
    private SimpleTieredEntryImpl tieredAutocrafters = new SimpleTieredEntryImpl(CableType.AUTOCRAFTER);
    @ConfigEntry.Gui.CollapsibleObject
    private SimpleTieredInterfaceEntryImpl tieredInterfaces = new SimpleTieredInterfaceEntryImpl(CableType.INTERFACE);

    public static ConfigImpl get() {
        return (ConfigImpl)AutoConfig.getConfigHolder(ConfigImpl.class).getConfig();
    }

    @Override
    public Config.SimpleTieredStackEntry getTieredImporters() {
        return this.tieredImporters;
    }

    @Override
    public Config.SimpleTieredStackEntry getTieredExporters() {
        return this.tieredExporters;
    }

    @Override
    public Config.SimpleTieredEntry getTieredDestructors() {
        return this.tieredDestructors;
    }

    @Override
    public Config.SimpleTieredStackEntry getTieredConstructors() {
        return this.tieredConstructors;
    }

    @Override
    public Config.SimpleTieredStackEntry getTieredDiskInterfaces() {
        return this.tieredDiskInterfaces;
    }

    @Override
    public Config.SimpleTieredEntry getTieredAutocrafters() {
        return this.tieredAutocrafters;
    }

    @Override
    public Config.SimpleTieredInterfaceEntry getTieredInterfaces() {
        return this.tieredInterfaces;
    }

    private static class SimpleTieredStackEntryImpl
    implements Config.SimpleTieredStackEntry {
        private long eliteEnergyUsage;
        private long ultraEnergyUsage;
        private long megaEnergyUsage;
        private int eliteSpeed;
        private int ultraSpeed;
        private int megaSpeed;
        private int creativeSpeed;
        private boolean eliteStackUpgradeIntegrated;
        private boolean ultraStackUpgradeIntegrated;
        private boolean megaStackUpgradeIntegrated;

        SimpleTieredStackEntryImpl(CableType type) {
            this.eliteEnergyUsage = DefaultConfig.getUsageFor(CableTiers.ELITE, type);
            this.ultraEnergyUsage = DefaultConfig.getUsageFor(CableTiers.ULTRA, type);
            this.megaEnergyUsage = DefaultConfig.getUsageFor(CableTiers.MEGA, type);
            this.eliteSpeed = DefaultConfig.getSpeedFor(CableTiers.ELITE, type);
            this.ultraSpeed = DefaultConfig.getSpeedFor(CableTiers.ULTRA, type);
            this.megaSpeed = DefaultConfig.getSpeedFor(CableTiers.MEGA, type);
            this.creativeSpeed = DefaultConfig.getSpeedFor(CableTiers.MEGA, type);
            this.eliteStackUpgradeIntegrated = DefaultConfig.isStackUpgradeIntegrated(CableTiers.ELITE, type);
            this.ultraStackUpgradeIntegrated = DefaultConfig.isStackUpgradeIntegrated(CableTiers.ULTRA, type);
            this.megaStackUpgradeIntegrated = DefaultConfig.isStackUpgradeIntegrated(CableTiers.MEGA, type);
        }

        @Override
        public long getEnergyUsage(CableTiers tier) {
            return switch (tier) {
                default -> throw new MatchException(null, null);
                case CableTiers.ELITE -> this.eliteEnergyUsage;
                case CableTiers.ULTRA -> this.ultraEnergyUsage;
                case CableTiers.MEGA -> this.megaEnergyUsage;
                case CableTiers.CREATIVE -> 0L;
            };
        }

        @Override
        public int getSpeed(CableTiers tier) {
            return switch (tier) {
                default -> throw new MatchException(null, null);
                case CableTiers.ELITE -> this.eliteSpeed;
                case CableTiers.ULTRA -> this.ultraSpeed;
                case CableTiers.MEGA -> this.megaSpeed;
                case CableTiers.CREATIVE -> this.creativeSpeed;
            };
        }

        @Override
        public boolean hasStackUpgradeIntegrated(CableTiers tier) {
            return switch (tier) {
                default -> throw new MatchException(null, null);
                case CableTiers.ELITE -> this.eliteStackUpgradeIntegrated;
                case CableTiers.ULTRA -> this.ultraStackUpgradeIntegrated;
                case CableTiers.MEGA -> this.megaStackUpgradeIntegrated;
                case CableTiers.CREATIVE -> true;
            };
        }
    }

    private static class SimpleTieredEntryImpl
    implements Config.SimpleTieredEntry {
        private long eliteEnergyUsage;
        private long ultraEnergyUsage;
        private long megaEnergyUsage;
        private int eliteSpeed;
        private int ultraSpeed;
        private int megaSpeed;
        private int creativeSpeed;

        SimpleTieredEntryImpl(CableType type) {
            this.eliteEnergyUsage = DefaultConfig.getUsageFor(CableTiers.ELITE, type);
            this.ultraEnergyUsage = DefaultConfig.getUsageFor(CableTiers.ULTRA, type);
            this.megaEnergyUsage = DefaultConfig.getUsageFor(CableTiers.MEGA, type);
            this.eliteSpeed = DefaultConfig.getSpeedFor(CableTiers.ELITE, type);
            this.ultraSpeed = DefaultConfig.getSpeedFor(CableTiers.ULTRA, type);
            this.megaSpeed = DefaultConfig.getSpeedFor(CableTiers.MEGA, type);
            this.creativeSpeed = DefaultConfig.getSpeedFor(CableTiers.MEGA, type);
        }

        @Override
        public long getEnergyUsage(CableTiers tier) {
            return switch (tier) {
                default -> throw new MatchException(null, null);
                case CableTiers.ELITE -> this.eliteEnergyUsage;
                case CableTiers.ULTRA -> this.ultraEnergyUsage;
                case CableTiers.MEGA -> this.megaEnergyUsage;
                case CableTiers.CREATIVE -> 0L;
            };
        }

        @Override
        public int getSpeed(CableTiers tier) {
            return switch (tier) {
                default -> throw new MatchException(null, null);
                case CableTiers.ELITE -> this.eliteSpeed;
                case CableTiers.ULTRA -> this.ultraSpeed;
                case CableTiers.MEGA -> this.megaSpeed;
                case CableTiers.CREATIVE -> this.creativeSpeed;
            };
        }
    }

    private static class SimpleTieredInterfaceEntryImpl
    implements Config.SimpleTieredInterfaceEntry {
        private long eliteEnergyUsage;
        private long ultraEnergyUsage;
        private long megaEnergyUsage;
        private int eliteSpeed;
        private int ultraSpeed;
        private int megaSpeed;
        private int creativeSpeed;
        private long eliteTransferQuotaMultiplier;
        private long ultraTransferQuotaMultiplier;
        private long megaTransferQuotaMultiplier;
        private long creativeTransferQuotaMultiplier;

        SimpleTieredInterfaceEntryImpl(CableType type) {
            this.eliteEnergyUsage = DefaultConfig.getUsageFor(CableTiers.ELITE, type);
            this.ultraEnergyUsage = DefaultConfig.getUsageFor(CableTiers.ULTRA, type);
            this.megaEnergyUsage = DefaultConfig.getUsageFor(CableTiers.MEGA, type);
            this.eliteSpeed = DefaultConfig.getSpeedFor(CableTiers.ELITE, type);
            this.ultraSpeed = DefaultConfig.getSpeedFor(CableTiers.ULTRA, type);
            this.megaSpeed = DefaultConfig.getSpeedFor(CableTiers.MEGA, type);
            this.creativeSpeed = DefaultConfig.getSpeedFor(CableTiers.MEGA, type);
            this.eliteTransferQuotaMultiplier = DefaultConfig.getTransferQuotaMultiplier(CableTiers.ELITE, type);
            this.ultraTransferQuotaMultiplier = DefaultConfig.getTransferQuotaMultiplier(CableTiers.ULTRA, type);
            this.megaTransferQuotaMultiplier = DefaultConfig.getTransferQuotaMultiplier(CableTiers.MEGA, type);
            this.creativeTransferQuotaMultiplier = DefaultConfig.getTransferQuotaMultiplier(CableTiers.CREATIVE, type);
        }

        @Override
        public long getEnergyUsage(CableTiers tier) {
            return switch (tier) {
                default -> throw new MatchException(null, null);
                case CableTiers.ELITE -> this.eliteEnergyUsage;
                case CableTiers.ULTRA -> this.ultraEnergyUsage;
                case CableTiers.MEGA -> this.megaEnergyUsage;
                case CableTiers.CREATIVE -> 0L;
            };
        }

        @Override
        public int getSpeed(CableTiers tier) {
            return switch (tier) {
                default -> throw new MatchException(null, null);
                case CableTiers.ELITE -> this.eliteSpeed;
                case CableTiers.ULTRA -> this.ultraSpeed;
                case CableTiers.MEGA -> this.megaSpeed;
                case CableTiers.CREATIVE -> this.creativeSpeed;
            };
        }

        @Override
        public long getTransferQuotaMultiplier(CableTiers tier) {
            return switch (tier) {
                default -> throw new MatchException(null, null);
                case CableTiers.ELITE -> this.eliteTransferQuotaMultiplier;
                case CableTiers.ULTRA -> this.ultraTransferQuotaMultiplier;
                case CableTiers.MEGA -> this.megaTransferQuotaMultiplier;
                case CableTiers.CREATIVE -> this.creativeTransferQuotaMultiplier;
            };
        }
    }
}

