/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.iface;

import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.FuzzyModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.RedstoneModeSideButtonWidget;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.iface.TieredInterfaceContainerMenu;
import com.ultramega.cabletiers.common.support.AbstractAdvancedFilterScreen;
import com.ultramega.cabletiers.common.utils.CableTiersIdentifierUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class TieredInterfaceScreen
extends AbstractBaseScreen<TieredInterfaceContainerMenu> {
    private static final ResourceLocation ELITE_TEXTURE = CableTiersIdentifierUtil.createCableTiersIdentifier("textures/gui/elite_interface.png");
    private static final ResourceLocation ULTRA_MEGA_CREATIVE_TEXTURE = CableTiersIdentifierUtil.createCableTiersIdentifier("textures/gui/ultra_mega_creative_interface.png");
    private final CableTiers tier;

    public TieredInterfaceScreen(TieredInterfaceContainerMenu menu, Inventory playerInventory, Component title, CableTiers tier) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.tier = tier;
        this.inventoryLabelY = 124 + (tier != CableTiers.ELITE ? 18 : 0);
        this.imageWidth = 210;
        this.imageHeight = tier == CableTiers.ELITE ? 218 : 236;
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        if (((TieredInterfaceContainerMenu)this.getMenu()).getExportedResourceSlots().contains(slot)) {
            return;
        }
        super.renderSlot(guiGraphics, slot);
    }

    protected void init() {
        super.init();
        this.addSideButton((AbstractSideButtonWidget)new RedstoneModeSideButtonWidget(((TieredInterfaceContainerMenu)this.getMenu()).getProperty(PropertyTypes.REDSTONE_MODE)));
        this.addSideButton((AbstractSideButtonWidget)new FuzzyModeSideButtonWidget(((TieredInterfaceContainerMenu)this.getMenu()).getProperty(PropertyTypes.FUZZY_MODE), () -> FuzzyModeSideButtonWidget.Type.EXTRACTING_STORAGE_NETWORK));
    }

    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        if (AbstractAdvancedFilterScreen.renderTieredExportingIndicators(graphics, this.leftPos, this.topPos + 10 - 18 - 2, x, y, ((TieredInterfaceContainerMenu)this.getMenu()).getIndicators(), ((TieredInterfaceContainerMenu)this.getMenu())::getIndicator)) {
            return;
        }
        super.renderTooltip(graphics, x, y);
    }

    protected ResourceLocation getTexture() {
        return this.tier == CableTiers.ELITE ? ELITE_TEXTURE : ULTRA_MEGA_CREATIVE_TEXTURE;
    }
}

