/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.iface.externalstorage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.impl.node.iface.InterfaceExportState;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.api.network.node.NetworkNodeActor;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.ultramega.cabletiers.common.iface.TieredInterfaceNetworkNode;
import com.ultramega.cabletiers.common.iface.externalstorage.TieredInterfaceExternalStorageProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class TieredInterfaceExternalStorageProviderImpl
implements TieredInterfaceExternalStorageProvider {
    private final TieredInterfaceNetworkNode networkNode;

    public TieredInterfaceExternalStorageProviderImpl(TieredInterfaceNetworkNode networkNode) {
        this.networkNode = networkNode;
    }

    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        if (this.isAnotherInterfaceActingAsExternalStorage(actor)) {
            return 0L;
        }
        InterfaceExportState exportState = this.networkNode.getExportState();
        if (exportState == null) {
            return 0L;
        }
        return exportState.extract(resource, amount, action);
    }

    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        if (this.isAnotherInterfaceActingAsExternalStorage(actor)) {
            return 0L;
        }
        InterfaceExportState exportState = this.networkNode.getExportState();
        if (exportState == null) {
            return 0L;
        }
        return exportState.insert(resource, amount, action);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAnotherInterfaceActingAsExternalStorage(Actor actor) {
        NetworkNode node;
        if (!(actor instanceof NetworkNodeActor)) return false;
        NetworkNodeActor networkNodeActor = (NetworkNodeActor)actor;
        try {
            NetworkNode networkNode;
            node = networkNode = networkNodeActor.networkNode();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (!(node instanceof TieredInterfaceNetworkNode)) return false;
        TieredInterfaceNetworkNode actingInterface = (TieredInterfaceNetworkNode)node;
        if (!actingInterface.isActingAsExternalStorage()) return false;
        return true;
    }

    public Iterator<ResourceAmount> iterator() {
        InterfaceExportState exportState = this.networkNode.getExportState();
        if (exportState == null) {
            return Collections.emptyIterator();
        }
        ArrayList<ResourceAmount> slots = new ArrayList<ResourceAmount>();
        for (int i = 0; i < exportState.getSlots(); ++i) {
            ResourceKey resource = exportState.getExportedResource(i);
            if (resource == null) continue;
            slots.add(new ResourceAmount(resource, exportState.getExportedAmount(i)));
        }
        return slots.iterator();
    }

    @Override
    public TieredInterfaceNetworkNode getInterface() {
        return this.networkNode;
    }
}

