/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.neoforge;

import com.refinedmods.refinedstorage.common.AbstractClientModInitializer;
import com.ultramega.cabletiers.common.AbstractClientModInitializer;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.registry.BlockEntities;
import com.ultramega.cabletiers.common.utils.ContentIds;
import com.ultramega.cabletiers.neoforge.storage.diskinterface.TieredDiskInterfaceBlockEntityRendererImpl;
import com.ultramega.cabletiers.neoforge.storage.diskinterface.TieredDiskInterfaceGeometryLoader;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;

public final class ClientModInitializer
extends AbstractClientModInitializer {
    private ClientModInitializer() {
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent e) {
        ClientModInitializer.registerBlockEntityRenderer();
    }

    @SubscribeEvent
    public static void onRegisterCustomModels(ModelEvent.RegisterGeometryLoaders e) {
        for (CableTiers tier : CableTiers.values()) {
            e.register(ContentIds.getContentId(tier, CableType.DISK_INTERFACE), (IGeometryLoader)new TieredDiskInterfaceGeometryLoader());
        }
    }

    @SubscribeEvent
    public static void onRegisterMenuScreens(final RegisterMenuScreensEvent e) {
        ClientModInitializer.registerScreens(new AbstractClientModInitializer.ScreenRegistration(){

            public <M extends AbstractContainerMenu, U extends Screen> void register(MenuType<? extends M> type, AbstractClientModInitializer.ScreenConstructor<M, U> factory) {
                e.register(type, (arg_0, arg_1, arg_2) -> factory.create(arg_0, arg_1, arg_2));
            }
        });
    }

    private static void registerBlockEntityRenderer() {
        for (CableTiers tier : CableTiers.values()) {
            BlockEntityRenderers.register(BlockEntities.INSTANCE.getTieredDiskInterfaces(tier), ctx -> new TieredDiskInterfaceBlockEntityRendererImpl());
        }
    }
}

