/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.exporter;

import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.api.network.node.NetworkNodeActor;
import com.refinedmods.refinedstorage.api.network.node.SchedulingMode;
import com.refinedmods.refinedstorage.api.network.node.exporter.ExporterTransferStrategy;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceTag;
import com.ultramega.cabletiers.common.advancedfilter.TagFilterWithFuzzyMode;
import com.ultramega.cabletiers.common.utils.TieredSimpleNetworkNode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class TieredExporterNetworkNode
extends TieredSimpleNetworkNode {
    private final Actor actor = new NetworkNodeActor((NetworkNode)this);
    private final List<TieredExporterTask> tasks = new ArrayList<TieredExporterTask>();
    @Nullable
    private ExporterTransferStrategy transferStrategy;
    @Nullable
    private SchedulingMode schedulingMode;

    public TieredExporterNetworkNode(long energyUsage) {
        super(energyUsage);
    }

    public void doWork() {
        super.doWork();
        if (this.network == null || !this.isActive() || this.schedulingMode == null) {
            return;
        }
        for (int i = 0; i < this.getTier().getSpeed(this.getType()); ++i) {
            this.schedulingMode.execute(this.tasks);
        }
    }

    public void setTransferStrategy(ExporterTransferStrategy transferStrategy) {
        this.transferStrategy = transferStrategy;
    }

    public void setSchedulingMode(@Nullable SchedulingMode schedulingMode) {
        this.schedulingMode = schedulingMode;
    }

    @Nullable
    public ExporterTransferStrategy.Result getLastResult(int filterIndex, int fakeIndex) {
        return this.tasks.get((int)(filterIndex + fakeIndex)).lastResult;
    }

    public void setFilters(List<ResourceKey> filters, List<ResourceTag> tagFilters) {
        ArrayList<TieredExporterTask> updatedTasks = new ArrayList<TieredExporterTask>();
        for (int i = 0; i < filters.size(); ++i) {
            for (ResourceKey resource : TagFilterWithFuzzyMode.getResourcesFromFilter(filters, tagFilters, i)) {
                ExporterTransferStrategy.Result lastResult = i < this.tasks.size() && this.tasks.get((int)i).filter.equals((Object)resource) ? this.tasks.get((int)i).lastResult : null;
                updatedTasks.add(new TieredExporterTask(resource, lastResult));
            }
        }
        this.tasks.clear();
        this.tasks.addAll(updatedTasks);
    }

    class TieredExporterTask
    implements SchedulingMode.ScheduledTask {
        private final ResourceKey filter;
        @Nullable
        private ExporterTransferStrategy.Result lastResult;

        TieredExporterTask(@Nullable ResourceKey filter, ExporterTransferStrategy.Result lastResult) {
            this.filter = filter;
            this.lastResult = lastResult;
        }

        public boolean run() {
            if (TieredExporterNetworkNode.this.transferStrategy == null || TieredExporterNetworkNode.this.network == null) {
                return false;
            }
            this.lastResult = TieredExporterNetworkNode.this.transferStrategy.transfer(this.filter, TieredExporterNetworkNode.this.actor, TieredExporterNetworkNode.this.network);
            return this.lastResult == ExporterTransferStrategy.Result.EXPORTED;
        }
    }
}

