/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.iface;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.externalstorage.ExposedExternalStorage;
import com.refinedmods.refinedstorage.api.network.impl.node.iface.InterfaceExportState;
import com.refinedmods.refinedstorage.api.network.impl.node.iface.InterfaceNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.iface.InterfaceTransferResult;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.api.network.node.NetworkNodeActor;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.external.ExternalStorageProvider;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.ultramega.cabletiers.common.iface.externalstorage.TieredInterfaceExternalStorageProvider;
import java.util.Collection;
import java.util.function.ToLongFunction;
import javax.annotation.Nullable;

public class TieredInterfaceNetworkNode
extends AbstractNetworkNode {
    private long energyUsage;
    private final Actor actor = new NetworkNodeActor((NetworkNode)this);
    @Nullable
    private InterfaceExportState exportState;
    @Nullable
    private InterfaceTransferResult[] lastResults;
    private ToLongFunction<ResourceKey> transferQuotaProvider = resource -> Long.MAX_VALUE;
    private InterfaceNetworkNode.OnMissingResources onMissingResources = InterfaceNetworkNode.OnMissingResources.EMPTY;

    public TieredInterfaceNetworkNode(long energyUsage) {
        this.energyUsage = energyUsage;
    }

    public void setTransferQuotaProvider(ToLongFunction<ResourceKey> transferQuotaProvider) {
        this.transferQuotaProvider = transferQuotaProvider;
    }

    public void setOnMissingResources(InterfaceNetworkNode.OnMissingResources onMissingResources) {
        this.onMissingResources = onMissingResources;
    }

    public boolean isActingAsExternalStorage() {
        if (this.network == null) {
            return false;
        }
        return ((StorageNetworkComponent)this.network.getComponent(StorageNetworkComponent.class)).hasSource(this::isStorageAnExternalStorageProviderThatReferencesMe);
    }

    private boolean isStorageAnExternalStorageProviderThatReferencesMe(Storage storage) {
        TieredInterfaceExternalStorageProvider interfaceProvider;
        ExposedExternalStorage proxy;
        ExternalStorageProvider externalStorageProvider;
        return storage instanceof ExposedExternalStorage && (externalStorageProvider = (proxy = (ExposedExternalStorage)storage).getExternalStorageProvider()) instanceof TieredInterfaceExternalStorageProvider && (interfaceProvider = (TieredInterfaceExternalStorageProvider)externalStorageProvider).getInterface() == this;
    }

    @Nullable
    public InterfaceExportState getExportState() {
        return this.exportState;
    }

    public void setEnergyUsage(long energyUsage) {
        this.energyUsage = energyUsage;
    }

    public void setExportState(@Nullable InterfaceExportState exportState) {
        this.exportState = exportState;
        this.lastResults = exportState != null ? new InterfaceTransferResult[exportState.getSlots()] : null;
    }

    public void doWork() {
        super.doWork();
        if (this.exportState == null || this.network == null || !this.isActive()) {
            return;
        }
        RootStorage storage = (RootStorage)this.network.getComponent(StorageNetworkComponent.class);
        for (int i = 0; i < this.exportState.getSlots(); ++i) {
            this.updateSlot(this.exportState, i, storage);
        }
    }

    private void updateSlot(InterfaceExportState state, int index, RootStorage storage) {
        ResourceKey want = state.getRequestedResource(index);
        ResourceKey got = state.getExportedResource(index);
        if (want == null && got == null) {
            this.updateResult(index, null);
        } else if (want == null) {
            this.clearSlot(state, index, got, storage);
        } else if (got == null) {
            this.updateEmptySlot(state, index, want, storage);
        } else {
            boolean valid = state.isExportedResourceValid(want, got);
            if (!valid) {
                this.clearSlot(state, index, got, storage);
            } else {
                this.updateSlot(state, index, got, storage);
            }
        }
    }

    private void updateSlot(InterfaceExportState state, int slot, ResourceKey got, RootStorage storage) {
        long currentAmount;
        long wantedAmount = state.getRequestedAmount(slot);
        long difference = wantedAmount - (currentAmount = state.getExportedAmount(slot));
        if (difference > 0L) {
            this.extractMoreFromStorage(state, slot, got, difference, storage);
        } else if (difference < 0L) {
            this.insertOverflowToStorage(state, slot, got, difference, storage);
        }
    }

    private void clearSlot(InterfaceExportState state, int slot, ResourceKey got, RootStorage storage) {
        long currentAmount = state.getExportedAmount(slot);
        long inserted = storage.insert(got, Math.min(currentAmount, this.transferQuotaProvider.applyAsLong(got)), Action.EXECUTE, this.actor);
        if (inserted == 0L) {
            this.updateResult(slot, InterfaceTransferResult.STORAGE_DOES_NOT_ACCEPT_RESOURCE);
            return;
        }
        state.shrinkExportedAmount(slot, inserted);
        boolean empty = state.getExportedAmount(slot) == 0L;
        boolean stillWantSomething = state.getRequestedResource(slot) != null;
        this.updateResult(slot, (InterfaceTransferResult)(empty && !stillWantSomething ? null : InterfaceTransferResult.EXPORTED));
    }

    private void updateEmptySlot(InterfaceExportState state, int slot, ResourceKey resource, RootStorage storage) {
        long wantedAmount = state.getRequestedAmount(slot);
        long correctedAmount = Math.min(this.transferQuotaProvider.applyAsLong(resource), wantedAmount);
        Collection candidates = state.expandExportCandidates(storage, resource);
        for (ResourceKey candidate : candidates) {
            long extracted = storage.extract(candidate, correctedAmount, Action.EXECUTE, this.actor);
            if (extracted <= 0L) continue;
            state.setExportSlot(slot, candidate, extracted);
            this.updateResult(slot, InterfaceTransferResult.EXPORTED);
            return;
        }
        if (this.network == null) {
            return;
        }
        InterfaceTransferResult result = this.onMissingResources.onMissingResources(resource, correctedAmount, this.actor, this.network);
        this.updateResult(slot, result);
    }

    private void extractMoreFromStorage(InterfaceExportState state, int slot, ResourceKey resource, long amount, RootStorage storage) {
        long correctedAmount = Math.min(this.transferQuotaProvider.applyAsLong(resource), amount);
        long extracted = storage.extract(resource, correctedAmount, Action.EXECUTE, this.actor);
        if (extracted == 0L) {
            if (this.network == null) {
                return;
            }
            InterfaceTransferResult result = this.onMissingResources.onMissingResources(resource, correctedAmount, this.actor, this.network);
            this.updateResult(slot, result);
            return;
        }
        state.growExportedAmount(slot, extracted);
        this.updateResult(slot, InterfaceTransferResult.EXPORTED);
    }

    private void insertOverflowToStorage(InterfaceExportState state, int slot, ResourceKey resource, long amount, RootStorage storage) {
        long correctedAmount = Math.min(this.transferQuotaProvider.applyAsLong(resource), Math.abs(amount));
        long inserted = storage.insert(resource, correctedAmount, Action.EXECUTE, this.actor);
        if (inserted == 0L) {
            this.updateResult(slot, InterfaceTransferResult.STORAGE_DOES_NOT_ACCEPT_RESOURCE);
            return;
        }
        state.shrinkExportedAmount(slot, inserted);
        this.updateResult(slot, InterfaceTransferResult.EXPORTED);
    }

    private void updateResult(int slot, @Nullable InterfaceTransferResult result) {
        if (this.lastResults == null) {
            return;
        }
        this.lastResults[slot] = result;
    }

    @Nullable
    public InterfaceTransferResult getLastResult(int slot) {
        if (this.lastResults == null) {
            return null;
        }
        return this.lastResults[slot];
    }

    public long getEnergyUsage() {
        return this.energyUsage;
    }
}

