/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.storage;

import com.refinedmods.refinedstorage.api.network.impl.node.AbstractStorageContainerNetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.StateTrackedStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceTag;
import com.refinedmods.refinedstorage.common.storage.Disk;
import com.refinedmods.refinedstorage.common.storage.DiskInventory;
import com.refinedmods.refinedstorage.common.storage.DiskStateChangeListener;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import com.refinedmods.refinedstorage.common.util.PlatformUtil;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.advancedfilter.AdvancedResourceContainerImpl;
import com.ultramega.cabletiers.common.advancedfilter.TagFilterWithFuzzyMode;
import com.ultramega.cabletiers.common.utils.TagFiltering;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractTieredDiskContainerBlockEntity<T extends AbstractStorageContainerNetworkNode>
extends AbstractBaseNetworkNodeContainerBlockEntity<T>
implements BlockEntityWithDrops,
NetworkNodeExtendedMenuProvider<ResourceContainerData>,
TagFiltering {
    private static final String TAG_DISK_INVENTORY = "inv";
    private static final String TAG_DISKS = "disks";
    protected final CableTiers tier;
    protected final CableType type;
    protected final TagFilterWithFuzzyMode filter;
    protected final DiskInventory diskInventory;
    @Nullable
    protected Disk[] disks;
    private final DiskStateChangeListener diskStateListener = new DiskStateChangeListener((BlockEntity)this);
    @Nullable
    private Runnable onChanged;
    private boolean inContainerMenu;

    protected AbstractTieredDiskContainerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, T node, CableTiers tier, CableType type) {
        super(blockEntityType, pos, state, node);
        this.tier = tier;
        this.type = type;
        this.diskInventory = new DiskInventory((inventory, slot) -> this.onDiskChanged(slot), ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).getSize());
        this.filter = TagFilterWithFuzzyMode.createAndListenForUniqueFilters(AdvancedResourceContainerImpl.createForFilter(tier), this::setChanged, this::setFilters);
        ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).setListener((StateTrackedStorage.Listener)this.diskStateListener);
        this.setNormalizer(this.filter.createNormalizer());
    }

    public void doWork() {
        for (int i = 0; i < this.tier.getSpeed(this.type); ++i) {
            super.doWork();
        }
        if (!this.inContainerMenu) {
            return;
        }
        this.filter.doWork();
    }

    protected void containerInitialized() {
        super.containerInitialized();
        PlatformUtil.sendBlockUpdateToClient((Level)this.level, (BlockPos)this.worldPosition);
    }

    protected abstract void setFilters(Set<ResourceKey> var1, Set<TagKey<?>> var2);

    protected abstract void setNormalizer(UnaryOperator<ResourceKey> var1);

    @Override
    public void setTagFilter(int index, @Nullable ResourceTag resourceTag) {
        this.filter.setFilterTag(index, resourceTag);
    }

    @Override
    @Nullable
    public TagKey<?> getTagFilter(int index) {
        return this.filter.getFilterContainer().getFilterTag(index);
    }

    @Override
    public void resetFakeFilters() {
        this.filter.resetFakeFilters();
    }

    @Override
    public void sendFilterTagsToClient(ServerPlayer player) {
        this.filter.sendFilterTagsToClient(player);
    }

    @Override
    public void setOnChanged(@Nullable Runnable onChanged) {
        this.onChanged = onChanged;
    }

    @Override
    public void setInContainerMenu(boolean inContainerMenu) {
        this.inContainerMenu = inContainerMenu;
    }

    @Nullable
    public static Item getDisk(CompoundTag tag, int slot, HolderLookup.Provider provider) {
        if (!tag.contains(TAG_DISK_INVENTORY)) {
            return null;
        }
        CompoundTag diskInventoryTag = tag.getCompound(TAG_DISK_INVENTORY);
        if (!ContainerUtil.hasItemInSlot((CompoundTag)diskInventoryTag, (int)slot)) {
            return null;
        }
        ItemStack diskStack = ContainerUtil.getItemInSlot((CompoundTag)diskInventoryTag, (int)slot, (HolderLookup.Provider)provider);
        return diskStack.isEmpty() ? null : diskStack.getItem();
    }

    void updateDiskStateIfNecessaryInLevel() {
        this.diskStateListener.updateIfNecessary();
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (!level.isClientSide()) {
            this.initialize(level);
        }
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.initialize(this.level);
        }
        if (this.onChanged != null) {
            this.onChanged.run();
        }
    }

    private void initialize(Level level) {
        this.diskInventory.setStorageRepository(RefinedStorageApi.INSTANCE.getStorageRepository(level));
        ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).setProvider((AbstractStorageContainerNetworkNode.Provider)this.diskInventory);
    }

    public void activenessChanged(boolean newActive) {
        super.activenessChanged(newActive);
        PlatformUtil.sendBlockUpdateToClient((Level)this.level, (BlockPos)this.worldPosition);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        this.fromClientTag(tag);
        if (tag.contains(TAG_DISK_INVENTORY)) {
            ContainerUtil.read((CompoundTag)tag.getCompound(TAG_DISK_INVENTORY), (Container)this.diskInventory, (HolderLookup.Provider)provider);
        }
        super.loadAdditional(tag, provider);
    }

    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        this.filter.load(tag, provider);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_DISK_INVENTORY, (Tag)ContainerUtil.write((Container)this.diskInventory, (HolderLookup.Provider)provider));
    }

    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        this.filter.save(tag, provider);
    }

    public FilteredContainer getDiskInventory() {
        return this.diskInventory;
    }

    private void onDiskChanged(int slot) {
        boolean isPlacedThroughDismantlingMode;
        boolean isJustPlacedIntoLevelOrLoading = this.level == null || this.level.isClientSide();
        boolean bl = isPlacedThroughDismantlingMode = ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).getNetwork() == null;
        if (isJustPlacedIntoLevelOrLoading || isPlacedThroughDismantlingMode) {
            return;
        }
        ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).onStorageChanged(slot);
        PlatformUtil.sendBlockUpdateToClient((Level)this.level, (BlockPos)this.worldPosition);
        this.setChanged();
    }

    private void fromClientTag(CompoundTag tag) {
        if (!tag.contains(TAG_DISKS)) {
            return;
        }
        this.disks = this.diskInventory.fromSyncTag(tag.getList(TAG_DISKS, 10));
        this.onClientDriveStateUpdated();
    }

    protected void onClientDriveStateUpdated() {
        if (this.level == null) {
            return;
        }
        Platform.INSTANCE.requestModelDataUpdateOnClient((LevelAccessor)this.level, this.worldPosition, true);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        if (((AbstractStorageContainerNetworkNode)this.mainNetworkNode).getNetwork() == null) {
            return tag;
        }
        tag.put(TAG_DISKS, (Tag)this.diskInventory.toSyncTag(arg_0 -> ((AbstractStorageContainerNetworkNode)((AbstractStorageContainerNetworkNode)this.mainNetworkNode)).getState(arg_0)));
        return tag;
    }

    public NonNullList<ItemStack> getDrops() {
        NonNullList drops = NonNullList.create();
        for (int i = 0; i < this.diskInventory.getContainerSize(); ++i) {
            drops.add((Object)this.diskInventory.getItem(i));
        }
        return drops;
    }

    public ResourceContainerData getMenuData() {
        return ResourceContainerData.of((ResourceContainer)this.filter.getFilterContainer());
    }

    public StreamEncoder<RegistryFriendlyByteBuf, ResourceContainerData> getMenuCodec() {
        return ResourceContainerData.STREAM_CODEC;
    }

    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(BlockState oldBlockState, BlockState newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange((BlockState)oldBlockState, (BlockState)newBlockState);
    }
}

