/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceTag;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class ModCodecs {
    public static final Codec<TagKey<?>> TAG_KEY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("registry").forGetter(tagKey -> tagKey.registry().location()), (App)ResourceLocation.CODEC.fieldOf("tag").forGetter(TagKey::location)).apply((Applicative)instance, (registry, tag) -> {
        ResourceKey registryKey = ResourceKey.createRegistryKey((ResourceLocation)registry);
        return TagKey.create((ResourceKey)registryKey, (ResourceLocation)tag);
    }));
    public static final StreamCodec<FriendlyByteBuf, TagKey<?>> TAG_KEY_GENERIC_STREAM_CODEC = StreamCodec.of((buf, tagKey) -> {
        buf.writeResourceLocation(tagKey.registry().location());
        buf.writeResourceLocation(tagKey.location());
    }, buf -> {
        ResourceLocation registryLocation = buf.readResourceLocation();
        ResourceLocation tagLocation = buf.readResourceLocation();
        ResourceKey registryKey = ResourceKey.createRegistryKey((ResourceLocation)registryLocation);
        return TagKey.create((ResourceKey)registryKey, (ResourceLocation)tagLocation);
    });
    public static final Codec<ResourceTag> RESOURCE_TAG_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TAG_KEY_CODEC.fieldOf("key").forGetter(ResourceTag::key), (App)ResourceCodecs.CODEC.listOf().fieldOf("resources").forGetter(ResourceTag::resources)).apply((Applicative)instance, ResourceTag::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ResourceTag> RESOURCE_TAG_STREAM_CODEC = StreamCodec.composite(TAG_KEY_GENERIC_STREAM_CODEC, ResourceTag::key, (StreamCodec)ResourceCodecs.STREAM_CODEC.apply(ByteBufCodecs.list()), ResourceTag::resources, ResourceTag::new);

    private ModCodecs() {
    }
}

