/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.neoforge.datagen;

import com.ultramega.cabletiers.neoforge.datagen.BlockModelProviderImpl;
import com.ultramega.cabletiers.neoforge.datagen.BlockStateProviderImpl;
import com.ultramega.cabletiers.neoforge.datagen.ItemModelProviderImpl;
import com.ultramega.cabletiers.neoforge.datagen.loot.LootTableProviderImpl;
import com.ultramega.cabletiers.neoforge.datagen.recipe.RecoloringRecipeProvider;
import com.ultramega.cabletiers.neoforge.datagen.tag.BlockTagsProvider;
import com.ultramega.cabletiers.neoforge.datagen.tag.ItemTagsProviderImpl;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="cabletiers")
public class DataGenerators {
    private DataGenerators() {
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent e) {
        DataGenerators.registerBlockModelProviders(e.getGenerator(), e.getExistingFileHelper());
        DataGenerators.registerItemModelProviders(e.getGenerator(), e.getExistingFileHelper());
        DataGenerators.registerBlockStateProviders(e.getGenerator(), e.getExistingFileHelper());
        DataGenerators.registerLootTableProviders(e.getGenerator(), e.getLookupProvider());
        DataGenerators.registerRecipeProviders(e.getGenerator(), e.getLookupProvider());
        DataGenerators.registerTagProviders(e.getGenerator(), e.getLookupProvider(), e.getExistingFileHelper());
    }

    private static void registerBlockModelProviders(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        DataGenerator.PackGenerator mainPack = generator.getVanillaPack(true);
        mainPack.addProvider(output -> new BlockModelProviderImpl(output, existingFileHelper));
    }

    private static void registerBlockStateProviders(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        DataGenerator.PackGenerator mainPack = generator.getVanillaPack(true);
        mainPack.addProvider(output -> new BlockStateProviderImpl(output, existingFileHelper));
    }

    private static void registerItemModelProviders(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        DataGenerator.PackGenerator mainPack = generator.getVanillaPack(true);
        mainPack.addProvider(output -> new ItemModelProviderImpl(output, existingFileHelper));
    }

    private static void registerLootTableProviders(DataGenerator generator, CompletableFuture<HolderLookup.Provider> provider) {
        DataGenerator.PackGenerator mainPack = generator.getVanillaPack(true);
        mainPack.addProvider(output -> new LootTableProviderImpl(output, provider));
    }

    private static void registerRecipeProviders(DataGenerator generator, CompletableFuture<HolderLookup.Provider> provider) {
        DataGenerator.PackGenerator mainPack = generator.getVanillaPack(true);
        mainPack.addProvider(output -> new RecoloringRecipeProvider(output, provider));
    }

    private static void registerTagProviders(DataGenerator generator, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        DataGenerator.PackGenerator mainPack = generator.getVanillaPack(true);
        BlockTagsProvider blockTagsProvider = (BlockTagsProvider)mainPack.addProvider(output -> new BlockTagsProvider(output, lookupProvider, existingFileHelper));
        mainPack.addProvider(output -> new ItemTagsProviderImpl(output, lookupProvider, blockTagsProvider, existingFileHelper));
    }
}

