/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.autocrafting.autocrafter;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSinkKey;
import com.refinedmods.refinedstorage.api.autocrafting.task.StepBehavior;
import com.refinedmods.refinedstorage.api.autocrafting.task.Task;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskImpl;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskSnapshot;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternProvider;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternProviderExternalPatternSink;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.patternprovider.ExternalPatternSinkKeyProvider;
import com.refinedmods.refinedstorage.api.network.impl.node.patternprovider.PatternProviderListener;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.api.network.node.importer.ImporterTransferStrategy;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.autocrafting.PlatformPatternProviderExternalPatternSink;
import com.refinedmods.refinedstorage.common.api.support.network.ConnectionStrategy;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeItem;
import com.refinedmods.refinedstorage.common.autocrafting.PatternInventory;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterBlockEntity;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterData;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.InWorldExternalPatternSinkKey;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.ExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.Platform;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.AutocrafterConnectionStrategy;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.AutocrafterNetworkNodeContainer;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.AutocrafterParentContainer;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.ExtendedPatternProviderNetworkNode;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.ImportMode;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.ImportModeSettings;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.LockMode;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.LockModeSettings;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.TaskSnapshotPersistence;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.TieredAutocrafterContainerMenu;
import com.ultramega.cabletiers.common.autocrafting.sidedinput.SidedInputPatternState;
import com.ultramega.cabletiers.common.autocrafting.sidedinput.SidedResourceAmount;
import com.ultramega.cabletiers.common.importer.AbstractTieredImporterBlockEntity;
import com.ultramega.cabletiers.common.registry.BlockEntities;
import com.ultramega.cabletiers.common.registry.DataComponents;
import com.ultramega.cabletiers.common.utils.ContentNames;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TieredAutocrafterBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<ExtendedPatternProviderNetworkNode>
implements ExtendedMenuProvider<AutocrafterData>,
BlockEntityWithDrops,
PatternInventory.Listener,
StepBehavior,
ExternalPatternSinkKeyProvider,
PatternProviderExternalPatternSink,
PatternProviderListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TieredAutocrafterBlockEntity.class);
    private static final int MAX_CHAINED_AUTOCRAFTERS = 8;
    private static final String TAG_UPGRADES = "upgr";
    private static final String TAG_PATTERNS = "patterns";
    private static final String TAG_LOCK_MODE = "lm";
    private static final String TAG_PRIORITY = "pri";
    private static final String TAG_TASKS = "tasks";
    private static final String TAG_VISIBLE_TO_THE_AUTOCRAFTER_MANAGER = "vaum";
    private static final String TAG_IMPORT_MODE = "im";
    private static final String TAG_LOCKED = "locked";
    private static final String TAG_WAS_POWERED = "wp";
    private final PatternInventory patternContainer;
    private final UpgradeContainer upgradeContainer;
    private LockMode lockMode = LockMode.NEVER;
    private ImportMode importMode = ImportMode.DONT_IMPORT;
    private boolean visibleToTheAutocrafterManager = true;
    private int ticks;
    private int steps;
    private int tickRate;
    private final PlatformPatternProviderExternalPatternSink[] sinks = new PlatformPatternProviderExternalPatternSink[Direction.values().length];
    @Nullable
    private ExternalPatternSinkKey sinkKey;
    private boolean wasPowered;
    private boolean locked;
    private final CableTiers tier;

    public TieredAutocrafterBlockEntity(CableTiers tier, BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getTieredAutocrafters(tier), pos, state, (AbstractNetworkNode)new ExtendedPatternProviderNetworkNode(com.refinedmods.refinedstorage.common.Platform.INSTANCE.getConfig().getAutocrafter().getEnergyUsage(), tier.getFilterSlotsCount()));
        this.tier = tier;
        this.steps = TieredAutocrafterBlockEntity.getSteps(0, tier);
        this.tickRate = TieredAutocrafterBlockEntity.getTickRate(0, tier);
        this.patternContainer = new PatternInventory(tier.getFilterSlotsCount(), () -> ((TieredAutocrafterBlockEntity)this).getLevel());
        this.upgradeContainer = new UpgradeContainer((UpgradeDestination)UpgradeDestinations.AUTOCRAFTER, (c, upgradeEnergyUsage) -> {
            long baseEnergyUsage = Platform.getConfig().getTieredAutocrafters().getEnergyUsage(tier);
            long patternEnergyUsage = this.patternContainer.getEnergyUsage();
            ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + patternEnergyUsage + upgradeEnergyUsage);
            int amountOfSpeedUpgrades = c.getAmount((UpgradeItem)Items.INSTANCE.getSpeedUpgrade());
            this.tickRate = TieredAutocrafterBlockEntity.getTickRate(amountOfSpeedUpgrades, tier);
            this.steps = TieredAutocrafterBlockEntity.getSteps(amountOfSpeedUpgrades, tier);
            this.setChanged();
        });
        this.patternContainer.addListener(container -> {
            long upgradeEnergyUsage = this.upgradeContainer.getEnergyUsage();
            long baseEnergyUsage = Platform.getConfig().getTieredAutocrafters().getEnergyUsage(tier);
            long patternEnergyUsage = this.patternContainer.getEnergyUsage();
            ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + patternEnergyUsage + upgradeEnergyUsage);
            this.setChanged();
        });
        this.patternContainer.setListener((PatternInventory.Listener)this);
        ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).setStepBehavior(this);
        ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).setSinkKeyProvider(this);
        ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).setSink(this);
        ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).setListener(this);
        ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).onAddedIntoContainer(new AutocrafterParentContainer(this));
    }

    protected InWorldNetworkNodeContainer createMainContainer(ExtendedPatternProviderNetworkNode networkNode) {
        return new AutocrafterNetworkNodeContainer(this, (NetworkNode)networkNode, "main", (ConnectionStrategy)new AutocrafterConnectionStrategy(() -> ((TieredAutocrafterBlockEntity)this).getBlockState(), this.getBlockPos()));
    }

    FilteredContainer getPatternContainer() {
        return this.patternContainer;
    }

    UpgradeContainer getUpgradeContainer() {
        return this.upgradeContainer;
    }

    private boolean isPartOfChain() {
        return this.getChainingRoot() != this;
    }

    private boolean isHeadOfChain() {
        if (this.level == null || this.isPartOfChain()) {
            return false;
        }
        for (Direction direction : Direction.values()) {
            TieredAutocrafterBlockEntity neighborAutocrafter;
            Direction neighborDirection;
            BlockEntity neighbor;
            BlockPos pos = this.getBlockPos().relative(direction);
            if (!this.level.isLoaded(pos) || !((neighbor = this.level.getBlockEntity(pos)) instanceof TieredAutocrafterBlockEntity) || (neighborDirection = AbstractDirectionalBlock.tryExtractDirection((BlockState)(neighborAutocrafter = (TieredAutocrafterBlockEntity)neighbor).getBlockState())) != direction.getOpposite()) continue;
            return true;
        }
        return false;
    }

    private TieredAutocrafterBlockEntity getChainingRoot() {
        return this.getChainingRoot(0, this);
    }

    private TieredAutocrafterBlockEntity getChainingRoot(int depth, TieredAutocrafterBlockEntity origin) {
        Direction direction = AbstractDirectionalBlock.tryExtractDirection((BlockState)this.getBlockState());
        if (this.level == null || direction == null || depth >= 8) {
            return origin;
        }
        BlockEntity neighbor = this.getConnectedMachine();
        if (!(neighbor instanceof TieredAutocrafterBlockEntity)) {
            return this;
        }
        TieredAutocrafterBlockEntity neighborCrafter = (TieredAutocrafterBlockEntity)neighbor;
        return neighborCrafter.getChainingRoot(depth + 1, origin);
    }

    @Nullable
    private BlockEntity getConnectedMachine() {
        Direction direction = AbstractDirectionalBlock.tryExtractDirection((BlockState)this.getBlockState());
        if (this.level == null || direction == null) {
            return null;
        }
        BlockPos neighborPos = this.getBlockPos().relative(direction);
        if (!this.level.isLoaded(neighborPos)) {
            return null;
        }
        return this.level.getBlockEntity(neighborPos);
    }

    public Component getName() {
        TieredAutocrafterBlockEntity root = this.getChainingRoot();
        if (root == this) {
            return this.doGetName();
        }
        return root.getName();
    }

    private Component doGetName() {
        Component customName = this.getCustomName();
        if (customName != null) {
            return customName;
        }
        BlockEntity connectedMachine = this.getConnectedMachine();
        if (connectedMachine instanceof Nameable) {
            Nameable nameable = (Nameable)connectedMachine;
            if (!(connectedMachine instanceof AutocrafterBlockEntity) && !(connectedMachine instanceof TieredAutocrafterBlockEntity)) {
                return nameable.getName();
            }
        }
        if (connectedMachine != null) {
            return connectedMachine.getBlockState().getBlock().getName();
        }
        return ContentNames.getContentName(this.tier, CableType.AUTOCRAFTER);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new TieredAutocrafterContainerMenu(syncId, inventory, this, this.tier);
    }

    public AutocrafterData getMenuData() {
        return new AutocrafterData(this.isPartOfChain(), this.isHeadOfChain(), this.locked);
    }

    public StreamEncoder<RegistryFriendlyByteBuf, AutocrafterData> getMenuCodec() {
        return AutocrafterData.STREAM_CODEC;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_PATTERNS, (Tag)ContainerUtil.write((Container)this.patternContainer, (HolderLookup.Provider)provider));
        tag.put(TAG_UPGRADES, (Tag)ContainerUtil.write((Container)this.upgradeContainer, (HolderLookup.Provider)provider));
        tag.putBoolean(TAG_LOCKED, this.locked);
        tag.putBoolean(TAG_WAS_POWERED, this.wasPowered);
        ListTag tasks = new ListTag();
        for (Task task : ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).getTasks()) {
            if (!(task instanceof TaskImpl)) continue;
            TaskImpl taskImpl = (TaskImpl)task;
            try {
                tasks.add((Object)TaskSnapshotPersistence.encodeSnapshot(taskImpl.createSnapshot()));
            }
            catch (Exception e) {
                LOGGER.error("Error while saving task {} {}", new Object[]{task.getResource(), task.getAmount(), e});
            }
        }
        tag.put(TAG_TASKS, (Tag)tasks);
    }

    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        tag.putInt(TAG_LOCK_MODE, LockModeSettings.getLockMode(this.lockMode));
        tag.putInt(TAG_PRIORITY, ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).getPriority());
        tag.putBoolean(TAG_VISIBLE_TO_THE_AUTOCRAFTER_MANAGER, this.visibleToTheAutocrafterManager);
        tag.putInt(TAG_IMPORT_MODE, ImportModeSettings.getImportMode(this.importMode));
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_PATTERNS)) {
            ContainerUtil.read((CompoundTag)tag.getCompound(TAG_PATTERNS), (Container)this.patternContainer, (HolderLookup.Provider)provider);
        }
        if (tag.contains(TAG_UPGRADES)) {
            ContainerUtil.read((CompoundTag)tag.getCompound(TAG_UPGRADES), (Container)this.upgradeContainer, (HolderLookup.Provider)provider);
        }
        if (tag.contains(TAG_TASKS)) {
            ListTag tasks = tag.getList(TAG_TASKS, 10);
            for (int i = 0; i < tasks.size(); ++i) {
                CompoundTag taskTag = tasks.getCompound(i);
                try {
                    TaskSnapshot snapshot = TaskSnapshotPersistence.decodeSnapshot(taskTag);
                    ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).addTask((Task)new TaskImpl(snapshot));
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Error while loading task, skipping", (Throwable)e);
                }
            }
        }
        if (tag.contains(TAG_LOCKED)) {
            this.locked = tag.getBoolean(TAG_LOCKED);
        }
        if (tag.contains(TAG_WAS_POWERED)) {
            this.wasPowered = tag.getBoolean(TAG_WAS_POWERED);
        }
        super.loadAdditional(tag, provider);
    }

    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        if (tag.contains(TAG_LOCK_MODE)) {
            this.lockMode = LockModeSettings.getLockMode(tag.getInt(TAG_LOCK_MODE));
        }
        if (tag.contains(TAG_PRIORITY)) {
            ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).setPriority(tag.getInt(TAG_PRIORITY));
        }
        if (tag.contains(TAG_VISIBLE_TO_THE_AUTOCRAFTER_MANAGER)) {
            this.visibleToTheAutocrafterManager = tag.getBoolean(TAG_VISIBLE_TO_THE_AUTOCRAFTER_MANAGER);
        }
        if (tag.contains(TAG_IMPORT_MODE)) {
            this.importMode = ImportModeSettings.getImportMode(tag.getInt(TAG_IMPORT_MODE));
        }
    }

    protected boolean hasRedstoneMode() {
        return false;
    }

    public List<ItemStack> getUpgrades() {
        return this.upgradeContainer.getUpgrades();
    }

    public boolean addUpgrade(ItemStack upgradeStack) {
        return this.upgradeContainer.addUpgrade(upgradeStack);
    }

    public NonNullList<ItemStack> getDrops() {
        NonNullList drops = NonNullList.create();
        drops.addAll((Collection)this.upgradeContainer.getDrops());
        for (int i = 0; i < this.patternContainer.getContainerSize(); ++i) {
            drops.add((Object)this.patternContainer.getItem(i));
        }
        return drops;
    }

    void setCustomName(String name) {
        if (this.isPartOfChain()) {
            return;
        }
        this.setCustomName((Component)(name.trim().isBlank() ? null : Component.literal((String)name)));
        this.setChanged();
    }

    LockMode getLockMode() {
        return this.lockMode;
    }

    void setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
        this.locked = false;
        this.wasPowered = false;
        this.setChanged();
    }

    int getPriority() {
        return ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).getPriority();
    }

    void setPriority(int priority) {
        ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).setPriority(priority);
        this.setChanged();
    }

    boolean isVisibleToTheAutocrafterManager() {
        return this.visibleToTheAutocrafterManager;
    }

    void setVisibleToTheAutocrafterManager(boolean visibleToTheAutocrafterManager) {
        this.visibleToTheAutocrafterManager = visibleToTheAutocrafterManager;
        this.setChanged();
    }

    ImportMode getImportMode() {
        return this.importMode;
    }

    void setImportMode(ImportMode importMode) {
        this.importMode = importMode;
        this.setChanged();
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (level.isClientSide()) {
            return;
        }
        for (int i = 0; i < this.patternContainer.getContainerSize(); ++i) {
            this.patternChanged(i);
        }
    }

    protected void initialize(ServerLevel level, Direction direction) {
        super.initialize(level, direction);
        this.invalidateSinkKey();
        for (int i = 0; i < Direction.values().length; ++i) {
            Direction incomingDirection = Direction.values()[i];
            BlockPos sourcePosition = this.worldPosition.relative(direction);
            this.sinks[i] = RefinedStorageApi.INSTANCE.getPatternProviderExternalPatternSinkFactory().create(level, sourcePosition, incomingDirection);
        }
        ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).setImportMode(this::getImportMode);
        ImporterTransferStrategy strategy = AbstractTieredImporterBlockEntity.createStrategy(level, direction, this.worldPosition, this.upgradeContainer);
        LOGGER.debug("Initialized autocrafter at {} with strategy {}", (Object)this.worldPosition, (Object)strategy);
        ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).setTransferStrategy(strategy);
    }

    public void patternChanged(int slot) {
        if (this.level == null) {
            return;
        }
        Pattern pattern = RefinedStorageApi.INSTANCE.getPattern(this.patternContainer.getItem(slot), this.level).orElse(null);
        ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).setPattern(slot, pattern);
        ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).updatePatternOutputFilter(slot, pattern);
    }

    public void doWork() {
        for (int i = 0; i < this.tier.getSpeed(CableType.AUTOCRAFTER); ++i) {
            super.doWork();
        }
        if (((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).isActive()) {
            ++this.ticks;
        }
        this.updateLocked();
    }

    private void updateLocked() {
        boolean newLocked = this.calculateLocked();
        if (newLocked != this.locked) {
            this.setLocked(newLocked);
        }
    }

    private void setLocked(boolean locked) {
        this.locked = locked;
        this.setChanged();
    }

    boolean isLocked() {
        return this.locked;
    }

    private boolean calculateLocked() {
        if (this.level == null) {
            return false;
        }
        return switch (this.lockMode) {
            default -> throw new MatchException(null, null);
            case LockMode.NEVER -> false;
            case LockMode.LOCK_UNTIL_REDSTONE_PULSE_RECEIVED -> this.isLockedInPulseMode();
            case LockMode.LOCK_UNTIL_CONNECTED_MACHINE_IS_EMPTY -> {
                if (!Arrays.stream(this.sinks).filter(Objects::nonNull).allMatch(PlatformPatternProviderExternalPatternSink::isEmpty)) {
                    yield true;
                }
                yield false;
            }
            case LockMode.LOCK_UNTIL_ALL_OUTPUTS_ARE_RECEIVED -> this.locked;
            case LockMode.LOCK_UNTIL_HIGH_REDSTONE_SIGNAL -> {
                if (!this.level.hasNeighborSignal(this.worldPosition)) {
                    yield true;
                }
                yield false;
            }
            case LockMode.LOCK_UNTIL_LOW_REDSTONE_SIGNAL -> this.level.hasNeighborSignal(this.worldPosition);
        };
    }

    private boolean isLockedInPulseMode() {
        if (this.level != null && this.level.hasNeighborSignal(this.worldPosition)) {
            this.wasPowered = true;
            this.setChanged();
        } else if (this.wasPowered) {
            this.wasPowered = false;
            this.setChanged();
            return false;
        }
        return this.locked;
    }

    public boolean canStep(Pattern pattern) {
        PatternProvider provider = this.lookupProvider(pattern);
        if (provider == null) {
            return false;
        }
        if (provider == this.mainNetworkNode) {
            if (this.tickRate == 0) {
                return true;
            }
            return ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).isActive() && this.ticks % this.tickRate == 0;
        }
        return provider.canStep(pattern);
    }

    public int getSteps(Pattern pattern) {
        PatternProvider provider = this.lookupProvider(pattern);
        if (provider == null) {
            return 0;
        }
        if (provider == this.mainNetworkNode) {
            return this.steps;
        }
        return provider.getSteps(pattern);
    }

    private static int getSteps(int amountOfSpeedUpgrades, CableTiers tier) {
        int speed = switch (amountOfSpeedUpgrades) {
            case 1 -> 2;
            case 2 -> 3;
            case 3 -> 4;
            case 4 -> 5;
            default -> 1;
        };
        return speed * tier.getSpeed(CableType.AUTOCRAFTER);
    }

    private static int getTickRate(int amountOfSpeedUpgrades, CableTiers tier) {
        int speed = switch (amountOfSpeedUpgrades) {
            case 0 -> 10;
            case 1 -> 8;
            case 2 -> 6;
            case 3 -> 4;
            case 4 -> 2;
            default -> 0;
        };
        return Math.max(0, speed / tier.getSpeed(CableType.AUTOCRAFTER));
    }

    @Nullable
    private PatternProvider lookupProvider(Pattern pattern) {
        Network network = ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).getNetwork();
        if (network == null) {
            return null;
        }
        return ((AutocraftingNetworkComponent)network.getComponent(AutocraftingNetworkComponent.class)).getProviderByPattern(pattern);
    }

    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(BlockState oldBlockState, BlockState newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange((BlockState)oldBlockState, (BlockState)newBlockState);
    }

    @Nullable
    public ExternalPatternSinkKey getKey() {
        if (this.sinkKey == null) {
            this.tryUpdateSinkKey();
        }
        return this.sinkKey;
    }

    private void tryUpdateSinkKey() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Direction direction = AbstractDirectionalBlock.tryExtractDirection((BlockState)this.getBlockState());
        if (direction == null) {
            return;
        }
        TieredAutocrafterBlockEntity root = this.getChainingRoot();
        BlockEntity connectedMachine = root.getConnectedMachine();
        if (connectedMachine == null) {
            this.invalidateSinkKey();
            return;
        }
        BlockState connectedMachineState = connectedMachine.getBlockState();
        Player fakePlayer = this.getFakePlayer(serverLevel);
        ItemStack connectedMachineStack = com.refinedmods.refinedstorage.common.Platform.INSTANCE.getBlockAsItemStack(connectedMachineState.getBlock(), connectedMachineState, direction.getOpposite(), (LevelReader)serverLevel, connectedMachine.getBlockPos(), fakePlayer);
        this.sinkKey = new InWorldExternalPatternSinkKey(this.getName().getString(), connectedMachineStack);
    }

    private void invalidateSinkKey() {
        this.sinkKey = null;
    }

    public ExternalPatternSink.Result accept(Collection<ResourceAmount> resources, Action action) {
        TieredAutocrafterBlockEntity root = this.getChainingRoot();
        if (root != this) {
            return root.accept(resources, action);
        }
        if (Arrays.stream(this.sinks).allMatch(Objects::isNull)) {
            return ExternalPatternSink.Result.SKIPPED;
        }
        if (this.locked) {
            return ExternalPatternSink.Result.LOCKED;
        }
        Direction baseDirection = AbstractDirectionalBlock.tryExtractDirection((BlockState)this.getBlockState());
        return TieredAutocrafterBlockEntity.findResult(this.sinks, (FilteredContainer)this.patternContainer, baseDirection, resources, action, this::updateLockedAfterAccept);
    }

    public static ExternalPatternSink.Result findResult(PlatformPatternProviderExternalPatternSink[] sinks, FilteredContainer patternContainer, @Nullable Direction baseDirection, Collection<ResourceAmount> resources, Action action, BiConsumer<Action, ExternalPatternSink.Result> afterAccept) {
        Direction fallbackDirection;
        SidedInputPatternState sidedInputState = TieredAutocrafterBlockEntity.findSidedInputPatternState(patternContainer, resources.stream().toList());
        Direction direction = fallbackDirection = baseDirection != null ? baseDirection.getOpposite() : null;
        if (sidedInputState != null) {
            ArrayList<ExternalPatternSink.Result> results = new ArrayList<ExternalPatternSink.Result>();
            ArrayList<ResourceAmount> insertedResources = new ArrayList<ResourceAmount>();
            for (Optional<SidedResourceAmount> optionalResource : sidedInputState.sidedResources()) {
                if (optionalResource.isEmpty()) continue;
                SidedResourceAmount sidedResource = optionalResource.get();
                ResourceAmount resource = sidedResource.resource();
                Direction targetDirection = sidedResource.inputDirection().orElse(fallbackDirection);
                if (targetDirection == null) continue;
                ExternalPatternSink.Result result = sinks[targetDirection.ordinal()].accept(Set.of(resource), action);
                afterAccept.accept(action, result);
                results.add(result);
                insertedResources.add(resource);
            }
            if (baseDirection != null) {
                for (ResourceAmount resource : resources) {
                    if (insertedResources.contains(resource)) continue;
                    ExternalPatternSink.Result result = sinks[baseDirection.getOpposite().ordinal()].accept(Set.of(resource), action);
                    afterAccept.accept(action, result);
                    results.add(result);
                }
            }
            if (!results.isEmpty()) {
                return TieredAutocrafterBlockEntity.getMostImportantResult(results);
            }
        }
        if (baseDirection == null) {
            return ExternalPatternSink.Result.REJECTED;
        }
        ExternalPatternSink.Result result = sinks[baseDirection.getOpposite().ordinal()].accept(resources, action);
        afterAccept.accept(action, result);
        return result;
    }

    @Nullable
    public static SidedInputPatternState findSidedInputPatternState(FilteredContainer patternContainer, List<ResourceAmount> resources) {
        for (int i = 0; i < patternContainer.getContainerSize(); ++i) {
            List<SidedResourceAmount> sidedResources;
            ItemStack pattern = patternContainer.getItem(i);
            SidedInputPatternState sidedInputState = (SidedInputPatternState)pattern.get(DataComponents.INSTANCE.getSidedInputPatternState());
            if (sidedInputState == null || (sidedResources = sidedInputState.sidedResources().stream().filter(Optional::isPresent).map(Optional::get).toList()).size() > resources.size()) continue;
            boolean resourcesMatch = true;
            for (int idx = 0; idx < sidedResources.size(); ++idx) {
                SidedResourceAmount sidedResourceAmount = sidedResources.get(idx);
                ResourceAmount sidedResource = sidedResourceAmount.resource();
                ResourceAmount ingResource = resources.get(idx);
                if (ingResource.equals((Object)sidedResource)) continue;
                resourcesMatch = false;
                break;
            }
            if (!resourcesMatch) continue;
            return sidedInputState;
        }
        return null;
    }

    public static ExternalPatternSink.Result getMostImportantResult(List<ExternalPatternSink.Result> results) {
        for (ExternalPatternSink.Result result : results) {
            if (result != ExternalPatternSink.Result.ACCEPTED) continue;
            return result;
        }
        return results.getFirst();
    }

    private void updateLockedAfterAccept(Action action, ExternalPatternSink.Result result) {
        if (result == ExternalPatternSink.Result.ACCEPTED && action == Action.EXECUTE && this.lockMode == LockMode.LOCK_UNTIL_CONNECTED_MACHINE_IS_EMPTY) {
            this.updateLocked();
        }
        if (result == ExternalPatternSink.Result.ACCEPTED && action == Action.EXECUTE && (this.lockMode == LockMode.LOCK_UNTIL_REDSTONE_PULSE_RECEIVED || this.lockMode == LockMode.LOCK_UNTIL_ALL_OUTPUTS_ARE_RECEIVED)) {
            this.setLocked(true);
        }
    }

    public void receivedExternalIteration() {
        TieredAutocrafterBlockEntity root = this.getChainingRoot();
        if (root != this) {
            root.receivedExternalIteration();
            return;
        }
        if (this.lockMode == LockMode.LOCK_UNTIL_ALL_OUTPUTS_ARE_RECEIVED && this.locked) {
            this.setLocked(false);
        }
    }

    public void completedOrCancelledTask(Task task) {
        ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).removeRequestedResourceFilter(task);
    }
}

