/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.storage.diskinterface;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.refinedmods.refinedstorage.common.storage.Disk;
import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import com.refinedmods.refinedstorage.common.support.render.AbstractDiskLedBlockEntityRenderer;
import com.ultramega.cabletiers.common.storage.diskinterface.AbstractTieredDiskInterfaceBlockEntity;
import com.ultramega.cabletiers.common.storage.diskinterface.TieredDiskInterfaceBlock;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractTieredDiskInterfaceBlockEntityRenderer<T extends AbstractTieredDiskInterfaceBlockEntity>
extends AbstractDiskLedBlockEntityRenderer<T> {
    private final RenderType renderType;

    protected AbstractTieredDiskInterfaceBlockEntityRenderer(RenderType renderType) {
        this.renderType = renderType;
    }

    @Nullable
    protected abstract Disk[] getDisks(T var1);

    public void render(T entity, float tickDelta, PoseStack poseStack, MultiBufferSource vertexConsumers, int light, int overlay) {
        Level level = entity.getLevel();
        if (level == null) {
            return;
        }
        BlockState blockState = level.getBlockState(entity.getBlockPos());
        Block block = blockState.getBlock();
        if (!(block instanceof TieredDiskInterfaceBlock)) {
            return;
        }
        TieredDiskInterfaceBlock diskInterfaceBlock = (TieredDiskInterfaceBlock)block;
        BiDirection direction = (BiDirection)diskInterfaceBlock.getDirection(blockState);
        if (direction == null) {
            return;
        }
        Disk[] disks = this.getDisks(entity);
        if (disks != null) {
            AbstractTieredDiskInterfaceBlockEntityRenderer.rotate((PoseStack)poseStack, (BiDirection)direction);
            this.renderDiskLeds(poseStack, disks, vertexConsumers.getBuffer(this.renderType));
            AbstractTieredDiskInterfaceBlockEntityRenderer.postRotate((PoseStack)poseStack);
        }
    }

    private void renderDiskLeds(PoseStack poseStack, Disk[] disks, VertexConsumer vertexConsumer) {
        for (int i = 0; i < 6; ++i) {
            int x = i < 3 ? 0 : 1;
            int y = i % 3;
            Disk disk = disks[i];
            this.renderLed(poseStack, vertexConsumer, 10 - x * 7, 8 - y * 3, -1, disk, Direction.SOUTH);
        }
    }
}

