/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.utils;

import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.utils.CableTiersIdentifierUtil;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.network.chat.MutableComponent;

public final class ContentNames {
    private static final Map<CableTiers, Map<CableType, MutableComponent>> CONTENT_MAP = new EnumMap<CableTiers, Map<CableType, MutableComponent>>(CableTiers.class);

    private ContentNames() {
    }

    public static MutableComponent getContentName(CableTiers tier, CableType type) {
        return (MutableComponent)CONTENT_MAP.getOrDefault((Object)tier, Map.of()).get((Object)type);
    }

    private static MutableComponent name(String name) {
        return CableTiersIdentifierUtil.createCableTiersTranslation("block", name);
    }

    static {
        for (CableTiers tier : CableTiers.values()) {
            EnumMap<CableType, MutableComponent> map = new EnumMap<CableType, MutableComponent>(CableType.class);
            for (CableType type : CableType.values()) {
                map.put(type, ContentNames.name(tier.name().toLowerCase(Locale.ROOT) + "_" + type.name().toLowerCase(Locale.ROOT)));
            }
            CONTENT_MAP.put(tier, map);
        }
    }
}

