/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.neoforge;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.network.AbstractNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.content.BlockEntityProvider;
import com.refinedmods.refinedstorage.common.content.BlockEntityTypeFactory;
import com.refinedmods.refinedstorage.common.content.ExtendedMenuTypeFactory;
import com.refinedmods.refinedstorage.common.content.RegistryCallback;
import com.refinedmods.refinedstorage.common.support.packet.PacketHandler;
import com.refinedmods.refinedstorage.neoforge.api.RefinedStorageNeoForgeApi;
import com.refinedmods.refinedstorage.neoforge.support.inventory.InsertExtractItemHandler;
import com.ultramega.cabletiers.common.AbstractModInitializer;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.Platform;
import com.ultramega.cabletiers.common.packet.c2s.ChangeAdvancedResourceSlotPacket;
import com.ultramega.cabletiers.common.packet.c2s.RequestSidedResourcesPacket;
import com.ultramega.cabletiers.common.packet.c2s.SetAdvancedFilterPacket;
import com.ultramega.cabletiers.common.packet.c2s.SetSidedResourcesOnPatternGridBlockPacket;
import com.ultramega.cabletiers.common.packet.c2s.TieredAutocrafterNameChangePacket;
import com.ultramega.cabletiers.common.packet.s2c.RemoveSidedResourcesOnPatternGridMenuPacket;
import com.ultramega.cabletiers.common.packet.s2c.SetSidedResourcesOnPatternGridMenuPacket;
import com.ultramega.cabletiers.common.packet.s2c.ShouldOpenAdvancedFilterPacket;
import com.ultramega.cabletiers.common.packet.s2c.TieredAutocrafterLockedUpdatePacket;
import com.ultramega.cabletiers.common.packet.s2c.TieredAutocrafterNameUpdatePacket;
import com.ultramega.cabletiers.common.packet.s2c.UpdateAdvancedFilterPacket;
import com.ultramega.cabletiers.common.registry.BlockEntities;
import com.ultramega.cabletiers.common.registry.CreativeModeTabItems;
import com.ultramega.cabletiers.common.utils.BlockEntityProviders;
import com.ultramega.cabletiers.common.utils.BlockEntityTierProvider;
import com.ultramega.cabletiers.common.utils.BlockEntityTierTypeFactory;
import com.ultramega.cabletiers.common.utils.TagsCache;
import com.ultramega.cabletiers.neoforge.ClientModInitializer;
import com.ultramega.cabletiers.neoforge.ConfigImpl;
import com.ultramega.cabletiers.neoforge.constructordestructor.ForgeTieredConstructorBlockEntity;
import com.ultramega.cabletiers.neoforge.constructordestructor.ForgeTieredDestructorBlockEntity;
import com.ultramega.cabletiers.neoforge.exporter.ForgeTieredExporterBlockEntity;
import com.ultramega.cabletiers.neoforge.importer.ForgeTieredImporterBlockEntity;
import com.ultramega.cabletiers.neoforge.storage.diskinterface.ForgeTieredDiskInterfaceBlockEntity;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="cabletiers")
public class ModInitializer
extends AbstractModInitializer {
    private static final BlockEntityProviders BLOCK_ENTITY_PROVIDERS = new BlockEntityProviders(ForgeTieredImporterBlockEntity::new, ForgeTieredExporterBlockEntity::new, ForgeTieredDestructorBlockEntity::new, ForgeTieredConstructorBlockEntity::new, ForgeTieredDiskInterfaceBlockEntity::new);
    private final DeferredRegister<Item> itemRegistry = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"cabletiers");
    private final DeferredRegister<Block> blockRegistry = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"cabletiers");
    private final DeferredRegister<BlockEntityType<?>> blockEntityTypeRegistry = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"cabletiers");
    private final DeferredRegister<MenuType<?>> menuTypeRegistry = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"cabletiers");
    private final DeferredRegister<DataComponentType<?>> dataComponentTypeRegistry = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"cabletiers");

    public ModInitializer(IEventBus eventBus, ModContainer modContainer) {
        ConfigImpl config = new ConfigImpl();
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)config.getSpec());
        Platform.setConfigProvider(() -> config);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
            eventBus.addListener(ClientModInitializer::onClientSetup);
            eventBus.addListener(ClientModInitializer::onRegisterCustomModels);
            eventBus.addListener(ClientModInitializer::onRegisterMenuScreens);
        }
        eventBus.addListener(this::onCommonSetup);
        this.registerContent(eventBus);
        eventBus.addListener(this::registerCapabilities);
        eventBus.addListener(this::registerPackets);
        eventBus.addListener(this::registerCreativeModeTabListener);
        NeoForge.EVENT_BUS.addListener(this::onTagsUpdated);
    }

    private void registerContent(IEventBus eventBus) {
        this.registerBlocks(eventBus);
        this.registerItems(eventBus);
        this.registerBlockEntities(eventBus);
        this.registerMenus(eventBus);
        this.registerDataComponents(eventBus);
    }

    private void registerBlocks(IEventBus eventBus) {
        ForgeRegistryCallback<Block> callback = new ForgeRegistryCallback<Block>(this.blockRegistry);
        this.registerBlocks(callback, BLOCK_ENTITY_PROVIDERS);
        this.blockRegistry.register(eventBus);
    }

    private void registerItems(IEventBus eventBus) {
        ForgeRegistryCallback<Item> callback = new ForgeRegistryCallback<Item>(this.itemRegistry);
        this.registerItems(callback);
        this.itemRegistry.register(eventBus);
    }

    private void registerBlockEntities(IEventBus eventBus) {
        this.registerBlockEntities(new ForgeRegistryCallback(this.blockEntityTypeRegistry), new BlockEntityTierTypeFactory(this){

            @Override
            public <T extends BlockEntity> BlockEntityType<T> create(CableTiers tier, BlockEntityTierProvider<T> factory, Block ... allowedBlocks) {
                return new BlockEntityType((pos, state) -> factory.create(tier, pos, state), new HashSet<Block>(Arrays.asList(allowedBlocks)), null);
            }
        }, new BlockEntityTypeFactory(this){

            public <T extends BlockEntity> BlockEntityType<T> create(BlockEntityProvider<T> factory, Block ... allowedBlocks) {
                return new BlockEntityType((arg_0, arg_1) -> factory.create(arg_0, arg_1), new HashSet<Block>(Arrays.asList(allowedBlocks)), null);
            }
        }, BLOCK_ENTITY_PROVIDERS);
        this.blockEntityTypeRegistry.register(eventBus);
    }

    private void registerMenus(IEventBus eventBus) {
        this.registerMenus(new ForgeRegistryCallback(this.menuTypeRegistry), new ExtendedMenuTypeFactory(this){

            public <T extends AbstractContainerMenu, D> MenuType<T> create(ExtendedMenuTypeFactory.MenuSupplier<T, D> supplier, StreamCodec<RegistryFriendlyByteBuf, D> streamCodec) {
                return IMenuTypeExtension.create((syncId, inventory, buf) -> {
                    Object data = streamCodec.decode((Object)buf);
                    return supplier.create(syncId, inventory, data);
                });
            }
        });
        this.menuTypeRegistry.register(eventBus);
    }

    private void registerDataComponents(IEventBus eventBus) {
        ForgeRegistryCallback callback = new ForgeRegistryCallback(this.dataComponentTypeRegistry);
        this.registerDataComponents(callback);
        this.dataComponentTypeRegistry.register(eventBus);
    }

    private void onCommonSetup(FMLCommonSetupEvent e) {
        this.registerUpgradeMappings();
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        for (CableTiers tier : CableTiers.values()) {
            this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getTieredImporters(tier));
            this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getTieredExporters(tier));
            this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getTieredDestructors(tier));
            this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getTieredConstructors(tier));
            this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getTieredDiskInterfaces(tier));
            this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getTieredAutocrafters(tier));
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BlockEntities.INSTANCE.getTieredDiskInterfaces(tier), (be, side) -> {
                InvWrapper wrapper = new InvWrapper((Container)be.getDiskInventory());
                return new InsertExtractItemHandler((IItemHandler)new RangedWrapper((IItemHandlerModifiable)wrapper, 0, 3), (IItemHandler)new RangedWrapper((IItemHandlerModifiable)wrapper, 3, 6));
            });
        }
    }

    private void registerNetworkNodeContainerProvider(RegisterCapabilitiesEvent event, BlockEntityType<? extends AbstractNetworkNodeContainerBlockEntity<?>> type) {
        event.registerBlockEntity(RefinedStorageNeoForgeApi.INSTANCE.getNetworkNodeContainerProviderCapability(), type, (be, side) -> be.getContainerProvider());
    }

    private void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("cabletiers");
        ModInitializer.registerServerToClientPackets(registrar);
        ModInitializer.registerClientToServerPackets(registrar);
    }

    private static void registerServerToClientPackets(PayloadRegistrar registrar) {
        registrar.playToClient(ShouldOpenAdvancedFilterPacket.PACKET_TYPE, ShouldOpenAdvancedFilterPacket.STREAM_CODEC, ModInitializer.wrapHandler(ShouldOpenAdvancedFilterPacket::handle));
        registrar.playToClient(UpdateAdvancedFilterPacket.PACKET_TYPE, UpdateAdvancedFilterPacket.STREAM_CODEC, ModInitializer.wrapHandler(UpdateAdvancedFilterPacket::handle));
        registrar.playToClient(TieredAutocrafterLockedUpdatePacket.PACKET_TYPE, TieredAutocrafterLockedUpdatePacket.STREAM_CODEC, ModInitializer.wrapHandler(TieredAutocrafterLockedUpdatePacket::handle));
        registrar.playToClient(TieredAutocrafterNameUpdatePacket.PACKET_TYPE, TieredAutocrafterNameUpdatePacket.STREAM_CODEC, ModInitializer.wrapHandler(TieredAutocrafterNameUpdatePacket::handle));
        registrar.playToClient(SetSidedResourcesOnPatternGridMenuPacket.PACKET_TYPE, SetSidedResourcesOnPatternGridMenuPacket.STREAM_CODEC, ModInitializer.wrapHandler(SetSidedResourcesOnPatternGridMenuPacket::handle));
        registrar.playToClient(RemoveSidedResourcesOnPatternGridMenuPacket.PACKET_TYPE, RemoveSidedResourcesOnPatternGridMenuPacket.STREAM_CODEC, ModInitializer.wrapHandler(RemoveSidedResourcesOnPatternGridMenuPacket::handle));
    }

    private static void registerClientToServerPackets(PayloadRegistrar registrar) {
        registrar.playToServer(ChangeAdvancedResourceSlotPacket.PACKET_TYPE, ChangeAdvancedResourceSlotPacket.STREAM_CODEC, ModInitializer.wrapHandler(ChangeAdvancedResourceSlotPacket::handle));
        registrar.playToServer(SetAdvancedFilterPacket.PACKET_TYPE, SetAdvancedFilterPacket.STREAM_CODEC, ModInitializer.wrapHandler(SetAdvancedFilterPacket::handle));
        registrar.playToServer(TieredAutocrafterNameChangePacket.PACKET_TYPE, TieredAutocrafterNameChangePacket.STREAM_CODEC, ModInitializer.wrapHandler(TieredAutocrafterNameChangePacket::handle));
        registrar.playToServer(RequestSidedResourcesPacket.PACKET_TYPE, RequestSidedResourcesPacket.STREAM_CODEC, ModInitializer.wrapHandler(RequestSidedResourcesPacket::handle));
        registrar.playToServer(SetSidedResourcesOnPatternGridBlockPacket.PACKET_TYPE, SetSidedResourcesOnPatternGridBlockPacket.STREAM_CODEC, ModInitializer.wrapHandler(SetSidedResourcesOnPatternGridBlockPacket::handle));
    }

    private static <T extends CustomPacketPayload> IPayloadHandler<T> wrapHandler(PacketHandler<T> handler) {
        return (packet, ctx) -> handler.handle((Object)packet, () -> ((IPayloadContext)ctx).player());
    }

    private void registerCreativeModeTabListener(BuildCreativeModeTabContentsEvent e) {
        ResourceKey creativeModeTab = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)RefinedStorageApi.INSTANCE.getCreativeModeTabId());
        ResourceKey coloredCreativeModeTab = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)RefinedStorageApi.INSTANCE.getColoredCreativeModeTabId());
        if (e.getTabKey().equals(creativeModeTab)) {
            CreativeModeTabItems.appendBlocks(arg_0 -> ((BuildCreativeModeTabContentsEvent)e).accept(arg_0));
        } else if (e.getTabKey().equals(coloredCreativeModeTab)) {
            CreativeModeTabItems.appendColoredVariants(arg_0 -> ((BuildCreativeModeTabContentsEvent)e).accept(arg_0));
        }
    }

    private void onTagsUpdated(TagsUpdatedEvent event) {
        TagsCache.invalidateAll();
    }

    private record ForgeRegistryCallback<T>(DeferredRegister<T> registry) implements RegistryCallback<T>
    {
        public <R extends T> Supplier<R> register(ResourceLocation id, Supplier<R> value) {
            return this.registry.register(id.getPath(), value);
        }
    }
}

