/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.neoforge.datagen;

import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.support.BaseBlockItem;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.TieredAutocrafterBlock;
import com.ultramega.cabletiers.common.constructordestructor.TieredConstructorBlock;
import com.ultramega.cabletiers.common.constructordestructor.TieredDestructorBlock;
import com.ultramega.cabletiers.common.exporter.TieredExporterBlock;
import com.ultramega.cabletiers.common.importer.TieredImporterBlock;
import com.ultramega.cabletiers.common.registry.Blocks;
import com.ultramega.cabletiers.common.storage.diskinterface.TieredDiskInterfaceBlock;
import com.ultramega.cabletiers.common.utils.CableTiersIdentifierUtil;
import com.ultramega.cabletiers.common.utils.ContentIds;
import com.ultramega.cabletiers.neoforge.datagen.TieredColoredCustomLoaderBuilder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemModelProviderImpl
extends ItemModelProvider {
    private static final String CABLE_TEXTURE_KEY = "cable";

    public ItemModelProviderImpl(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "cabletiers", existingFileHelper);
    }

    protected void registerModels() {
        for (CableTiers tier : CableTiers.values()) {
            this.registerTieredImporters(tier);
            this.registerTieredExporters(tier);
            this.registerTieredDestructors(tier);
            this.registerTieredConstructors(tier);
            this.registerTieredDiskInterfaces(tier);
            this.registerTieredAutocrafters(tier);
        }
    }

    private void registerTieredImporters(CableTiers tier) {
        ResourceLocation base = CableTiersIdentifierUtil.createCableTiersIdentifier("item/importer/" + tier.getLowercaseName() + "_base");
        BlockColorMap<TieredImporterBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getTieredImporters(tier);
        blocks.forEach((color, id, block) -> this.addCableTexture(color, id, base));
    }

    private void registerTieredExporters(CableTiers tier) {
        ResourceLocation base = CableTiersIdentifierUtil.createCableTiersIdentifier("item/exporter/" + tier.getLowercaseName() + "_base");
        BlockColorMap<TieredExporterBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getTieredExporters(tier);
        blocks.forEach((color, id, block) -> this.addCableTexture(color, id, base));
    }

    private void registerTieredDestructors(CableTiers tier) {
        ResourceLocation base = CableTiersIdentifierUtil.createCableTiersIdentifier("item/destructor/" + tier.getLowercaseName() + "_base");
        BlockColorMap<TieredDestructorBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getTieredDestructors(tier);
        blocks.forEach((color, id, block) -> this.addCableTexture(color, id, base));
    }

    private void registerTieredConstructors(CableTiers tier) {
        ResourceLocation base = CableTiersIdentifierUtil.createCableTiersIdentifier("item/constructor/" + tier.getLowercaseName() + "_base");
        BlockColorMap<TieredConstructorBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getTieredConstructors(tier);
        blocks.forEach((color, id, block) -> this.addCableTexture(color, id, base));
    }

    private void registerTieredDiskInterfaces(CableTiers tier) {
        BlockColorMap<TieredDiskInterfaceBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getTieredDiskInterfaces(tier);
        blocks.forEach((color, id, block) -> ((TieredColoredCustomLoaderBuilder)((ItemModelBuilder)this.getBuilder(id.getPath())).customLoader((blockModelBuilder, existingFileHelper) -> new TieredColoredCustomLoaderBuilder<ItemModelBuilder>(this, ContentIds.getContentId(tier, CableType.DISK_INTERFACE), blockModelBuilder, existingFileHelper, color, tier){})).end());
    }

    private void registerTieredAutocrafters(CableTiers tier) {
        BlockColorMap<TieredAutocrafterBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getTieredAutocrafters(tier);
        blocks.forEach((color, id, block) -> this.withExistingParent(id.getPath(), CableTiersIdentifierUtil.createCableTiersIdentifier("block/" + tier.getLowercaseName() + "_autocrafter/" + color.getName())));
    }

    private void addCableTexture(DyeColor color, ResourceLocation id, ResourceLocation base) {
        this.singleTexture(id.getPath(), base, CABLE_TEXTURE_KEY, IdentifierUtil.createIdentifier((String)("block/cable/" + color.getName())));
    }
}

