/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.neoforge.datagen.tag;

import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.registry.Blocks;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockTagsProvider
extends TagsProvider<Block> {
    public static final TagKey<Block> MINEABLE = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"mineable/pickaxe"));

    public BlockTagsProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> providerCompletableFuture, @Nullable ExistingFileHelper existingFileHelper) {
        super(packOutput, Registries.BLOCK, providerCompletableFuture, "cabletiers", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        for (CableTiers cableTiers : CableTiers.values()) {
            this.addAllToTag(cableTiers.getBlockTag(CableType.IMPORTER), Blocks.INSTANCE.getTieredImporters(cableTiers));
            this.addAllToTag(cableTiers.getBlockTag(CableType.EXPORTER), Blocks.INSTANCE.getTieredExporters(cableTiers));
            this.addAllToTag(cableTiers.getBlockTag(CableType.DESTRUCTOR), Blocks.INSTANCE.getTieredDestructors(cableTiers));
            this.addAllToTag(cableTiers.getBlockTag(CableType.CONSTRUCTOR), Blocks.INSTANCE.getTieredConstructors(cableTiers));
            this.addAllToTag(cableTiers.getBlockTag(CableType.DISK_INTERFACE), Blocks.INSTANCE.getTieredDiskInterfaces(cableTiers));
            this.addAllToTag(cableTiers.getBlockTag(CableType.AUTOCRAFTER), Blocks.INSTANCE.getTieredAutocrafters(cableTiers));
        }
        for (Enum enum_ : CableType.values()) {
            for (CableTiers tier : CableTiers.values()) {
                this.tag(MINEABLE).addTag(tier.getBlockTag((CableType)enum_));
            }
        }
    }

    private <T extends Block> void addAllToTag(TagKey<Block> t, BlockColorMap<?, ?> blocks) {
        for (Block block : blocks.toArray()) {
            this.tag(t).add((ResourceKey)BuiltInRegistries.BLOCK.getResourceKey((Object)block).orElseThrow()).replace(false);
        }
    }
}

