/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.exporter;

import com.refinedmods.refinedstorage.api.network.node.SchedulingMode;
import com.refinedmods.refinedstorage.api.network.node.exporter.ExporterTransferStrategy;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.exporter.ExporterTransferStrategyFactory;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceTag;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeItem;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeState;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.exporter.ExporterData;
import com.refinedmods.refinedstorage.common.support.SchedulingModeContainer;
import com.refinedmods.refinedstorage.common.support.SchedulingModeType;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicator;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.TieredUpgradeDestinations;
import com.ultramega.cabletiers.common.advancedfilter.AdvancedResourceContainerImpl;
import com.ultramega.cabletiers.common.advancedfilter.TagFilterWithFuzzyMode;
import com.ultramega.cabletiers.common.exporter.CompositeExporterTransferStrategy;
import com.ultramega.cabletiers.common.exporter.TieredExporterContainerMenu;
import com.ultramega.cabletiers.common.exporter.TieredExporterNetworkNode;
import com.ultramega.cabletiers.common.exporter.TieredExportingIndicators;
import com.ultramega.cabletiers.common.registry.BlockEntities;
import com.ultramega.cabletiers.common.support.AbstractTieredCableLikeBlockEntity;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9142;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractTieredExporterBlockEntity
extends AbstractTieredCableLikeBlockEntity<TieredExporterNetworkNode>
implements NetworkNodeExtendedMenuProvider<ExporterData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTieredExporterBlockEntity.class);
    private final SchedulingModeContainer schedulingModeContainer;

    protected AbstractTieredExporterBlockEntity(final CableTiers tier, class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getTieredExporters(tier), pos, state, new TieredExporterNetworkNode(tier.getEnergyUsage(CableType.EXPORTER)), tier, CableType.EXPORTER);
        this.filter = TagFilterWithFuzzyMode.createAndListenForFilters(AdvancedResourceContainerImpl.createForFilter(tier), this::method_5431, this::setFilters);
        this.upgradeContainer = new UpgradeContainer(this, AbstractTieredExporterBlockEntity.getUpgradeDestination(tier), (c, upgradeEnergyUsage) -> {
            ((TieredExporterNetworkNode)this.mainNetworkNode).setEnergyUsage(tier.getEnergyUsage(CableType.EXPORTER) + upgradeEnergyUsage);
            this.method_5431();
            class_1937 patt0$temp = this.field_11863;
            if (patt0$temp instanceof class_3218) {
                class_3218 serverLevel = (class_3218)patt0$temp;
                this.initialize(serverLevel);
            }
        }){

            public boolean has(UpgradeItem upgradeItem) {
                if (tier.hasIntegratedStackUpgrade(CableType.EXPORTER) && upgradeItem == Items.INSTANCE.getStackUpgrade()) {
                    return true;
                }
                return super.has(upgradeItem);
            }

            public int getAmount(UpgradeItem upgradeItem) {
                if (tier == CableTiers.CREATIVE && upgradeItem == Items.INSTANCE.getSpeedUpgrade()) {
                    return 4;
                }
                return super.getAmount(upgradeItem);
            }
        };
        this.schedulingModeContainer = new SchedulingModeContainer(this::schedulingModeChanged);
        this.ticker = this.upgradeContainer.getTicker();
    }

    public static UpgradeDestination getUpgradeDestination(CableTiers tier) {
        return tier == CableTiers.CREATIVE ? TieredUpgradeDestinations.EXPORTER_NO_STACK_SPEED : (tier.hasIntegratedStackUpgrade(CableType.EXPORTER) ? TieredUpgradeDestinations.EXPORTER_NO_STACK : UpgradeDestinations.EXPORTER);
    }

    private void schedulingModeChanged(SchedulingMode schedulingMode) {
        ((TieredExporterNetworkNode)this.mainNetworkNode).setSchedulingMode(schedulingMode);
        this.method_5431();
    }

    void setFilters(List<ResourceKey> filters, List<ResourceTag> tagFilters) {
        ((TieredExporterNetworkNode)this.mainNetworkNode).setFilters(filters, tagFilters);
    }

    void setSchedulingModeType(SchedulingModeType type) {
        this.schedulingModeContainer.setType(type);
    }

    SchedulingModeType getSchedulingModeType() {
        return this.schedulingModeContainer.getType();
    }

    boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.initialize(serverLevel);
        }
    }

    @Override
    public void writeConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.writeConfiguration(tag, provider);
        this.schedulingModeContainer.writeToTag(tag);
    }

    @Override
    public void readConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.readConfiguration(tag, provider);
        this.schedulingModeContainer.loadFromTag(tag);
    }

    protected void initialize(class_3218 level, class_2350 direction) {
        super.initialize(level, direction);
        ExporterTransferStrategy strategy = this.createStrategy(level, direction);
        LOGGER.debug("Initialized exporter at {} with strategy {}", (Object)this.field_11867, (Object)strategy);
        ((TieredExporterNetworkNode)this.mainNetworkNode).setTransferStrategy(strategy);
    }

    private ExporterTransferStrategy createStrategy(class_3218 serverLevel, class_2350 direction) {
        class_2350 incomingDirection = direction.method_10153();
        class_2338 sourcePosition = this.field_11867.method_10093(direction);
        List factories = RefinedStorageApi.INSTANCE.getExporterTransferStrategyRegistry().getAll();
        Map<Class<? extends ResourceKey>, ExporterTransferStrategy> strategies = factories.stream().collect(Collectors.toMap(ExporterTransferStrategyFactory::getResourceType, factory -> factory.create(serverLevel, sourcePosition, incomingDirection, (UpgradeState)this.upgradeContainer, this.filter.isFuzzyMode())));
        return new CompositeExporterTransferStrategy(strategies);
    }

    public ExporterData getMenuData() {
        AdvancedResourceContainerImpl filterContainer = this.filter.getFilterContainer();
        ResourceContainerData resourceContainerData = ResourceContainerData.of((ResourceContainer)filterContainer);
        return new ExporterData(resourceContainerData, this.getExportingIndicators().getAll());
    }

    public class_9142<class_9129, ExporterData> getMenuCodec() {
        return ExporterData.STREAM_CODEC;
    }

    public class_2561 method_5477() {
        return this.overrideName((class_2561)this.tier.getContentName(CableType.EXPORTER));
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        this.setInContainerMenu(true);
        return new TieredExporterContainerMenu(syncId, player, this, (ResourceContainer)this.filter.getFilterContainer(), this.upgradeContainer, this.getExportingIndicators(), this.tier);
    }

    private TieredExportingIndicators getExportingIndicators() {
        return new TieredExportingIndicators(this.filter.getFilterContainer(), (i, j) -> this.toExportingIndicator(((TieredExporterNetworkNode)this.mainNetworkNode).getLastResult(i, j)), false);
    }

    private ExportingIndicator toExportingIndicator(@Nullable ExporterTransferStrategy.Result result) {
        ExporterTransferStrategy.Result result2 = result;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"DESTINATION_DOES_NOT_ACCEPT", "RESOURCE_MISSING", "AUTOCRAFTING_STARTED", "AUTOCRAFTING_MISSING_RESOURCES"}, (ExporterTransferStrategy.Result)result2, n)) {
            case 0 -> ExportingIndicator.DESTINATION_DOES_NOT_ACCEPT_RESOURCE;
            case 1 -> ExportingIndicator.RESOURCE_MISSING;
            case 2 -> ExportingIndicator.AUTOCRAFTING_WAS_STARTED;
            case 3 -> ExportingIndicator.AUTOCRAFTING_MISSING_RESOURCES;
            default -> ExportingIndicator.NONE;
        };
    }
}

