/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.support;

import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceTag;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeSlot;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.advancedfilter.AdvancedResourceSlot;
import com.ultramega.cabletiers.common.utils.TagFiltering;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_6862;

public abstract class AbstractTieredFilterContainerMenu<T extends TagFiltering>
extends AbstractResourceContainerMenu {
    private static final int FILTER_SLOT_X = 8;
    private static final int FILTER_SLOT_Y = 20;
    protected final CableTiers tier;
    protected int playerInventoryY;
    private final class_2561 filterHelp;
    @Nullable
    private TagFiltering blockEntity;
    @Nullable
    private List<ResourceTag> tagKeys;

    protected AbstractTieredFilterContainerMenu(class_3917<?> type, int syncId, class_1657 player, ResourceContainer resourceContainer, @Nullable UpgradeContainer upgradeContainer, T blockEntity, int playerInventoryY, class_2561 filterHelp, CableTiers tier) {
        super(type, syncId, player);
        this.filterHelp = filterHelp;
        this.tier = tier;
        this.blockEntity = blockEntity;
        this.playerInventoryY = playerInventoryY;
        this.registerServerProperties(blockEntity);
        this.addSlots(player, resourceContainer, upgradeContainer);
        this.blockEntity.setOnChanged(() -> {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                blockEntity.sendFilterTagsToClient(serverPlayer);
            }
        });
    }

    protected AbstractTieredFilterContainerMenu(class_3917<?> type, int syncId, class_1657 player, ResourceContainerData resourceContainerData, @Nullable UpgradeDestination upgradeDestination, int playerInventoryY, class_2561 filterHelp, CableTiers tier) {
        super(type, syncId);
        this.filterHelp = filterHelp;
        this.tier = tier;
        this.playerInventoryY = playerInventoryY;
        this.registerClientProperties();
        this.addSlots(player, ResourceContainerImpl.createForFilter((ResourceContainerData)resourceContainerData), upgradeDestination == null ? null : new UpgradeContainer(upgradeDestination));
    }

    protected abstract void registerClientProperties();

    protected abstract void registerServerProperties(T var1);

    protected void addSlots(class_1657 player, ResourceContainer resourceContainer, @Nullable UpgradeContainer upgradeContainer) {
        int i;
        for (i = 0; i < resourceContainer.size(); ++i) {
            this.method_7621(this.createFilterSlot(resourceContainer, i));
        }
        if (upgradeContainer != null) {
            for (i = 0; i < upgradeContainer.method_5439(); ++i) {
                this.method_7621((class_1735)new UpgradeSlot(upgradeContainer, i, 187, 6 + i * 18));
            }
        }
        this.addPlayerInventory(player.method_31548(), 8, this.playerInventoryY);
        if (upgradeContainer != null) {
            this.transferManager.addBiTransfer((class_1263)player.method_31548(), (class_1263)upgradeContainer);
        }
        this.transferManager.addFilterTransfer((class_1263)player.method_31548());
    }

    private class_1735 createFilterSlot(ResourceContainer resourceContainer, int i) {
        int x = 8 + 18 * (i % 9);
        int y = 20 + 18 * (i / 9);
        return new AdvancedResourceSlot(this, this.player, resourceContainer, i, this.filterHelp, x, y, ResourceSlotType.FILTER);
    }

    public void method_7595(class_1657 player) {
        if (this.blockEntity != null) {
            this.blockEntity.setInContainerMenu(false);
            this.blockEntity.resetFakeFilters();
        }
        super.method_7595(player);
    }

    public void setTagFilter(int slotIndex, @Nullable ResourceTag resourceTag) {
        if (this.blockEntity != null) {
            this.blockEntity.setTagFilter(slotIndex, resourceTag);
        }
    }

    @Nullable
    public class_6862<?> getTagFilter(int slotIndex) {
        if (this.blockEntity != null) {
            return this.blockEntity.getTagFilter(slotIndex);
        }
        return null;
    }

    public void setTagKeys(List<ResourceTag> tagKeys) {
        this.tagKeys = tagKeys;
    }

    @Nullable
    public List<ResourceTag> getTagKeys() {
        return this.tagKeys;
    }
}

