/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.mixin;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.AbstractGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.GridData;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.ultramega.cabletiers.common.autocrafting.sidedinput.SidedInputScreen;
import com.ultramega.cabletiers.common.autocrafting.sidedinput.SidedResourceAmount;
import com.ultramega.cabletiers.common.packet.c2s.SetSidedResourcesOnPatternGridBlockPacket;
import com.ultramega.cabletiers.common.packet.s2c.RemoveSidedResourcesOnPatternGridMenuPacket;
import com.ultramega.cabletiers.common.utils.SidedInput;
import com.ultramega.cabletiers.common.utils.ValidSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PatternGridContainerMenu.class})
public abstract class MixinPatternGridContainerMenu
extends AbstractGridContainerMenu
implements SidedInput {
    @Shadow
    @Nullable
    private Slot patternOutputSlot;
    @Shadow
    @Final
    private Container patternOutput;
    @Unique
    private List<Optional<SidedResourceAmount>> cabletiers$sidedResources = new ArrayList<Optional<SidedResourceAmount>>();

    protected MixinPatternGridContainerMenu(MenuType<? extends AbstractGridContainerMenu> menuType, int syncId, Inventory playerInventory, GridData gridData) {
        super(menuType, syncId, playerInventory, gridData);
    }

    @Inject(method={"sendClear"}, at={@At(value="HEAD")}, remap=false)
    private void sendClear(CallbackInfo ci) {
        this.cabletiers$sidedResources.replaceAll(ignored -> Optional.empty());
        Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new SetSidedResourcesOnPatternGridBlockPacket(this.cabletiers$sidedResources));
    }

    @Inject(method={"addPatternSlots"}, at={@At(value="TAIL")}, remap=false)
    private void addPatternSlots(int playerInventoryY, CallbackInfo ci) {
        Slot slot = this.patternOutputSlot;
        if (slot instanceof ValidSlot) {
            ValidSlot validSlot = (ValidSlot)slot;
            validSlot.cabletiers$setPatternGridContainerMenu(this.patternOutput);
        }
    }

    @Override
    @Unique
    public void cabletiers$setSidedResources(List<Optional<SidedResourceAmount>> sidedResources) {
        this.cabletiers$sidedResources = sidedResources;
    }

    @Override
    @Unique
    public void cabletiers$removeSidedResources(int index) {
        this.cabletiers$sidedResources.set(index, Optional.empty());
        Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new SetSidedResourcesOnPatternGridBlockPacket(this.cabletiers$sidedResources));
    }

    @Override
    @Unique
    public List<Optional<SidedResourceAmount>> cabletiers$getSidedResources() {
        return this.cabletiers$sidedResources;
    }

    @Unique
    public void handleResourceSlotChange(int slotIndex, boolean tryAlternatives) {
        Player player;
        super.handleResourceSlotChange(slotIndex, tryAlternatives);
        if (!this.getCarried().isEmpty() || !((player = this.player) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        int index = 0;
        for (ResourceSlot slot : this.getResourceSlots()) {
            if (!SidedInputScreen.isProcessingInputSlot(slot)) continue;
            if (slot.index == slotIndex) {
                Platform.INSTANCE.sendPacketToClient(serverPlayer, (CustomPacketPayload)new RemoveSidedResourcesOnPatternGridMenuPacket(index));
                break;
            }
            ++index;
        }
    }
}

