/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.storage.diskinterface;

import com.refinedmods.refinedstorage.api.network.impl.node.storagetransfer.StorageTransferListener;
import com.refinedmods.refinedstorage.api.network.impl.node.storagetransfer.StorageTransferMode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeItem;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.support.FilterModeSettings;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.TieredUpgradeDestinations;
import com.ultramega.cabletiers.common.registry.BlockEntities;
import com.ultramega.cabletiers.common.storage.AbstractTieredDiskContainerBlockEntity;
import com.ultramega.cabletiers.common.storage.AdvancedStorageTransferNetworkNode;
import com.ultramega.cabletiers.common.storage.diskinterface.TieredDiskInterfaceContainerMenu;
import com.ultramega.cabletiers.common.storage.diskinterface.TransferModeSettings;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractTieredDiskInterfaceBlockEntity
extends AbstractTieredDiskContainerBlockEntity<AdvancedStorageTransferNetworkNode>
implements StorageTransferListener {
    public static final int AMOUNT_OF_DISKS = 6;
    private static final String TAG_UPGRADES = "upgr";
    private static final String TAG_FILTER_MODE = "fim";
    private static final String TAG_TRANSFER_MODE = "tm";
    private final UpgradeContainer upgradeContainer;

    protected AbstractTieredDiskInterfaceBlockEntity(final CableTiers tier, BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getTieredDiskInterfaces(tier), pos, state, new AdvancedStorageTransferNetworkNode(tier.getEnergyUsage(CableType.DISK_INTERFACE), Platform.INSTANCE.getConfig().getDiskInterface().getEnergyUsagePerDisk(), 6), tier, CableType.DISK_INTERFACE);
        this.upgradeContainer = new UpgradeContainer(this, AbstractTieredDiskInterfaceBlockEntity.getUpgradeDestination(tier), (c, upgradeEnergyUsage) -> {
            ((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).setEnergyUsage(tier.getEnergyUsage(CableType.DISK_INTERFACE) + upgradeEnergyUsage);
            this.setChanged();
        }){

            public boolean has(UpgradeItem upgradeItem) {
                if (tier.hasIntegratedStackUpgrade(CableType.DISK_INTERFACE) && upgradeItem == Items.INSTANCE.getStackUpgrade()) {
                    return true;
                }
                return super.has(upgradeItem);
            }

            public int getAmount(UpgradeItem upgradeItem) {
                if (tier == CableTiers.CREATIVE && upgradeItem == Items.INSTANCE.getSpeedUpgrade()) {
                    return 4;
                }
                return super.getAmount(upgradeItem);
            }
        };
        this.ticker = this.upgradeContainer.getTicker();
        ((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).setListener(this);
        ((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).setTransferQuotaProvider(storage -> {
            if (storage instanceof SerializableStorage) {
                SerializableStorage serializableStorage = (SerializableStorage)storage;
                return serializableStorage.getType().getDiskInterfaceTransferQuota(this.upgradeContainer.has((UpgradeItem)Items.INSTANCE.getStackUpgrade())) * (long)tier.getSpeed(CableType.DISK_INTERFACE);
            }
            return tier.getSpeed(CableType.DISK_INTERFACE);
        });
    }

    public static UpgradeDestination getUpgradeDestination(CableTiers tier) {
        return tier.hasIntegratedStackUpgrade(CableType.DISK_INTERFACE) ? TieredUpgradeDestinations.DISK_INTERFACE_NO_STACK : UpgradeDestinations.DISK_INTERFACE;
    }

    @Override
    protected void setFilters(Set<ResourceKey> filters, Set<TagKey<?>> tagFilters) {
        ((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).setFilters(filters, tagFilters);
    }

    @Override
    protected void setNormalizer(UnaryOperator<ResourceKey> normalizer) {
        ((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).setNormalizer(normalizer);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_UPGRADES)) {
            ContainerUtil.read((CompoundTag)tag.getCompound(TAG_UPGRADES), (Container)this.upgradeContainer, (HolderLookup.Provider)provider);
        }
        super.loadAdditional(tag, provider);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_UPGRADES, (Tag)ContainerUtil.write((Container)this.upgradeContainer, (HolderLookup.Provider)provider));
        tag.putInt(TAG_FILTER_MODE, FilterModeSettings.getFilterMode((FilterMode)((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).getFilterMode()));
    }

    @Override
    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        if (tag.contains(TAG_TRANSFER_MODE)) {
            ((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).setMode(TransferModeSettings.getTransferMode(tag.getInt(TAG_TRANSFER_MODE)));
        }
        if (tag.contains(TAG_FILTER_MODE)) {
            ((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).setFilterMode(FilterModeSettings.getFilterMode((int)tag.getInt(TAG_FILTER_MODE)));
        }
    }

    @Override
    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        tag.putInt(TAG_TRANSFER_MODE, TransferModeSettings.getTransferMode(((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).getMode()));
    }

    public List<ItemStack> getUpgrades() {
        return this.upgradeContainer.getUpgrades();
    }

    public boolean addUpgrade(ItemStack upgradeStack) {
        return this.upgradeContainer.addUpgrade(upgradeStack);
    }

    public Component getName() {
        return this.overrideName((Component)this.tier.getContentName(CableType.DISK_INTERFACE));
    }

    public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
        this.setInContainerMenu(true);
        return new TieredDiskInterfaceContainerMenu(syncId, player, this, this.diskInventory, (ResourceContainer)this.filter.getFilterContainer(), this.upgradeContainer, this.tier);
    }

    @Override
    public final NonNullList<ItemStack> getDrops() {
        NonNullList<ItemStack> drops = super.getDrops();
        for (int i = 0; i < this.upgradeContainer.getContainerSize(); ++i) {
            drops.add((Object)this.upgradeContainer.getItem(i));
        }
        return drops;
    }

    boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
        this.setChanged();
    }

    FilterMode getFilterMode() {
        return ((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).getFilterMode();
    }

    void setFilterMode(FilterMode mode) {
        ((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).setFilterMode(mode);
        this.setChanged();
    }

    public StorageTransferMode getTransferMode() {
        return ((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).getMode();
    }

    public void setTransferMode(StorageTransferMode mode) {
        ((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).setMode(mode);
        this.setChanged();
    }

    public void onTransferSuccess(int index) {
        ItemStack diskStack = this.diskInventory.getItem(index);
        if (diskStack.isEmpty()) {
            return;
        }
        for (int newIndex = 3; newIndex < 6; ++newIndex) {
            if (!this.diskInventory.getItem(newIndex).isEmpty()) continue;
            this.diskInventory.setItem(index, ItemStack.EMPTY);
            this.diskInventory.setItem(newIndex, diskStack);
            return;
        }
    }
}

