/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.constructordestructor;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.constructordestructor.DestructorStrategy;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeItem;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeState;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilterModeSettings;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.TieredUpgradeDestinations;
import com.ultramega.cabletiers.common.advancedfilter.AdvancedResourceContainerImpl;
import com.ultramega.cabletiers.common.advancedfilter.TagFilterWithFuzzyMode;
import com.ultramega.cabletiers.common.constructordestructor.CompositeDestructorStrategy;
import com.ultramega.cabletiers.common.constructordestructor.TieredDestructorContainerMenu;
import com.ultramega.cabletiers.common.constructordestructor.TieredDestructorNetworkNode;
import com.ultramega.cabletiers.common.registry.BlockEntities;
import com.ultramega.cabletiers.common.support.AbstractTieredCableLikeBlockEntity;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9142;

public class AbstractTieredDestructorBlockEntity
extends AbstractTieredCableLikeBlockEntity<TieredDestructorNetworkNode>
implements NetworkNodeExtendedMenuProvider<ResourceContainerData>,
BlockEntityWithDrops {
    private static final String TAG_PICKUP_ITEMS = "pi";
    private boolean pickupItems;

    protected AbstractTieredDestructorBlockEntity(final CableTiers tier, class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getTieredDestructors(tier), pos, state, new TieredDestructorNetworkNode(tier.getEnergyUsage(CableType.DESTRUCTOR)), tier, CableType.DESTRUCTOR);
        this.filter = TagFilterWithFuzzyMode.createAndListenForUniqueFilters(AdvancedResourceContainerImpl.createForFilter(tier), this::method_5431, this::setFilters);
        this.upgradeContainer = new UpgradeContainer(this, AbstractTieredDestructorBlockEntity.getUpgradeDestination(tier), (c, upgradeEnergyUsage) -> {
            ((TieredDestructorNetworkNode)this.mainNetworkNode).setEnergyUsage(tier.getEnergyUsage(CableType.DESTRUCTOR) + upgradeEnergyUsage);
            this.method_5431();
            class_1937 patt0$temp = this.field_11863;
            if (patt0$temp instanceof class_3218) {
                class_3218 serverLevel = (class_3218)patt0$temp;
                this.initialize(serverLevel);
            }
        }, Math.max(1, 20 - tier.getSpeed(CableType.DESTRUCTOR))){

            public int getAmount(UpgradeItem upgradeItem) {
                if (tier == CableTiers.CREATIVE && upgradeItem == Items.INSTANCE.getSpeedUpgrade()) {
                    return 4;
                }
                return super.getAmount(upgradeItem);
            }
        };
        this.ticker = this.upgradeContainer.getTicker();
    }

    public static UpgradeDestination getUpgradeDestination(CableTiers tier) {
        return tier == CableTiers.CREATIVE ? TieredUpgradeDestinations.DESTRUCTOR_NO_SPEED : UpgradeDestinations.DESTRUCTOR;
    }

    public boolean isPickupItems() {
        return this.pickupItems;
    }

    public void setPickupItems(boolean pickupItems) {
        this.pickupItems = pickupItems;
        this.method_5431();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.initialize(serverLevel);
        }
    }

    void setFilters(Set<ResourceKey> filters, Set<class_6862<?>> tagFilters) {
        ((TieredDestructorNetworkNode)this.mainNetworkNode).setFilters(filters, tagFilters);
    }

    public FilterMode getFilterMode() {
        return ((TieredDestructorNetworkNode)this.mainNetworkNode).getFilterMode();
    }

    public void setFilterMode(FilterMode mode) {
        ((TieredDestructorNetworkNode)this.mainNetworkNode).setFilterMode(mode);
        this.method_5431();
    }

    @Override
    public void writeConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.writeConfiguration(tag, provider);
        tag.method_10569("fim", FilterModeSettings.getFilterMode((FilterMode)((TieredDestructorNetworkNode)this.mainNetworkNode).getFilterMode()));
        tag.method_10556(TAG_PICKUP_ITEMS, this.pickupItems);
    }

    @Override
    public void readConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.readConfiguration(tag, provider);
        if (tag.method_10545("fim")) {
            ((TieredDestructorNetworkNode)this.mainNetworkNode).setFilterMode(FilterModeSettings.getFilterMode((int)tag.method_10550("fim")));
        }
        if (tag.method_10545(TAG_PICKUP_ITEMS)) {
            this.pickupItems = tag.method_10577(TAG_PICKUP_ITEMS);
        }
    }

    protected void initialize(class_3218 level, class_2350 direction) {
        super.initialize(level, direction);
        ((TieredDestructorNetworkNode)this.mainNetworkNode).setPlayerProvider(() -> this.getFakePlayer(level));
        ((TieredDestructorNetworkNode)this.mainNetworkNode).setStrategy(this.createStrategy(level, direction));
    }

    private CompositeDestructorStrategy createStrategy(class_3218 level, class_2350 direction) {
        class_2338 pos = this.method_11016().method_10093(direction);
        class_2350 incomingDirection = direction.method_10153();
        List<DestructorStrategy> strategies = RefinedStorageApi.INSTANCE.getDestructorStrategyFactories().stream().flatMap(factory -> factory.create(level, pos, incomingDirection, (UpgradeState)this.upgradeContainer, this.pickupItems).stream()).toList();
        return new CompositeDestructorStrategy(strategies);
    }

    public ResourceContainerData getMenuData() {
        return ResourceContainerData.of((ResourceContainer)this.filter.getFilterContainer());
    }

    public class_9142<class_9129, ResourceContainerData> getMenuCodec() {
        return ResourceContainerData.STREAM_CODEC;
    }

    public class_2561 method_5477() {
        return this.overrideName((class_2561)this.tier.getContentName(CableType.DESTRUCTOR));
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        this.setInContainerMenu(true);
        return new TieredDestructorContainerMenu(syncId, player, this, (ResourceContainer)this.filter.getFilterContainer(), this.upgradeContainer, this.tier);
    }
}

