/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.constructordestructor;

import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.api.network.node.NetworkNodeActor;
import com.refinedmods.refinedstorage.api.network.node.SchedulingMode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.api.constructordestructor.ConstructorStrategy;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceTag;
import com.ultramega.cabletiers.common.advancedfilter.TagFilterWithFuzzyMode;
import com.ultramega.cabletiers.common.utils.TieredSimpleNetworkNode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1657;

public class TieredConstructorNetworkNode
extends TieredSimpleNetworkNode {
    private final Actor actor = new NetworkNodeActor((NetworkNode)this);
    private final List<TieredConstructorTask> tasks = new ArrayList<TieredConstructorTask>();
    @Nullable
    private Supplier<class_1657> playerProvider;
    @Nullable
    private ConstructorStrategy strategy;
    @Nullable
    private SchedulingMode schedulingMode;

    public TieredConstructorNetworkNode(long energyUsage) {
        super(energyUsage);
    }

    public void doWork() {
        super.doWork();
        if (this.network == null || !this.isActive() || this.schedulingMode == null) {
            return;
        }
        for (int i = 0; i < this.getTier().getSpeed(this.getType()); ++i) {
            this.schedulingMode.execute(this.tasks);
        }
    }

    void setStrategy(@Nullable ConstructorStrategy strategy) {
        this.strategy = strategy;
    }

    void setPlayerProvider(@Nullable Supplier<class_1657> playerSupplier) {
        this.playerProvider = playerSupplier;
    }

    void setSchedulingMode(@Nullable SchedulingMode schedulingMode) {
        this.schedulingMode = schedulingMode;
    }

    @Nullable
    public ConstructorStrategy.Result getLastResult(int filterIndex, int fakeIndex) {
        return this.tasks.get((int)(filterIndex + fakeIndex)).lastResult;
    }

    void setFilters(List<ResourceKey> filters, List<ResourceTag> tagFilters) {
        ArrayList<TieredConstructorTask> updatedTasks = new ArrayList<TieredConstructorTask>();
        for (int i = 0; i < filters.size(); ++i) {
            for (ResourceKey resource : TagFilterWithFuzzyMode.getResourcesFromFilter(filters, tagFilters, i)) {
                ConstructorStrategy.Result lastResult = i < this.tasks.size() && this.tasks.get((int)i).filter.equals((Object)resource) ? this.tasks.get((int)i).lastResult : null;
                updatedTasks.add(new TieredConstructorTask(resource, lastResult));
            }
        }
        this.tasks.clear();
        this.tasks.addAll(updatedTasks);
    }

    class TieredConstructorTask
    implements SchedulingMode.ScheduledTask {
        private final ResourceKey filter;
        @Nullable
        private ConstructorStrategy.Result lastResult;

        private TieredConstructorTask(@Nullable ResourceKey filter, ConstructorStrategy.Result lastResult) {
            this.filter = filter;
            this.lastResult = lastResult;
        }

        public boolean run() {
            if (TieredConstructorNetworkNode.this.strategy == null || TieredConstructorNetworkNode.this.network == null || TieredConstructorNetworkNode.this.playerProvider == null) {
                return false;
            }
            class_1657 player = TieredConstructorNetworkNode.this.playerProvider.get();
            this.lastResult = TieredConstructorNetworkNode.this.strategy.apply(this.filter, TieredConstructorNetworkNode.this.actor, player, TieredConstructorNetworkNode.this.network);
            return this.lastResult == ConstructorStrategy.Result.SUCCESS;
        }
    }
}

