/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.registry;

import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.support.BaseBlockItem;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.TieredAutocrafterBlock;
import com.ultramega.cabletiers.common.constructordestructor.AbstractTieredConstructorBlockEntity;
import com.ultramega.cabletiers.common.constructordestructor.AbstractTieredDestructorBlockEntity;
import com.ultramega.cabletiers.common.constructordestructor.TieredConstructorBlock;
import com.ultramega.cabletiers.common.constructordestructor.TieredDestructorBlock;
import com.ultramega.cabletiers.common.exporter.AbstractTieredExporterBlockEntity;
import com.ultramega.cabletiers.common.exporter.TieredExporterBlock;
import com.ultramega.cabletiers.common.iface.TieredInterfaceBlock;
import com.ultramega.cabletiers.common.importer.AbstractTieredImporterBlockEntity;
import com.ultramega.cabletiers.common.importer.TieredImporterBlock;
import com.ultramega.cabletiers.common.storage.diskinterface.AbstractTieredDiskInterfaceBlockEntity;
import com.ultramega.cabletiers.common.storage.diskinterface.TieredDiskInterfaceBlock;
import com.ultramega.cabletiers.common.utils.BlockEntityTierProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public final class Blocks {
    public static final Blocks INSTANCE = new Blocks();
    private final Map<CableTiers, BlockColorMap<TieredImporterBlock, BaseBlockItem>> tieredImporters = new HashMap<CableTiers, BlockColorMap<TieredImporterBlock, BaseBlockItem>>();
    private final Map<CableTiers, BlockColorMap<TieredExporterBlock, BaseBlockItem>> tieredExporters = new HashMap<CableTiers, BlockColorMap<TieredExporterBlock, BaseBlockItem>>();
    private final Map<CableTiers, BlockColorMap<TieredDestructorBlock, BaseBlockItem>> tieredDestructors = new HashMap<CableTiers, BlockColorMap<TieredDestructorBlock, BaseBlockItem>>();
    private final Map<CableTiers, BlockColorMap<TieredConstructorBlock, BaseBlockItem>> tieredConstructors = new HashMap<CableTiers, BlockColorMap<TieredConstructorBlock, BaseBlockItem>>();
    private final Map<CableTiers, BlockColorMap<TieredDiskInterfaceBlock, BaseBlockItem>> tieredDiskInterface = new HashMap<CableTiers, BlockColorMap<TieredDiskInterfaceBlock, BaseBlockItem>>();
    private final Map<CableTiers, BlockColorMap<TieredAutocrafterBlock, BaseBlockItem>> tieredAutocrafters = new HashMap<CableTiers, BlockColorMap<TieredAutocrafterBlock, BaseBlockItem>>();
    private final Map<CableTiers, Supplier<TieredInterfaceBlock>> tieredInterfaces = new HashMap<CableTiers, Supplier<TieredInterfaceBlock>>();

    private Blocks() {
    }

    public Map<CableTiers, BlockColorMap<TieredImporterBlock, BaseBlockItem>> setTieredImporters(BlockEntityTierProvider<AbstractTieredImporterBlockEntity> provider) {
        for (CableTiers tier : CableTiers.values()) {
            this.tieredImporters.put(tier, (BlockColorMap<TieredImporterBlock, BaseBlockItem>)new BlockColorMap((color, name) -> new TieredImporterBlock(color, name, tier, provider), tier.getContentId(CableType.IMPORTER), tier.getContentName(CableType.IMPORTER), com.refinedmods.refinedstorage.common.content.Blocks.CABLE_LIKE_COLOR));
        }
        return this.tieredImporters;
    }

    public BlockColorMap<TieredImporterBlock, BaseBlockItem> getTieredImporters(CableTiers tier) {
        return Objects.requireNonNull(this.tieredImporters.get((Object)tier));
    }

    public Map<CableTiers, BlockColorMap<TieredExporterBlock, BaseBlockItem>> setTieredExporters(BlockEntityTierProvider<AbstractTieredExporterBlockEntity> provider) {
        for (CableTiers tier : CableTiers.values()) {
            this.tieredExporters.put(tier, (BlockColorMap<TieredExporterBlock, BaseBlockItem>)new BlockColorMap((color, name) -> new TieredExporterBlock(color, name, tier, provider), tier.getContentId(CableType.EXPORTER), tier.getContentName(CableType.EXPORTER), com.refinedmods.refinedstorage.common.content.Blocks.CABLE_LIKE_COLOR));
        }
        return this.tieredExporters;
    }

    public BlockColorMap<TieredExporterBlock, BaseBlockItem> getTieredExporters(CableTiers tier) {
        return Objects.requireNonNull(this.tieredExporters.get((Object)tier));
    }

    public Map<CableTiers, BlockColorMap<TieredDestructorBlock, BaseBlockItem>> setTieredDestructors(BlockEntityTierProvider<AbstractTieredDestructorBlockEntity> provider) {
        for (CableTiers tier : CableTiers.values()) {
            this.tieredDestructors.put(tier, (BlockColorMap<TieredDestructorBlock, BaseBlockItem>)new BlockColorMap((color, name) -> new TieredDestructorBlock(color, name, tier, provider), tier.getContentId(CableType.DESTRUCTOR), tier.getContentName(CableType.DESTRUCTOR), com.refinedmods.refinedstorage.common.content.Blocks.CABLE_LIKE_COLOR));
        }
        return this.tieredDestructors;
    }

    public BlockColorMap<TieredDestructorBlock, BaseBlockItem> getTieredDestructors(CableTiers tier) {
        return Objects.requireNonNull(this.tieredDestructors.get((Object)tier));
    }

    public Map<CableTiers, BlockColorMap<TieredConstructorBlock, BaseBlockItem>> setTieredConstructors(BlockEntityTierProvider<AbstractTieredConstructorBlockEntity> provider) {
        for (CableTiers tier : CableTiers.values()) {
            this.tieredConstructors.put(tier, (BlockColorMap<TieredConstructorBlock, BaseBlockItem>)new BlockColorMap((color, name) -> new TieredConstructorBlock(color, name, tier, provider), tier.getContentId(CableType.CONSTRUCTOR), tier.getContentName(CableType.CONSTRUCTOR), com.refinedmods.refinedstorage.common.content.Blocks.CABLE_LIKE_COLOR));
        }
        return this.tieredConstructors;
    }

    public BlockColorMap<TieredConstructorBlock, BaseBlockItem> getTieredConstructors(CableTiers tier) {
        return Objects.requireNonNull(this.tieredConstructors.get((Object)tier));
    }

    public Map<CableTiers, BlockColorMap<TieredDiskInterfaceBlock, BaseBlockItem>> setTieredDiskInterfaces(BlockEntityTierProvider<AbstractTieredDiskInterfaceBlockEntity> provider) {
        for (CableTiers tier : CableTiers.values()) {
            this.tieredDiskInterface.put(tier, (BlockColorMap<TieredDiskInterfaceBlock, BaseBlockItem>)new BlockColorMap((color, name) -> new TieredDiskInterfaceBlock(color, name, tier, provider), tier.getContentId(CableType.DISK_INTERFACE), tier.getContentName(CableType.DISK_INTERFACE), com.refinedmods.refinedstorage.common.content.Blocks.COLOR));
        }
        return this.tieredDiskInterface;
    }

    public BlockColorMap<TieredDiskInterfaceBlock, BaseBlockItem> getTieredDiskInterfaces(CableTiers tier) {
        return Objects.requireNonNull(this.tieredDiskInterface.get((Object)tier));
    }

    public Map<CableTiers, BlockColorMap<TieredAutocrafterBlock, BaseBlockItem>> setTieredAutocrafters() {
        for (CableTiers tier : CableTiers.values()) {
            this.tieredAutocrafters.put(tier, (BlockColorMap<TieredAutocrafterBlock, BaseBlockItem>)new BlockColorMap((color, name) -> new TieredAutocrafterBlock(color, name, tier), tier.getContentId(CableType.AUTOCRAFTER), tier.getContentName(CableType.AUTOCRAFTER), com.refinedmods.refinedstorage.common.content.Blocks.COLOR));
        }
        return this.tieredAutocrafters;
    }

    public BlockColorMap<TieredAutocrafterBlock, BaseBlockItem> getTieredAutocrafters(CableTiers tier) {
        return Objects.requireNonNull(this.tieredAutocrafters.get((Object)tier));
    }

    public void setTieredInterfaces(CableTiers tier, Supplier<TieredInterfaceBlock> interfaceSupplier) {
        this.tieredInterfaces.put(tier, interfaceSupplier);
    }

    public Supplier<TieredInterfaceBlock> getTieredInterfaces(CableTiers tier) {
        return Objects.requireNonNull(this.tieredInterfaces.get((Object)tier));
    }
}

