/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.fabric.storage.diskinterface;

import com.refinedmods.refinedstorage.common.support.AbstractActiveColoredDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import com.refinedmods.refinedstorage.fabric.storage.AbstractDiskContainerBakedModel;
import com.refinedmods.refinedstorage.fabric.support.render.EmissiveTransform;
import com.refinedmods.refinedstorage.fabric.support.render.QuadRotators;
import com.refinedmods.refinedstorage.fabric.support.render.QuadTranslator;
import com.ultramega.cabletiers.common.storage.diskinterface.TieredDiskInterfaceBlock;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5819;

class TieredDiskInterfaceBakedModel
extends AbstractDiskContainerBakedModel {
    private final class_1087 inactiveModel;
    private final QuadRotators quadRotators;
    private final EmissiveTransform emissiveTransform;

    TieredDiskInterfaceBakedModel(class_1087 baseModel, class_1087 inactiveModel, Map<class_1792, class_1087> diskModels, class_1087 inactiveLedModel, QuadRotators quadRotators, class_2960 emissiveSprite) {
        super(diskModels, inactiveLedModel, TieredDiskInterfaceBakedModel.getDiskTranslations());
        this.wrapped = baseModel;
        this.inactiveModel = inactiveModel;
        this.quadRotators = quadRotators;
        this.emissiveTransform = new EmissiveTransform(Set.of(emissiveSprite));
    }

    private static QuadTranslator[] getDiskTranslations() {
        QuadTranslator[] translations = new QuadTranslator[6];
        for (int i = 0; i < translations.length; ++i) {
            boolean x = i >= 3;
            int y = i % 3;
            translations[i] = new QuadTranslator(!x ? -0.125f : -0.5625f, -((float)y * 3.0f / 16.0f) - 0.375f, 0.0f);
        }
        return translations;
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        context.pushTransform((RenderContext.QuadTransform)this.emissiveTransform);
        this.wrapped.emitItemQuads(stack, randomSupplier, context);
        context.popTransform();
        super.emitItemQuads(stack, randomSupplier, context);
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof TieredDiskInterfaceBlock)) {
            return;
        }
        TieredDiskInterfaceBlock diskInterfaceBlock = (TieredDiskInterfaceBlock)class_22482;
        BiDirection direction = (BiDirection)diskInterfaceBlock.getDirection(state);
        if (direction == null) {
            return;
        }
        context.pushTransform((RenderContext.QuadTransform)this.quadRotators.forDirection(direction));
        boolean active = (Boolean)state.method_11654((class_2769)AbstractActiveColoredDirectionalBlock.ACTIVE);
        if (active) {
            context.pushTransform((RenderContext.QuadTransform)this.emissiveTransform);
        }
        (active ? this.wrapped : this.inactiveModel).emitBlockQuads(blockView, state, pos, randomSupplier, context);
        super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        if (active) {
            context.popTransform();
        }
        context.popTransform();
    }
}

