/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.autocrafting.autocrafter;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSinkKey;
import com.refinedmods.refinedstorage.api.autocrafting.task.StepBehavior;
import com.refinedmods.refinedstorage.api.autocrafting.task.Task;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskImpl;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskSnapshot;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternProvider;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternProviderExternalPatternSink;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.patternprovider.ExternalPatternSinkKeyProvider;
import com.refinedmods.refinedstorage.api.network.impl.node.patternprovider.PatternProviderListener;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.api.network.node.importer.ImporterTransferStrategy;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.autocrafting.PlatformPatternProviderExternalPatternSink;
import com.refinedmods.refinedstorage.common.api.support.network.ConnectionStrategy;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeItem;
import com.refinedmods.refinedstorage.common.autocrafting.PatternInventory;
import com.refinedmods.refinedstorage.common.autocrafting.ProcessingPatternState;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterBlockEntity;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterData;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.InWorldExternalPatternSinkKey;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.ExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.Platform;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.AutocrafterConnectionStrategy;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.AutocrafterNetworkNodeContainer;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.AutocrafterParentContainer;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.ExtendedPatternProviderNetworkNode;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.ImportMode;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.ImportModeSettings;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.LockMode;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.LockModeSettings;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.TaskSnapshotPersistence;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.TieredAutocrafterContainerMenu;
import com.ultramega.cabletiers.common.autocrafting.sidedinput.SidedInputPatternState;
import com.ultramega.cabletiers.common.autocrafting.sidedinput.SidedResourceAmount;
import com.ultramega.cabletiers.common.importer.AbstractTieredImporterBlockEntity;
import com.ultramega.cabletiers.common.registry.BlockEntities;
import com.ultramega.cabletiers.common.utils.ContentNames;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9142;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TieredAutocrafterBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<ExtendedPatternProviderNetworkNode>
implements ExtendedMenuProvider<AutocrafterData>,
BlockEntityWithDrops,
PatternInventory.Listener,
StepBehavior,
ExternalPatternSinkKeyProvider,
PatternProviderExternalPatternSink,
PatternProviderListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TieredAutocrafterBlockEntity.class);
    private static final int MAX_CHAINED_AUTOCRAFTERS = 8;
    private static final String TAG_UPGRADES = "upgr";
    private static final String TAG_PATTERNS = "patterns";
    private static final String TAG_LOCK_MODE = "lm";
    private static final String TAG_PRIORITY = "pri";
    private static final String TAG_TASKS = "tasks";
    private static final String TAG_VISIBLE_TO_THE_AUTOCRAFTER_MANAGER = "vaum";
    private static final String TAG_IMPORT_MODE = "im";
    private static final String TAG_LOCKED = "locked";
    private static final String TAG_WAS_POWERED = "wp";
    private final PatternInventory patternContainer;
    private final UpgradeContainer upgradeContainer;
    private LockMode lockMode = LockMode.NEVER;
    private ImportMode importMode = ImportMode.DONT_IMPORT;
    private boolean visibleToTheAutocrafterManager = true;
    private int ticks;
    private int steps;
    private int tickRate;
    private final PlatformPatternProviderExternalPatternSink[] sinks = new PlatformPatternProviderExternalPatternSink[class_2350.values().length];
    @Nullable
    private ExternalPatternSinkKey sinkKey;
    private boolean wasPowered;
    private boolean locked;
    private final CableTiers tier;

    public TieredAutocrafterBlockEntity(CableTiers tier, class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getTieredAutocrafters(tier), pos, state, (AbstractNetworkNode)new ExtendedPatternProviderNetworkNode(com.refinedmods.refinedstorage.common.Platform.INSTANCE.getConfig().getAutocrafter().getEnergyUsage(), tier.getFilterSlotsCount()));
        this.tier = tier;
        this.steps = TieredAutocrafterBlockEntity.getSteps(0, tier);
        this.tickRate = TieredAutocrafterBlockEntity.getTickRate(0, tier);
        this.patternContainer = new PatternInventory(tier.getFilterSlotsCount(), () -> ((TieredAutocrafterBlockEntity)this).method_10997());
        this.upgradeContainer = new UpgradeContainer((UpgradeDestination)UpgradeDestinations.AUTOCRAFTER, (c, upgradeEnergyUsage) -> {
            long baseEnergyUsage = Platform.getConfig().getTieredAutocrafters().getEnergyUsage(tier);
            long patternEnergyUsage = this.patternContainer.getEnergyUsage();
            ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + patternEnergyUsage + upgradeEnergyUsage);
            int amountOfSpeedUpgrades = c.getAmount((UpgradeItem)Items.INSTANCE.getSpeedUpgrade());
            this.tickRate = TieredAutocrafterBlockEntity.getTickRate(amountOfSpeedUpgrades, tier);
            this.steps = TieredAutocrafterBlockEntity.getSteps(amountOfSpeedUpgrades, tier);
            this.method_5431();
        });
        this.patternContainer.method_5489(container -> {
            long upgradeEnergyUsage = this.upgradeContainer.getEnergyUsage();
            long baseEnergyUsage = Platform.getConfig().getTieredAutocrafters().getEnergyUsage(tier);
            long patternEnergyUsage = this.patternContainer.getEnergyUsage();
            ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + patternEnergyUsage + upgradeEnergyUsage);
            this.method_5431();
        });
        this.patternContainer.setListener((PatternInventory.Listener)this);
        ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).setStepBehavior(this);
        ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).setSinkKeyProvider(this);
        ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).setSink(this);
        ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).setListener(this);
        ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).onAddedIntoContainer(new AutocrafterParentContainer(this));
    }

    protected InWorldNetworkNodeContainer createMainContainer(ExtendedPatternProviderNetworkNode networkNode) {
        return new AutocrafterNetworkNodeContainer(this, (NetworkNode)networkNode, "main", (ConnectionStrategy)new AutocrafterConnectionStrategy(() -> ((TieredAutocrafterBlockEntity)this).method_11010(), this.method_11016()));
    }

    FilteredContainer getPatternContainer() {
        return this.patternContainer;
    }

    UpgradeContainer getUpgradeContainer() {
        return this.upgradeContainer;
    }

    private boolean isPartOfChain() {
        return this.getChainingRoot() != this;
    }

    private boolean isHeadOfChain() {
        if (this.field_11863 == null || this.isPartOfChain()) {
            return false;
        }
        for (class_2350 direction : class_2350.values()) {
            TieredAutocrafterBlockEntity neighborAutocrafter;
            class_2350 neighborDirection;
            class_2586 neighbor;
            class_2338 pos = this.method_11016().method_10093(direction);
            if (!this.field_11863.method_8477(pos) || !((neighbor = this.field_11863.method_8321(pos)) instanceof TieredAutocrafterBlockEntity) || (neighborDirection = AbstractDirectionalBlock.tryExtractDirection((class_2680)(neighborAutocrafter = (TieredAutocrafterBlockEntity)neighbor).method_11010())) != direction.method_10153()) continue;
            return true;
        }
        return false;
    }

    private TieredAutocrafterBlockEntity getChainingRoot() {
        return this.getChainingRoot(0, this);
    }

    private TieredAutocrafterBlockEntity getChainingRoot(int depth, TieredAutocrafterBlockEntity origin) {
        class_2350 direction = AbstractDirectionalBlock.tryExtractDirection((class_2680)this.method_11010());
        if (this.field_11863 == null || direction == null || depth >= 8) {
            return origin;
        }
        class_2586 neighbor = this.getConnectedMachine();
        if (!(neighbor instanceof TieredAutocrafterBlockEntity)) {
            return this;
        }
        TieredAutocrafterBlockEntity neighborCrafter = (TieredAutocrafterBlockEntity)neighbor;
        return neighborCrafter.getChainingRoot(depth + 1, origin);
    }

    @Nullable
    private class_2586 getConnectedMachine() {
        class_2350 direction = AbstractDirectionalBlock.tryExtractDirection((class_2680)this.method_11010());
        if (this.field_11863 == null || direction == null) {
            return null;
        }
        class_2338 neighborPos = this.method_11016().method_10093(direction);
        if (!this.field_11863.method_8477(neighborPos)) {
            return null;
        }
        return this.field_11863.method_8321(neighborPos);
    }

    public class_2561 method_5477() {
        TieredAutocrafterBlockEntity root = this.getChainingRoot();
        if (root == this) {
            return this.doGetName();
        }
        return root.method_5477();
    }

    private class_2561 doGetName() {
        class_2561 customName = this.method_5797();
        if (customName != null) {
            return customName;
        }
        class_2586 connectedMachine = this.getConnectedMachine();
        if (connectedMachine instanceof class_1275) {
            class_1275 nameable = (class_1275)connectedMachine;
            if (!(connectedMachine instanceof AutocrafterBlockEntity) && !(connectedMachine instanceof TieredAutocrafterBlockEntity)) {
                return nameable.method_5477();
            }
        }
        if (connectedMachine != null) {
            return connectedMachine.method_11010().method_26204().method_9518();
        }
        return ContentNames.getContentName(this.tier, CableType.AUTOCRAFTER);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        return new TieredAutocrafterContainerMenu(syncId, inventory, this, this.tier);
    }

    public AutocrafterData getMenuData() {
        return new AutocrafterData(this.isPartOfChain(), this.isHeadOfChain(), this.locked);
    }

    public class_9142<class_9129, AutocrafterData> getMenuCodec() {
        return AutocrafterData.STREAM_CODEC;
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10566(TAG_PATTERNS, (class_2520)ContainerUtil.write((class_1263)this.patternContainer, (class_7225.class_7874)provider));
        tag.method_10566(TAG_UPGRADES, (class_2520)ContainerUtil.write((class_1263)this.upgradeContainer, (class_7225.class_7874)provider));
        tag.method_10556(TAG_LOCKED, this.locked);
        tag.method_10556(TAG_WAS_POWERED, this.wasPowered);
        class_2499 tasks = new class_2499();
        for (Task task : ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).getTasks()) {
            if (!(task instanceof TaskImpl)) continue;
            TaskImpl taskImpl = (TaskImpl)task;
            try {
                tasks.add((Object)TaskSnapshotPersistence.encodeSnapshot(taskImpl.createSnapshot()));
            }
            catch (Exception e) {
                LOGGER.error("Error while saving task {} {}", new Object[]{task.getResource(), task.getAmount(), e});
            }
        }
        tag.method_10566(TAG_TASKS, (class_2520)tasks);
    }

    public void writeConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.writeConfiguration(tag, provider);
        tag.method_10569(TAG_LOCK_MODE, LockModeSettings.getLockMode(this.lockMode));
        tag.method_10569(TAG_PRIORITY, ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).getPriority());
        tag.method_10556(TAG_VISIBLE_TO_THE_AUTOCRAFTER_MANAGER, this.visibleToTheAutocrafterManager);
        tag.method_10569(TAG_IMPORT_MODE, ImportModeSettings.getImportMode(this.importMode));
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        if (tag.method_10545(TAG_PATTERNS)) {
            ContainerUtil.read((class_2487)tag.method_10562(TAG_PATTERNS), (class_1263)this.patternContainer, (class_7225.class_7874)provider);
        }
        if (tag.method_10545(TAG_UPGRADES)) {
            ContainerUtil.read((class_2487)tag.method_10562(TAG_UPGRADES), (class_1263)this.upgradeContainer, (class_7225.class_7874)provider);
        }
        if (tag.method_10545(TAG_TASKS)) {
            class_2499 tasks = tag.method_10554(TAG_TASKS, 10);
            for (int i = 0; i < tasks.size(); ++i) {
                class_2487 taskTag = tasks.method_10602(i);
                try {
                    TaskSnapshot snapshot = TaskSnapshotPersistence.decodeSnapshot(taskTag);
                    ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).addTask((Task)new TaskImpl(snapshot));
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Error while loading task, skipping", (Throwable)e);
                }
            }
        }
        if (tag.method_10545(TAG_LOCKED)) {
            this.locked = tag.method_10577(TAG_LOCKED);
        }
        if (tag.method_10545(TAG_WAS_POWERED)) {
            this.wasPowered = tag.method_10577(TAG_WAS_POWERED);
        }
        super.method_11014(tag, provider);
    }

    public void readConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.readConfiguration(tag, provider);
        if (tag.method_10545(TAG_LOCK_MODE)) {
            this.lockMode = LockModeSettings.getLockMode(tag.method_10550(TAG_LOCK_MODE));
        }
        if (tag.method_10545(TAG_PRIORITY)) {
            ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).setPriority(tag.method_10550(TAG_PRIORITY));
        }
        if (tag.method_10545(TAG_VISIBLE_TO_THE_AUTOCRAFTER_MANAGER)) {
            this.visibleToTheAutocrafterManager = tag.method_10577(TAG_VISIBLE_TO_THE_AUTOCRAFTER_MANAGER);
        }
        if (tag.method_10545(TAG_IMPORT_MODE)) {
            this.importMode = ImportModeSettings.getImportMode(tag.method_10550(TAG_IMPORT_MODE));
        }
    }

    protected boolean hasRedstoneMode() {
        return false;
    }

    public List<class_1799> getUpgrades() {
        return this.upgradeContainer.getUpgrades();
    }

    public boolean addUpgrade(class_1799 upgradeStack) {
        return this.upgradeContainer.addUpgrade(upgradeStack);
    }

    public class_2371<class_1799> getDrops() {
        class_2371 drops = class_2371.method_10211();
        drops.addAll((Collection)this.upgradeContainer.getDrops());
        for (int i = 0; i < this.patternContainer.method_5439(); ++i) {
            drops.add((Object)this.patternContainer.method_5438(i));
        }
        return drops;
    }

    void setCustomName(String name) {
        if (this.isPartOfChain()) {
            return;
        }
        this.setCustomName((class_2561)(name.trim().isBlank() ? null : class_2561.method_43470((String)name)));
        this.method_5431();
    }

    LockMode getLockMode() {
        return this.lockMode;
    }

    void setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
        this.locked = false;
        this.wasPowered = false;
        this.method_5431();
    }

    int getPriority() {
        return ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).getPriority();
    }

    void setPriority(int priority) {
        ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).setPriority(priority);
        this.method_5431();
    }

    boolean isVisibleToTheAutocrafterManager() {
        return this.visibleToTheAutocrafterManager;
    }

    void setVisibleToTheAutocrafterManager(boolean visibleToTheAutocrafterManager) {
        this.visibleToTheAutocrafterManager = visibleToTheAutocrafterManager;
        this.method_5431();
    }

    ImportMode getImportMode() {
        return this.importMode;
    }

    void setImportMode(ImportMode importMode) {
        this.importMode = importMode;
        this.method_5431();
    }

    public void method_31662(class_1937 level) {
        super.method_31662(level);
        if (level.method_8608()) {
            return;
        }
        for (int i = 0; i < this.patternContainer.method_5439(); ++i) {
            this.patternChanged(i);
        }
    }

    protected void initialize(class_3218 level, class_2350 direction) {
        super.initialize(level, direction);
        this.invalidateSinkKey();
        for (int i = 0; i < class_2350.values().length; ++i) {
            class_2350 incomingDirection = class_2350.values()[i];
            class_2338 sourcePosition = this.field_11867.method_10093(direction);
            this.sinks[i] = RefinedStorageApi.INSTANCE.getPatternProviderExternalPatternSinkFactory().create(level, sourcePosition, incomingDirection);
        }
        ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).setImportMode(this::getImportMode);
        ImporterTransferStrategy strategy = AbstractTieredImporterBlockEntity.createStrategy(level, direction, this.field_11867, this.upgradeContainer);
        LOGGER.debug("Initialized autocrafter at {} with strategy {}", (Object)this.field_11867, (Object)strategy);
        ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).setTransferStrategy(strategy);
    }

    public void patternChanged(int slot) {
        if (this.field_11863 == null) {
            return;
        }
        Pattern pattern = RefinedStorageApi.INSTANCE.getPattern(this.patternContainer.method_5438(slot), this.field_11863).orElse(null);
        ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).setPattern(slot, pattern);
        ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).updatePatternOutputFilter(slot, pattern);
    }

    public void doWork() {
        for (int i = 0; i < this.tier.getSpeed(CableType.AUTOCRAFTER); ++i) {
            super.doWork();
        }
        if (((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).isActive()) {
            ++this.ticks;
        }
        this.updateLocked();
    }

    private void updateLocked() {
        boolean newLocked = this.calculateLocked();
        if (newLocked != this.locked) {
            this.setLocked(newLocked);
        }
    }

    private void setLocked(boolean locked) {
        this.locked = locked;
        this.method_5431();
    }

    boolean isLocked() {
        return this.locked;
    }

    private boolean calculateLocked() {
        if (this.field_11863 == null) {
            return false;
        }
        return switch (this.lockMode) {
            default -> throw new MatchException(null, null);
            case LockMode.NEVER -> false;
            case LockMode.LOCK_UNTIL_REDSTONE_PULSE_RECEIVED -> this.isLockedInPulseMode();
            case LockMode.LOCK_UNTIL_CONNECTED_MACHINE_IS_EMPTY -> {
                if (!Arrays.stream(this.sinks).filter(Objects::nonNull).allMatch(PlatformPatternProviderExternalPatternSink::isEmpty)) {
                    yield true;
                }
                yield false;
            }
            case LockMode.LOCK_UNTIL_ALL_OUTPUTS_ARE_RECEIVED -> this.locked;
            case LockMode.LOCK_UNTIL_HIGH_REDSTONE_SIGNAL -> {
                if (!this.field_11863.method_49803(this.field_11867)) {
                    yield true;
                }
                yield false;
            }
            case LockMode.LOCK_UNTIL_LOW_REDSTONE_SIGNAL -> this.field_11863.method_49803(this.field_11867);
        };
    }

    private boolean isLockedInPulseMode() {
        if (this.field_11863 != null && this.field_11863.method_49803(this.field_11867)) {
            this.wasPowered = true;
            this.method_5431();
        } else if (this.wasPowered) {
            this.wasPowered = false;
            this.method_5431();
            return false;
        }
        return this.locked;
    }

    public boolean canStep(Pattern pattern) {
        PatternProvider provider = this.lookupProvider(pattern);
        if (provider == null) {
            return false;
        }
        if (provider == this.mainNetworkNode) {
            if (this.tickRate == 0) {
                return true;
            }
            return ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).isActive() && this.ticks % this.tickRate == 0;
        }
        return provider.canStep(pattern);
    }

    public int getSteps(Pattern pattern) {
        PatternProvider provider = this.lookupProvider(pattern);
        if (provider == null) {
            return 0;
        }
        if (provider == this.mainNetworkNode) {
            return this.steps;
        }
        return provider.getSteps(pattern);
    }

    private static int getSteps(int amountOfSpeedUpgrades, CableTiers tier) {
        int speed = switch (amountOfSpeedUpgrades) {
            case 1 -> 2;
            case 2 -> 3;
            case 3 -> 4;
            case 4 -> 5;
            default -> 1;
        };
        return speed * tier.getSpeed(CableType.AUTOCRAFTER);
    }

    private static int getTickRate(int amountOfSpeedUpgrades, CableTiers tier) {
        int speed = switch (amountOfSpeedUpgrades) {
            case 0 -> 10;
            case 1 -> 8;
            case 2 -> 6;
            case 3 -> 4;
            case 4 -> 2;
            default -> 0;
        };
        return Math.max(0, speed / tier.getSpeed(CableType.AUTOCRAFTER));
    }

    @Nullable
    private PatternProvider lookupProvider(Pattern pattern) {
        Network network = ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).getNetwork();
        if (network == null) {
            return null;
        }
        return ((AutocraftingNetworkComponent)network.getComponent(AutocraftingNetworkComponent.class)).getProviderByPattern(pattern);
    }

    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(class_2680 oldBlockState, class_2680 newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange((class_2680)oldBlockState, (class_2680)newBlockState);
    }

    @Nullable
    public ExternalPatternSinkKey getKey() {
        if (this.sinkKey == null) {
            this.tryUpdateSinkKey();
        }
        return this.sinkKey;
    }

    private void tryUpdateSinkKey() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        class_2350 direction = AbstractDirectionalBlock.tryExtractDirection((class_2680)this.method_11010());
        if (direction == null) {
            return;
        }
        TieredAutocrafterBlockEntity root = this.getChainingRoot();
        class_2586 connectedMachine = root.getConnectedMachine();
        if (connectedMachine == null) {
            this.invalidateSinkKey();
            return;
        }
        class_2680 connectedMachineState = connectedMachine.method_11010();
        class_1657 fakePlayer = this.getFakePlayer(serverLevel);
        class_1799 connectedMachineStack = com.refinedmods.refinedstorage.common.Platform.INSTANCE.getBlockAsItemStack(connectedMachineState.method_26204(), connectedMachineState, direction.method_10153(), (class_4538)serverLevel, connectedMachine.method_11016(), fakePlayer);
        this.sinkKey = new InWorldExternalPatternSinkKey(this.method_5477().getString(), connectedMachineStack);
    }

    private void invalidateSinkKey() {
        this.sinkKey = null;
    }

    public ExternalPatternSink.Result accept(Collection<ResourceAmount> resources, Action action) {
        TieredAutocrafterBlockEntity root = this.getChainingRoot();
        if (root != this) {
            return root.accept(resources, action);
        }
        if (Arrays.stream(this.sinks).allMatch(Objects::isNull)) {
            return ExternalPatternSink.Result.SKIPPED;
        }
        if (this.locked) {
            return ExternalPatternSink.Result.LOCKED;
        }
        class_2350 baseDirection = AbstractDirectionalBlock.tryExtractDirection((class_2680)this.method_11010());
        return TieredAutocrafterBlockEntity.findResult(this.sinks, (FilteredContainer)this.patternContainer, baseDirection, resources, action, this::updateLockedAfterAccept);
    }

    public static ExternalPatternSink.Result findResult(PlatformPatternProviderExternalPatternSink[] sinks, FilteredContainer patternContainer, @Nullable class_2350 baseDirection, Collection<ResourceAmount> resources, Action action, BiConsumer<Action, ExternalPatternSink.Result> afterAccept) {
        class_2350 fallbackDirection;
        SidedInputPatternState sidedInputState = TieredAutocrafterBlockEntity.findSidedInputPatternState(patternContainer);
        class_2350 class_23502 = fallbackDirection = baseDirection != null ? baseDirection.method_10153() : null;
        if (sidedInputState != null) {
            ArrayList<ExternalPatternSink.Result> results = new ArrayList<ExternalPatternSink.Result>();
            for (Optional<SidedResourceAmount> optionalResource : sidedInputState.sidedResources()) {
                if (optionalResource.isEmpty()) continue;
                SidedResourceAmount sidedResource = optionalResource.get();
                ResourceAmount resource = sidedResource.resource();
                class_2350 targetDirection = sidedResource.inputDirection().orElse(fallbackDirection);
                if (targetDirection == null) continue;
                ExternalPatternSink.Result result = sinks[targetDirection.ordinal()].accept(Set.of(resource), action);
                afterAccept.accept(action, result);
                results.add(result);
            }
            if (!results.isEmpty()) {
                return TieredAutocrafterBlockEntity.getMostImportantResult(results);
            }
        }
        if (baseDirection == null) {
            return ExternalPatternSink.Result.REJECTED;
        }
        ExternalPatternSink.Result result = sinks[baseDirection.method_10153().ordinal()].accept(resources, action);
        afterAccept.accept(action, result);
        return result;
    }

    @Nullable
    public static SidedInputPatternState findSidedInputPatternState(FilteredContainer patternContainer) {
        for (int i = 0; i < patternContainer.method_5439(); ++i) {
            int idx;
            class_1799 pattern = patternContainer.method_5438(i);
            ProcessingPatternState processingState = (ProcessingPatternState)pattern.method_57824(DataComponents.INSTANCE.getProcessingPatternState());
            SidedInputPatternState sidedInputState = (SidedInputPatternState)pattern.method_57824(com.ultramega.cabletiers.common.registry.DataComponents.INSTANCE.getSidedInputPatternState());
            if (processingState == null || sidedInputState == null) continue;
            List<Optional<SidedResourceAmount>> sidedResources = sidedInputState.sidedResources();
            List ingredients = processingState.ingredients();
            boolean indicesMatch = true;
            if (sidedResources.size() > ingredients.size()) {
                for (idx = ingredients.size(); idx < sidedResources.size(); ++idx) {
                    if (!sidedResources.get(idx).isPresent()) continue;
                    indicesMatch = false;
                    break;
                }
            }
            for (idx = 0; indicesMatch && idx < Math.min(sidedResources.size(), ingredients.size()); ++idx) {
                Optional<SidedResourceAmount> sidedResourceOptional = sidedResources.get(idx);
                if (sidedResourceOptional.isEmpty()) continue;
                Optional ingredientOptional = (Optional)ingredients.get(idx);
                if (ingredientOptional.isEmpty()) {
                    indicesMatch = false;
                    break;
                }
                ResourceAmount sidedResource = sidedResourceOptional.get().resource();
                ResourceAmount ingResource = ((ProcessingPatternState.ProcessingIngredient)ingredientOptional.get()).input();
                if (ingResource.equals((Object)sidedResource)) continue;
                indicesMatch = false;
                break;
            }
            if (!indicesMatch) continue;
            return sidedInputState;
        }
        return null;
    }

    public static ExternalPatternSink.Result getMostImportantResult(List<ExternalPatternSink.Result> results) {
        for (ExternalPatternSink.Result result : results) {
            if (result != ExternalPatternSink.Result.ACCEPTED) continue;
            return result;
        }
        return results.getFirst();
    }

    private void updateLockedAfterAccept(Action action, ExternalPatternSink.Result result) {
        if (result == ExternalPatternSink.Result.ACCEPTED && action == Action.EXECUTE && this.lockMode == LockMode.LOCK_UNTIL_CONNECTED_MACHINE_IS_EMPTY) {
            this.updateLocked();
        }
        if (result == ExternalPatternSink.Result.ACCEPTED && action == Action.EXECUTE && (this.lockMode == LockMode.LOCK_UNTIL_REDSTONE_PULSE_RECEIVED || this.lockMode == LockMode.LOCK_UNTIL_ALL_OUTPUTS_ARE_RECEIVED)) {
            this.setLocked(true);
        }
    }

    public void receivedExternalIteration() {
        TieredAutocrafterBlockEntity root = this.getChainingRoot();
        if (root != this) {
            root.receivedExternalIteration();
            return;
        }
        if (this.lockMode == LockMode.LOCK_UNTIL_ALL_OUTPUTS_ARE_RECEIVED && this.locked) {
            this.setLocked(false);
        }
    }

    public void completedOrCancelledTask(Task task) {
        ((ExtendedPatternProviderNetworkNode)this.mainNetworkNode).removeRequestedResourceFilter(task);
    }
}

