/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.neoforge.capability;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import com.refinedmods.refinedstorage.mekanism.ChemicalResourceType;
import com.refinedmods.refinedstorage.mekanism.ResourceContainerChemicalHandlerAdapter;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;

public class ImprovedResourceContainerChemicalHandlerAdapter
extends ResourceContainerChemicalHandlerAdapter {
    private final ResourceContainer container;

    public ImprovedResourceContainerChemicalHandlerAdapter(ResourceContainer container) {
        super(container);
        this.container = container;
    }

    public void setChemicalInTank(int tank, ChemicalStack chemicalStack) {
        if (chemicalStack.isEmpty()) {
            this.container.remove(tank);
        } else {
            ChemicalResource resource = ChemicalResource.ofChemicalStack((ChemicalStack)chemicalStack);
            long amount = Math.min(chemicalStack.getAmount(), Math.max(this.container.getMaxAmount((ResourceKey)resource), ChemicalResourceType.INSTANCE.getInterfaceExportLimit()));
            this.container.set(tank, new ResourceAmount((ResourceKey)resource, amount));
        }
    }

    public long getChemicalTankCapacity(int tank) {
        PlatformResourceKey resource = this.container.getResource(tank);
        if (resource == null || resource instanceof ChemicalResource) {
            return Math.max(this.container.getMaxAmount((ResourceKey)(resource == null ? ChemicalResource.ofChemicalStack((ChemicalStack)ChemicalStack.EMPTY) : resource)), ChemicalResourceType.INSTANCE.getInterfaceExportLimit());
        }
        return 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ChemicalStack insertChemical(int tank, ChemicalStack chemicalStack, Action action) {
        Chemical otherChemical;
        ResourceAmount currentResource = this.container.get(tank);
        if (currentResource == null) {
            return this.insertChemicalInEmptyTank(tank, chemicalStack, action);
        }
        ResourceKey resourceKey = currentResource.resource();
        if (!(resourceKey instanceof ChemicalResource)) return chemicalStack;
        ChemicalResource chemicalResource = (ChemicalResource)resourceKey;
        try {
            Chemical chemical;
            otherChemical = chemical = chemicalResource.chemical();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (otherChemical != chemicalStack.getChemical()) return chemicalStack;
        return this.insertChemicalInFilledTank(tank, chemicalStack, action, currentResource);
    }

    private ChemicalStack insertChemicalInFilledTank(int tank, ChemicalStack chemicalStack, Action action, ResourceAmount currentResource) {
        long remainder;
        long currentAmount = currentResource.amount();
        long toInsert = Math.min(chemicalStack.getAmount(), Math.max(this.container.getMaxAmount(currentResource.resource()), ChemicalResourceType.INSTANCE.getInterfaceExportLimit()) - currentAmount);
        if (toInsert <= 0L) {
            return chemicalStack;
        }
        if (action == Action.EXECUTE) {
            this.container.set(tank, new ResourceAmount(currentResource.resource(), currentAmount + toInsert));
        }
        if ((remainder = chemicalStack.getAmount() - toInsert) <= 0L) {
            return ChemicalStack.EMPTY;
        }
        return new ChemicalStack(chemicalStack.getChemical(), remainder);
    }

    private ChemicalStack insertChemicalInEmptyTank(int tank, ChemicalStack chemicalStack, Action action) {
        long remainder;
        ChemicalResource resource = ChemicalResource.ofChemicalStack((ChemicalStack)chemicalStack);
        long toInsert = Math.min(chemicalStack.getAmount(), Math.max(this.container.getMaxAmount((ResourceKey)resource), ChemicalResourceType.INSTANCE.getInterfaceExportLimit()));
        if (action == Action.EXECUTE) {
            this.container.set(tank, new ResourceAmount((ResourceKey)resource, toInsert));
        }
        if ((remainder = chemicalStack.getAmount() - toInsert) <= 0L) {
            return ChemicalStack.EMPTY;
        }
        return new ChemicalStack(chemicalStack.getChemical(), remainder);
    }
}

