/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.neoforge;

import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.Config;
import com.ultramega.cabletiers.common.DefaultConfig;
import com.ultramega.cabletiers.common.utils.CableTiersIdentifierUtil;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigImpl
implements Config {
    private final ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
    private final ModConfigSpec spec;
    private final Config.SimpleTieredStackEntry tieredImporters = new SimpleTieredStackEntryImpl(this, "tieredImporters", CableType.IMPORTER);
    private final Config.SimpleTieredStackEntry tieredExporters = new SimpleTieredStackEntryImpl(this, "tieredExporters", CableType.EXPORTER);
    private final Config.SimpleTieredEntry tieredDestructors = new SimpleTieredEntryImpl(this, "tieredDestructors", CableType.DESTRUCTOR, true);
    private final Config.SimpleTieredStackEntry tieredConstructors = new SimpleTieredStackEntryImpl(this, "tieredConstructors", CableType.CONSTRUCTOR);
    private final Config.SimpleTieredStackEntry tieredDiskInterfaces = new SimpleTieredStackEntryImpl(this, "tieredDiskInterfaces", CableType.DISK_INTERFACE);
    private final Config.SimpleTieredEntry tieredAutocrafters = new SimpleTieredEntryImpl(this, "tieredAutocrafters", CableType.AUTOCRAFTER, true);

    public ConfigImpl() {
        this.spec = this.builder.build();
    }

    public ModConfigSpec getSpec() {
        return this.spec;
    }

    @Override
    public Config.SimpleTieredStackEntry getTieredImporters() {
        return this.tieredImporters;
    }

    @Override
    public Config.SimpleTieredStackEntry getTieredExporters() {
        return this.tieredExporters;
    }

    @Override
    public Config.SimpleTieredEntry getTieredDestructors() {
        return this.tieredDestructors;
    }

    @Override
    public Config.SimpleTieredStackEntry getTieredConstructors() {
        return this.tieredConstructors;
    }

    @Override
    public Config.SimpleTieredStackEntry getTieredDiskInterfaces() {
        return this.tieredDiskInterfaces;
    }

    @Override
    public Config.SimpleTieredEntry getTieredAutocrafters() {
        return this.tieredAutocrafters;
    }

    private static String translationKey(String value) {
        return CableTiersIdentifierUtil.createCableTiersTranslationKey("text.autoconfig", "option." + value);
    }

    private class SimpleTieredStackEntryImpl
    extends SimpleTieredEntryImpl
    implements Config.SimpleTieredStackEntry {
        private final ModConfigSpec.BooleanValue eliteStackUpgradeIntegrated;
        private final ModConfigSpec.BooleanValue ultraStackUpgradeIntegrated;
        private final ModConfigSpec.BooleanValue megaStackUpgradeIntegrated;

        SimpleTieredStackEntryImpl(ConfigImpl configImpl, String name, CableType type) {
            super(configImpl, name, type, false);
            this.eliteStackUpgradeIntegrated = configImpl.builder.translation(ConfigImpl.translationKey(name + ".eliteStackUpgradeIntegrated")).define("eliteStackUpgradeIntegrated", DefaultConfig.isStackUpgradeIntegrated(CableTiers.ELITE, type));
            this.ultraStackUpgradeIntegrated = configImpl.builder.translation(ConfigImpl.translationKey(name + ".ultraStackUpgradeIntegrated")).define("ultraStackUpgradeIntegrated", DefaultConfig.isStackUpgradeIntegrated(CableTiers.ULTRA, type));
            this.megaStackUpgradeIntegrated = configImpl.builder.translation(ConfigImpl.translationKey(name + ".megaStackUpgradeIntegrated")).define("megaStackUpgradeIntegrated", DefaultConfig.isStackUpgradeIntegrated(CableTiers.MEGA, type));
            configImpl.builder.pop();
        }

        @Override
        public boolean hasStackUpgradeIntegrated(CableTiers tier) {
            return switch (tier) {
                default -> throw new MatchException(null, null);
                case CableTiers.ELITE -> (Boolean)this.eliteStackUpgradeIntegrated.get();
                case CableTiers.ULTRA -> (Boolean)this.ultraStackUpgradeIntegrated.get();
                case CableTiers.MEGA -> (Boolean)this.megaStackUpgradeIntegrated.get();
                case CableTiers.CREATIVE -> true;
            };
        }
    }

    private class SimpleTieredEntryImpl
    implements Config.SimpleTieredEntry {
        private final ModConfigSpec.LongValue eliteEnergyUsage;
        private final ModConfigSpec.LongValue ultraEnergyUsage;
        private final ModConfigSpec.LongValue megaEnergyUsage;
        private final ModConfigSpec.IntValue eliteSpeed;
        private final ModConfigSpec.IntValue ultraSpeed;
        private final ModConfigSpec.IntValue megaSpeed;
        private final ModConfigSpec.IntValue creativeSpeed;

        SimpleTieredEntryImpl(ConfigImpl configImpl, String name, CableType type, boolean pop) {
            configImpl.builder.translation(ConfigImpl.translationKey(name)).push(name);
            this.eliteEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey(name + ".eliteEnergyUsage")).defineInRange("eliteEnergyUsage", DefaultConfig.getUsageFor(CableTiers.ELITE, type), 0L, Long.MAX_VALUE);
            this.ultraEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey(name + ".ultraEnergyUsage")).defineInRange("ultraEnergyUsage", DefaultConfig.getUsageFor(CableTiers.ULTRA, type), 0L, Long.MAX_VALUE);
            this.megaEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey(name + ".megaEnergyUsage")).defineInRange("megaEnergyUsage", DefaultConfig.getUsageFor(CableTiers.MEGA, type), 0L, Long.MAX_VALUE);
            this.eliteSpeed = configImpl.builder.translation(ConfigImpl.translationKey(name + ".eliteSpeed")).defineInRange("eliteSpeed", DefaultConfig.getSpeedFor(CableTiers.ELITE, type), 1, Integer.MAX_VALUE);
            this.ultraSpeed = configImpl.builder.translation(ConfigImpl.translationKey(name + ".ultraSpeed")).defineInRange("ultraSpeed", DefaultConfig.getSpeedFor(CableTiers.ULTRA, type), 1, Integer.MAX_VALUE);
            this.megaSpeed = configImpl.builder.translation(ConfigImpl.translationKey(name + ".megaSpeed")).defineInRange("megaSpeed", DefaultConfig.getSpeedFor(CableTiers.MEGA, type), 1, Integer.MAX_VALUE);
            this.creativeSpeed = configImpl.builder.translation(ConfigImpl.translationKey(name + ".creativeSpeed")).defineInRange("creativeSpeed", DefaultConfig.getSpeedFor(CableTiers.CREATIVE, type), 1, Integer.MAX_VALUE);
            if (pop) {
                configImpl.builder.pop();
            }
        }

        @Override
        public long getEnergyUsage(CableTiers tier) {
            return switch (tier) {
                default -> throw new MatchException(null, null);
                case CableTiers.ELITE -> (Long)this.eliteEnergyUsage.get();
                case CableTiers.ULTRA -> (Long)this.ultraEnergyUsage.get();
                case CableTiers.MEGA -> (Long)this.megaEnergyUsage.get();
                case CableTiers.CREATIVE -> 0L;
            };
        }

        @Override
        public int getSpeed(CableTiers tier) {
            return switch (tier) {
                default -> throw new MatchException(null, null);
                case CableTiers.ELITE -> (Integer)this.eliteSpeed.get();
                case CableTiers.ULTRA -> (Integer)this.ultraSpeed.get();
                case CableTiers.MEGA -> (Integer)this.megaSpeed.get();
                case CableTiers.CREATIVE -> (Integer)this.creativeSpeed.get();
            };
        }
    }
}

