/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.storage.diskinterface;

import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.content.BlockConstants;
import com.refinedmods.refinedstorage.common.support.AbstractActiveColoredDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.BaseBlockItem;
import com.refinedmods.refinedstorage.common.support.BlockItemProvider;
import com.refinedmods.refinedstorage.common.support.NetworkNodeBlockItem;
import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import com.refinedmods.refinedstorage.common.support.direction.BiDirectionType;
import com.refinedmods.refinedstorage.common.support.direction.DirectionType;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.registry.BlockEntities;
import com.ultramega.cabletiers.common.registry.Blocks;
import com.ultramega.cabletiers.common.storage.AdvancedStorageTransferNetworkNode;
import com.ultramega.cabletiers.common.storage.TieredDiskContainerBlockEntityTicker;
import com.ultramega.cabletiers.common.storage.diskinterface.AbstractTieredDiskInterfaceBlockEntity;
import com.ultramega.cabletiers.common.utils.BlockEntityTierProvider;
import com.ultramega.cabletiers.common.utils.CableTiersIdentifierUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TieredDiskInterfaceBlock
extends AbstractActiveColoredDirectionalBlock<BiDirection, TieredDiskInterfaceBlock, BaseBlockItem>
implements EntityBlock,
BlockItemProvider<BaseBlockItem> {
    private static final Component HELP_1 = IdentifierUtil.createTranslation((String)"item", (String)"disk_interface.help");
    private static final Component HELP_2 = CableTiersIdentifierUtil.createCableTiersTranslation("item", "tiered_cable.help");
    private static final Component HELP_3 = CableTiersIdentifierUtil.createCableTiersTranslation("item", "tiered_cable.help.stack_upgrade");
    private final TieredDiskContainerBlockEntityTicker<AdvancedStorageTransferNetworkNode, AbstractTieredDiskInterfaceBlockEntity> ticker;
    private final CableTiers tier;
    private final BlockEntityTierProvider<AbstractTieredDiskInterfaceBlockEntity> blockEntityProvider;

    public TieredDiskInterfaceBlock(DyeColor color, MutableComponent name, CableTiers tier, BlockEntityTierProvider<AbstractTieredDiskInterfaceBlockEntity> blockEntityProvider) {
        super(BlockConstants.PROPERTIES, color, name);
        this.tier = tier;
        this.blockEntityProvider = blockEntityProvider;
        this.ticker = new TieredDiskContainerBlockEntityTicker(() -> BlockEntities.INSTANCE.getTieredDiskInterfaces(tier), ACTIVE);
    }

    protected DirectionType<BiDirection> getDirectionType() {
        return BiDirectionType.INSTANCE;
    }

    @Nullable
    public <O extends BlockEntity> BlockEntityTicker<O> getTicker(Level level, BlockState blockState, BlockEntityType<O> type) {
        return this.ticker.get(level, type);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return this.blockEntityProvider.create(this.tier, blockPos, blockState);
    }

    public BlockColorMap<TieredDiskInterfaceBlock, BaseBlockItem> getBlockColorMap() {
        return Blocks.INSTANCE.getTieredDiskInterfaces(this.tier);
    }

    public BaseBlockItem createBlockItem() {
        return new NetworkNodeBlockItem((Block)this, null){

            public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
                return Optional.of(new HelpTooltipComponent((Component)Component.literal((String)(HELP_1.getString() + " " + String.format(HELP_2.getString(), TieredDiskInterfaceBlock.this.tier.getSpeed(CableType.IMPORTER) + "x", TieredDiskInterfaceBlock.this.tier.getFilterSlotsCount()) + (String)(TieredDiskInterfaceBlock.this.tier != CableTiers.ELITE ? " " + HELP_3.getString() : "")))));
            }
        };
    }

    public boolean canAlwaysConnect() {
        return true;
    }
}

